/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.wouterdanes.docker.remoteapi.BaseService;
import net.wouterdanes.docker.remoteapi.exception.ContainerNotFoundException;
import net.wouterdanes.docker.remoteapi.exception.DockerException;
import net.wouterdanes.docker.remoteapi.model.ContainerCreateRequest;
import net.wouterdanes.docker.remoteapi.model.ContainerCreateResponse;
import net.wouterdanes.docker.remoteapi.model.ContainerInspectionResult;
import net.wouterdanes.docker.remoteapi.model.ContainerStartRequest;

public class ContainersService
extends BaseService {
    public ContainersService(String dockerApiRoot) {
        super(dockerApiRoot, "/containers");
    }

    public String createContainer(ContainerCreateRequest containerCreateRequest) {
        String createResponseStr;
        try {
            createResponseStr = (String)this.getServiceEndPoint().path("/create").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)this.toJson(containerCreateRequest), (MediaType)MediaType.APPLICATION_JSON_TYPE), String.class);
        }
        catch (WebApplicationException e) {
            throw ContainersService.makeImageTargetingException(containerCreateRequest.getImage(), e);
        }
        ContainerCreateResponse createResponse = this.toObject(createResponseStr, ContainerCreateResponse.class);
        return createResponse.getId();
    }

    public void deleteContainer(String id) {
        Response response = this.getServiceEndPoint().path(id).queryParam("v", new Object[]{1}).request().delete();
        Response.StatusType statusInfo = response.getStatusInfo();
        response.close();
        ContainersService.checkContainerTargetingResponse(id, statusInfo);
    }

    public String getLogs(String containerId) {
        byte[] bytes = (byte[])this.getServiceEndPoint().path(containerId).path("logs").queryParam("stdout", new Object[]{1}).queryParam("stderr", new Object[]{1}).request(new String[]{"application/vnd.docker.raw-stream"}).get(byte[].class);
        StringBuilder logs = new StringBuilder();
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        while (bb.hasRemaining()) {
            bb.position(bb.position() + 4);
            int frameLength = Math.min(bb.getInt(), bb.remaining());
            byte[] frame = new byte[frameLength];
            bb.get(frame);
            logs.append(new String(frame, Charset.forName("UTF-8")));
        }
        return logs.toString();
    }

    public ContainerInspectionResult inspectContainer(String containerId) {
        String json = (String)this.getServiceEndPoint().path(containerId).path("json").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
        return this.toObject(json, ContainerInspectionResult.class);
    }

    public void killContainer(String id) {
        Response response = this.getServiceEndPoint().path(id).path("/kill").request().method("POST");
        Response.StatusType statusInfo = response.getStatusInfo();
        response.close();
        ContainersService.checkContainerTargetingResponse(id, statusInfo);
    }

    public void startContainer(String id, ContainerStartRequest configuration) {
        Response response = this.getServiceEndPoint().path(id).path("/start").request().post(Entity.entity((Object)this.toJson(configuration), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        Response.StatusType statusInfo = response.getStatusInfo();
        response.close();
        ContainersService.checkContainerTargetingResponse(id, statusInfo);
    }

    public void stopContainer(String id) {
        Response response = this.getServiceEndPoint().path(id).path("/stop").queryParam("t", new Object[]{10}).request().method("POST");
        Response.StatusType statusInfo = response.getStatusInfo();
        response.close();
        ContainersService.checkContainerTargetingResponse(id, statusInfo);
    }

    private static void checkContainerTargetingResponse(String id, Response.StatusType statusInfo) {
        switch (statusInfo.getStatusCode()) {
            case 404: {
                throw new ContainerNotFoundException(id);
            }
            case 500: {
                throw new DockerException(statusInfo.getReasonPhrase());
            }
        }
    }
}

