/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi;

import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.wouterdanes.docker.remoteapi.BaseService;
import net.wouterdanes.docker.remoteapi.model.ImageDescriptor;

public class ImagesService
extends BaseService {
    public ImagesService(String dockerApiRoot) {
        super(dockerApiRoot, "/images");
    }

    public void deleteImage(String imageId) {
        try {
            this.getServiceEndPoint().path(imageId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(String.class);
        }
        catch (WebApplicationException e) {
            throw ImagesService.makeImageTargetingException("Cannot remove image", e);
        }
    }

    public String pullImage(String image) {
        ImageDescriptor descriptor = new ImageDescriptor(image);
        WebTarget target = this.getServiceEndPoint().path("create");
        target = target.queryParam("fromImage", new Object[]{descriptor.getRegistryRepositoryAndImage()});
        if (descriptor.getTag().isPresent()) {
            target = target.queryParam("tag", new Object[]{descriptor.getTag().get()});
        }
        return (String)target.request().header("X-Registry-Auth", (Object)this.getRegistryAuthHeaderValue()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null, String.class);
    }

    public String pushImage(String nameAndTag) {
        try {
            WebTarget target = this.createPushRequestFromTag(nameAndTag);
            return (String)target.request().header("X-Registry-Auth", (Object)this.getRegistryAuthHeaderValue()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null, String.class);
        }
        catch (WebApplicationException e) {
            throw ImagesService.makeImageTargetingException(nameAndTag, e);
        }
    }

    public void tagImage(String imageId, String nameAndTag) {
        ImageDescriptor descriptor = new ImageDescriptor(nameAndTag);
        WebTarget target = this.getServiceEndPoint().path(imageId).path("tag").queryParam("repo", new Object[]{descriptor.getRegistryRepositoryAndImage()}).queryParam("force", new Object[]{1});
        Optional<String> targetTag = descriptor.getTag();
        if (targetTag.isPresent()) {
            target = target.queryParam("tag", new Object[]{targetTag.get()});
        }
        Response response = target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
        Response.StatusType statusInfo = response.getStatusInfo();
        response.close();
        ImagesService.checkImageTargetingResponse(imageId, statusInfo);
    }

    private WebTarget createPushRequestFromTag(String nameAndTag) {
        ImageDescriptor descriptor = new ImageDescriptor(nameAndTag);
        WebTarget target = this.getServiceEndPoint().path(descriptor.getRegistryRepositoryAndImage()).path("push");
        if (descriptor.getTag().isPresent()) {
            target = target.queryParam("tag", new Object[]{descriptor.getTag().get()});
        }
        return target;
    }
}

