/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi.model;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class ContainerInspectionResult {
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Created")
    private Calendar createdAt;
    @JsonProperty(value="Path")
    private String path;
    @JsonProperty(value="Args")
    private List<String> args;
    @JsonProperty(value="Config")
    private Config config;
    @JsonProperty(value="NetworkSettings")
    private NetworkSettings networkSettings;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public Config getConfig() {
        return this.config;
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public static class NetworkSettings {
        @JsonProperty(value="Bridge")
        private String bridge;
        @JsonProperty(value="Gateway")
        private String gateway;
        @JsonProperty(value="IPAddress")
        private String ipAddress;
        @JsonProperty(value="IPPrefixLen")
        private int ipPrefixLen;
        @JsonProperty(value="Ports")
        private Map<String, List<PortMappingInfo>> ports;

        public String getBridge() {
            return this.bridge;
        }

        public String getGateway() {
            return this.gateway;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public int getIpPrefixLen() {
            return this.ipPrefixLen;
        }

        public Map<String, List<PortMappingInfo>> getPorts() {
            return Collections.unmodifiableMap(this.ports);
        }

        public static class PortMappingInfo {
            @JsonProperty(value="HostIp")
            private String hostIp;
            @JsonProperty(value="HostPort")
            private int hostPort;

            public String getHostIp() {
                return this.hostIp;
            }

            public int getHostPort() {
                return this.hostPort;
            }
        }
    }

    public static class Config {
        @JsonProperty(value="Hostname")
        private String hostname;
        @JsonProperty(value="Domainname")
        private String domainName;
        @JsonProperty(value="User")
        private String user;
        @JsonProperty(value="Memory")
        private Long memory;
        @JsonProperty(value="MemorySwap")
        private Long memorySwap;
        @JsonProperty(value="AttachStdin")
        private Boolean attachStdin;
        @JsonProperty(value="AttachStdout")
        private Boolean attachStdout;
        @JsonProperty(value="AttachStderr")
        private Boolean attachStderr;
        @JsonProperty(value="ExposedPorts")
        private Map<String, Map> exposedPorts;
        @JsonProperty(value="Tty")
        private Boolean tty;
        @JsonProperty(value="OpenStdin")
        private Boolean openStdin;
        @JsonProperty(value="StdinOnce")
        private Boolean stdinOnce;
        @JsonProperty(value="Env")
        private List<String> env;
        @JsonProperty(value="Cmd")
        private List<String> cmd;
        @JsonProperty(value="Image")
        private String image;
        @JsonProperty(value="WorkingDir")
        private String workingDir;
        @JsonProperty(value="Entrypoint")
        private List<String> entrypoint;

        public String getHostname() {
            return this.hostname;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getUser() {
            return this.user;
        }

        public Long getMemory() {
            return this.memory;
        }

        public Long getMemorySwap() {
            return this.memorySwap;
        }

        public Boolean getAttachStdin() {
            return this.attachStdin;
        }

        public Boolean getAttachStdout() {
            return this.attachStdout;
        }

        public Boolean getAttachStderr() {
            return this.attachStderr;
        }

        public Map<String, Map> getExposedPorts() {
            return Collections.unmodifiableMap(this.exposedPorts);
        }

        public Boolean getTty() {
            return this.tty;
        }

        public Boolean getOpenStdin() {
            return this.openStdin;
        }

        public Boolean getStdinOnce() {
            return this.stdinOnce;
        }

        public List<String> getEnv() {
            return this.env;
        }

        public List<String> getCmd() {
            return this.cmd;
        }

        public String getImage() {
            return this.image;
        }

        public String getWorkingDir() {
            return this.workingDir;
        }

        public List<String> getEntrypoint() {
            return this.entrypoint;
        }
    }
}

