/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.wouterdanes.docker.remoteapi.model.ContainerLink;
import org.codehaus.jackson.annotate.JsonProperty;

public class ContainerStartRequest {
    @JsonProperty(value="Binds")
    private List<String> binds;
    @JsonProperty(value="LxcConf")
    private Map<String, String> lxcConf;
    @JsonProperty(value="PortBindings")
    private Map<String, List<Map<String, String>>> portBindings;
    @JsonProperty(value="PublishAllPorts")
    private boolean publishAllPorts = false;
    @JsonProperty(value="Privileged")
    private boolean privileged = false;
    @JsonProperty(value="Links")
    private List<String> links = new ArrayList<String>();

    public ContainerStartRequest withBinds(List<String> binds) {
        this.binds = binds;
        return this;
    }

    public ContainerStartRequest withLxcConf(Map<String, String> lxcConf) {
        this.lxcConf = lxcConf;
        return this;
    }

    public ContainerStartRequest withPortBindings(Map<String, List<Map<String, String>>> portBindings) {
        this.portBindings = portBindings;
        return this;
    }

    public ContainerStartRequest withAllPortsPublished() {
        this.publishAllPorts = true;
        return this;
    }

    public ContainerStartRequest withLink(String containerName, String alias) {
        this.addLink(containerName, alias);
        return this;
    }

    public ContainerStartRequest withLinks(List<ContainerLink> links) {
        for (ContainerLink link : links) {
            this.addLink(link.getContainerId(), link.getContainerAlias());
        }
        return this;
    }

    public ContainerStartRequest makePrivileged() {
        this.privileged = true;
        return this;
    }

    public List<String> getBinds() {
        return this.binds;
    }

    public Map<String, String> getLxcConf() {
        return this.lxcConf;
    }

    public Map<String, List<Map<String, String>>> getPortBindings() {
        return this.portBindings;
    }

    public boolean isPublishAllPorts() {
        return this.publishAllPorts;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public List<String> getLinks() {
        return this.links;
    }

    private void addLink(String containerName, String alias) {
        this.links.add(String.format("%s:%s", containerName, alias));
    }
}

