/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi.model;

import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.codehaus.jackson.annotate.JsonProperty;

public class Credentials {
    public static final String DEFAULT_SERVER_NAME = "https://index.docker.io/v1/";
    @JsonProperty(value="username")
    private final String userName;
    @JsonProperty
    private final String password;
    @JsonProperty
    private final String email;
    @JsonProperty(value="serveraddress")
    private final String serverAddress;

    public Credentials(String userName, String password, String email, String serverAddress) {
        Validate.notBlank((CharSequence)userName, (String)"Username was null or empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)password, (String)"Password was null or empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)email, (String)"Emails was null or empty", (Object[])new Object[0]);
        this.userName = userName;
        this.password = password;
        this.email = email;
        this.serverAddress = Optional.ofNullable(serverAddress).orElse(DEFAULT_SERVER_NAME);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return "Credentials [userName=" + this.userName + ", password=********" + ", email=" + this.email + ", serverAddress=" + this.serverAddress + "]";
    }
}

