/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes.docker.remoteapi.util;

import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import net.wouterdanes.docker.remoteapi.util.DockerEnvironmentSupplier;

public final class DockerHostFromEnvironmentSupplier
extends DockerEnvironmentSupplier
implements Supplier<Optional<String>> {
    public static final DockerHostFromEnvironmentSupplier INSTANCE = new DockerHostFromEnvironmentSupplier();

    private DockerHostFromEnvironmentSupplier() {
    }

    @Override
    public Optional<String> get() {
        Optional<URI> dockerUriFromEnvironment = this.getDockerUriFromEnvironment();
        if (!dockerUriFromEnvironment.isPresent()) {
            return Optional.empty();
        }
        URI dockerUrl = dockerUriFromEnvironment.get();
        boolean isTcpSocket = "tcp".equalsIgnoreCase(dockerUrl.getScheme());
        return isTcpSocket ? Optional.ofNullable(dockerUrl.getHost()) : Optional.empty();
    }
}

