/*
 * Decompiled with CFR 0.152.
 */
package net.wushilin.combperm;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.wushilin.combperm.CombPermBase;
import net.wushilin.combperm.CombinationIterator;

public class CombinationIterable<T>
extends CombPermBase
implements Iterable<List<T>> {
    private List<T> candidates;
    private int choose;

    public CombinationIterable(List<T> candidates, int choose) {
        this.candidates = candidates;
        this.choose = choose;
        if (candidates == null || choose < 0 || choose > candidates.size()) {
            throw new IllegalArgumentException("Candidates can't be null, choose must between [0, candidates.size]");
        }
        this.checkDistinct(candidates);
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new CombinationIterator<T>().init(this.candidates, this.choose);
    }

    public Stream<List<T>> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }
}

