/*
 * Decompiled with CFR 0.152.
 */
package net.wushilin.combperm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.wushilin.combperm.CombPermBase;

class CombinationIterator<T>
extends CombPermBase
implements Iterator<List<T>> {
    private List<T> candidates;
    private BitSet bitSet;
    private List<T> resultList;
    private boolean hasResult = true;

    public CombinationIterator<T> init(List<T> candidates, int choose) {
        if (candidates == null || choose < 0 || choose > candidates.size()) {
            throw new IllegalArgumentException("Candidates can't be null, choose must between [0, candidates.size]");
        }
        int candidateSize = candidates.size();
        this.candidates = new ArrayList<T>(candidates.size());
        this.candidates.addAll(candidates);
        this.bitSet = new BitSet(candidateSize);
        for (int count = 0; count < choose; ++count) {
            this.bitSet.set(candidateSize - count - 1);
        }
        this.resultList = new ArrayList<T>(choose);
        this.hasResult = true;
        this.checkDistinct(candidates);
        return this;
    }

    private int searchForLast01() {
        int nextSetBit;
        int lastCheckedSetBit = this.candidates.size() - 1;
        do {
            if ((nextSetBit = this.bitSet.previousSetBit(lastCheckedSetBit)) < 1) {
                return -1;
            }
            if (this.bitSet.get(nextSetBit - 1)) continue;
            return nextSetBit - 1;
        } while ((lastCheckedSetBit = nextSetBit - 1) >= 1);
        return -1;
    }

    private List<T> getCurrentResult() {
        this.resultList.clear();
        int i = this.bitSet.nextSetBit(0);
        while (i != -1) {
            this.resultList.add(this.candidates.get(i));
            i = this.bitSet.nextSetBit(i + 1);
        }
        return this.resultList;
    }

    private void minimize(int index) {
        if (index >= this.candidates.size()) {
            return;
        }
        int count = 0;
        int i = this.bitSet.nextSetBit(index);
        while (i != -1) {
            this.bitSet.clear(i);
            ++count;
            i = this.bitSet.nextSetBit(i + 1);
        }
        for (i = 0; i < count; ++i) {
            this.bitSet.set(this.candidates.size() - i - 1);
        }
    }

    private void flip01(int index) {
        this.bitSet.set(index);
        this.bitSet.clear(index + 1);
        this.minimize(index + 2);
    }

    @Override
    public boolean hasNext() {
        return this.hasResult;
    }

    @Override
    public List<T> next() {
        if (!this.hasResult) {
            throw new NoSuchElementException();
        }
        List<T> result = this.getCurrentResult();
        int index = this.searchForLast01();
        if (index == -1) {
            this.hasResult = false;
        } else {
            this.flip01(index);
            this.hasResult = true;
        }
        return result;
    }
}

