/*
 * Decompiled with CFR 0.152.
 */
package net.wushilin.combperm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.wushilin.combperm.CombPermBase;

public class FullPermutationIterator<T>
extends CombPermBase
implements Iterator<List<T>> {
    private List<T> candidates;
    private int[] indexes;
    private boolean hasNext;
    private List<T> resultList;

    public FullPermutationIterator init(List<T> candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException("Candidates can't be null");
        }
        int candidateSize = candidates.size();
        this.candidates = candidates;
        this.indexes = new int[candidateSize];
        for (int i = 0; i < candidateSize; ++i) {
            this.indexes[i] = i;
        }
        this.hasNext = true;
        this.resultList = new ArrayList<T>(candidateSize);
        this.checkDistinct(candidates);
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    private List<Integer> toList(int[] input) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int next : input) {
            result.add(next);
        }
        return result;
    }

    private List<T> getCurrentList() {
        this.resultList.clear();
        for (int next : this.indexes) {
            this.resultList.add(this.candidates.get(next));
        }
        return this.resultList;
    }

    private int findLongestDecreasingSequence() {
        int currentIndex = this.candidates.size() - 1;
        if (currentIndex < 0) {
            return -1;
        }
        while (true) {
            int currentValue = this.indexes[currentIndex];
            if (currentIndex - 1 < 0) {
                return currentIndex;
            }
            int prev = this.indexes[currentIndex - 1];
            if (prev < currentValue) {
                return currentIndex;
            }
            --currentIndex;
        }
    }

    private void swap(int idx1, int idx2) {
        int tmp = this.indexes[idx1];
        this.indexes[idx1] = this.indexes[idx2];
        this.indexes[idx2] = tmp;
    }

    private boolean findNext() {
        int longestSequence = this.findLongestDecreasingSequence();
        if (longestSequence <= 0) {
            return false;
        }
        int leftValue = this.indexes[longestSequence - 1];
        int largerIndex = longestSequence;
        while (this.indexes[largerIndex] > leftValue && ++largerIndex < this.candidates.size()) {
        }
        this.swap(longestSequence - 1, --largerIndex);
        Arrays.sort(this.indexes, longestSequence, this.candidates.size());
        return true;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        List<T> result = this.getCurrentList();
        this.hasNext = this.findNext();
        return result;
    }
}

