/*
 * Decompiled with CFR 0.152.
 */
package net.wushilin.combperm;

import java.util.Iterator;
import java.util.List;
import net.wushilin.combperm.CombPermBase;
import net.wushilin.combperm.CombinationIterator;
import net.wushilin.combperm.FullPermutationIterator;

public class PermutationIterator<T>
extends CombPermBase
implements Iterator<List<T>> {
    private CombinationIterator<T> outerIterator;
    private FullPermutationIterator<T> innerIterator;

    public PermutationIterator<T> init(List<T> elements, int choose) {
        if (elements == null || choose < 0 || choose > elements.size()) {
            throw new IllegalArgumentException("Candidates can't be null, choose must between [0, candidates.size]");
        }
        this.outerIterator = new CombinationIterator<T>().init(elements, choose);
        Object firstBatch = this.outerIterator.next();
        this.innerIterator = new FullPermutationIterator().init(firstBatch);
        this.checkDistinct(elements);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.innerIterator.hasNext()) {
            return true;
        }
        if (this.outerIterator.hasNext()) {
            Object selection = this.outerIterator.next();
            this.innerIterator.init((List<T>)selection);
            return this.innerIterator.hasNext();
        }
        return false;
    }

    @Override
    public List<T> next() {
        return this.innerIterator.next();
    }
}

