/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleElement;
import org.h2.bnf.RuleExtension;
import org.h2.bnf.RuleFixed;
import org.h2.bnf.RuleHead;
import org.h2.bnf.RuleList;
import org.h2.bnf.RuleOptional;
import org.h2.bnf.RuleRepeat;
import org.h2.bnf.Sentence;
import org.h2.bnf.context.DbContextRule;
import org.h2.command.dml.Help;
import org.h2.tools.Csv;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class Bnf {
    private final HashMap<String, RuleHead> ruleMap = new HashMap();
    private String syntax;
    private String currentToken;
    private String[] tokens;
    private char firstChar;
    private int index;
    private Rule lastRepeat;
    private ArrayList<RuleHead> statements;
    private String currentTopic;

    public static Bnf getInstance(Reader csv) throws SQLException, IOException {
        Bnf bnf = new Bnf();
        if (csv == null) {
            byte[] data = Utils.getResource("/org/h2/res/help.csv");
            csv = new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8);
        }
        bnf.parse(csv);
        return bnf;
    }

    public void addAlias(String name, String replacement) {
        RuleHead head = this.ruleMap.get(replacement);
        this.ruleMap.put(name, head);
    }

    private void addFixedRule(String name, int fixedType) {
        RuleFixed rule = new RuleFixed(fixedType);
        this.addRule(name, "Fixed", rule);
    }

    private RuleHead addRule(String topic, String section, Rule rule) {
        RuleHead head = new RuleHead(section, topic, rule);
        String key = StringUtils.toLowerEnglish(topic.trim().replace(' ', '_'));
        if (this.ruleMap.putIfAbsent(key, head) != null) {
            throw new AssertionError((Object)("already exists: " + topic));
        }
        return head;
    }

    private void parse(Reader reader) throws SQLException, IOException {
        Rule functions = null;
        this.statements = new ArrayList();
        Csv csv = new Csv();
        csv.setLineCommentCharacter('#');
        ResultSet rs = csv.read(reader, null);
        while (rs.next()) {
            String section = rs.getString("SECTION").trim();
            if (section.startsWith("System")) continue;
            String topic = rs.getString("TOPIC");
            this.syntax = Help.stripAnnotationsFromSyntax(rs.getString("SYNTAX"));
            this.currentTopic = section;
            this.tokens = this.tokenize();
            this.index = 0;
            Rule rule = this.parseRule();
            if (section.startsWith("Command")) {
                rule = new RuleList(rule, new RuleElement(";\n\n", this.currentTopic), false);
            }
            RuleHead head = this.addRule(topic, section, rule);
            if (section.startsWith("Function")) {
                if (functions == null) {
                    functions = rule;
                    continue;
                }
                functions = new RuleList(rule, functions, true);
                continue;
            }
            if (!section.startsWith("Commands")) continue;
            this.statements.add(head);
        }
        this.addRule("@func@", "Function", functions);
        this.addFixedRule("@ymd@", 0);
        this.addFixedRule("@hms@", 1);
        this.addFixedRule("@nanos@", 2);
        this.addFixedRule("anything_except_single_quote", 3);
        this.addFixedRule("single_character", 3);
        this.addFixedRule("anything_except_double_quote", 4);
        this.addFixedRule("anything_until_end_of_line", 5);
        this.addFixedRule("anything_until_comment_start_or_end", 6);
        this.addFixedRule("anything_except_two_dollar_signs", 8);
        this.addFixedRule("anything", 7);
        this.addFixedRule("@hex_start@", 10);
        this.addFixedRule("@concat@", 11);
        this.addFixedRule("@az_@", 12);
        this.addFixedRule("@af@", 13);
        this.addFixedRule("@digit@", 14);
        this.addFixedRule("@open_bracket@", 15);
        this.addFixedRule("@close_bracket@", 16);
        this.addFixedRule("json_text", 17);
    }

    public void visit(BnfVisitor visitor, String s) {
        this.syntax = s;
        this.tokens = this.tokenize();
        this.index = 0;
        Rule rule = this.parseRule();
        rule.setLinks(this.ruleMap);
        rule.accept(visitor);
    }

    public static boolean startWithSpace(String s) {
        return s.length() > 0 && Character.isWhitespace(s.charAt(0));
    }

    public static String getRuleMapKey(String token) {
        StringBuilder buff = new StringBuilder();
        int l = token.length();
        for (int i = 0; i < l; ++i) {
            char ch = token.charAt(i);
            if (Character.isUpperCase(ch)) {
                buff.append('_').append(Character.toLowerCase(ch));
                continue;
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    public RuleHead getRuleHead(String title) {
        return this.ruleMap.get(title);
    }

    private Rule parseRule() {
        this.read();
        return this.parseOr();
    }

    private Rule parseOr() {
        Rule r = this.parseList();
        if (this.firstChar == '|') {
            this.read();
            r = new RuleList(r, this.parseOr(), true);
        }
        this.lastRepeat = r;
        return r;
    }

    private Rule parseList() {
        Rule r = this.parseToken();
        if (this.firstChar != '|' && this.firstChar != ']' && this.firstChar != '}' && this.firstChar != '\u0000') {
            r = new RuleList(r, this.parseList(), false);
        }
        this.lastRepeat = r;
        return r;
    }

    private RuleExtension parseExtension(boolean compatibility) {
        Rule r;
        this.read();
        if (this.firstChar == '[') {
            this.read();
            r = this.parseOr();
            r = new RuleOptional(r);
            if (this.firstChar != ']') {
                throw new AssertionError((Object)("expected ], got " + this.currentToken + " syntax:" + this.syntax));
            }
        } else if (this.firstChar == '{') {
            this.read();
            r = this.parseOr();
            if (this.firstChar != '}') {
                throw new AssertionError((Object)("expected }, got " + this.currentToken + " syntax:" + this.syntax));
            }
        } else {
            r = this.parseOr();
        }
        return new RuleExtension(r, compatibility);
    }

    private Rule parseToken() {
        Rule r;
        if (this.firstChar >= 'A' && this.firstChar <= 'Z' || this.firstChar >= 'a' && this.firstChar <= 'z') {
            r = new RuleElement(this.currentToken, this.currentTopic);
        } else if (this.firstChar == '[') {
            this.read();
            r = this.parseOr();
            r = new RuleOptional(r);
            if (this.firstChar != ']') {
                throw new AssertionError((Object)("expected ], got " + this.currentToken + " syntax:" + this.syntax));
            }
        } else if (this.firstChar == '{') {
            this.read();
            r = this.parseOr();
            if (this.firstChar != '}') {
                throw new AssertionError((Object)("expected }, got " + this.currentToken + " syntax:" + this.syntax));
            }
        } else if (this.firstChar == '@') {
            if ("@commaDots@".equals(this.currentToken)) {
                r = new RuleList(new RuleElement(",", this.currentTopic), this.lastRepeat, false);
                r = new RuleRepeat(r, true);
            } else {
                r = "@dots@".equals(this.currentToken) ? new RuleRepeat(this.lastRepeat, false) : ("@c@".equals(this.currentToken) ? this.parseExtension(true) : ("@h2@".equals(this.currentToken) ? this.parseExtension(false) : new RuleElement(this.currentToken, this.currentTopic)));
            }
        } else {
            r = new RuleElement(this.currentToken, this.currentTopic);
        }
        this.lastRepeat = r;
        this.read();
        return r;
    }

    private void read() {
        if (this.index < this.tokens.length) {
            this.currentToken = this.tokens[this.index++];
            this.firstChar = this.currentToken.charAt(0);
        } else {
            this.currentToken = "";
            this.firstChar = '\u0000';
        }
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < this.index; ++i) {
            builder.append(this.tokens[i]).append(' ');
        }
        builder.append("[*]");
        for (i = this.index; i < this.tokens.length; ++i) {
            builder.append(' ').append(this.tokens[i]);
        }
        return builder.toString();
    }

    private String[] tokenize() {
        ArrayList<String> list = new ArrayList<String>();
        this.syntax = StringUtils.replaceAll(this.syntax, "yyyy-MM-dd", "@ymd@");
        this.syntax = StringUtils.replaceAll(this.syntax, "hh:mm:ss", "@hms@");
        this.syntax = StringUtils.replaceAll(this.syntax, "hh:mm", "@hms@");
        this.syntax = StringUtils.replaceAll(this.syntax, "mm:ss", "@hms@");
        this.syntax = StringUtils.replaceAll(this.syntax, "nnnnnnnnn", "@nanos@");
        this.syntax = StringUtils.replaceAll(this.syntax, "function", "@func@");
        this.syntax = StringUtils.replaceAll(this.syntax, "0x", "@hexStart@");
        this.syntax = StringUtils.replaceAll(this.syntax, ",...", "@commaDots@");
        this.syntax = StringUtils.replaceAll(this.syntax, "...", "@dots@");
        this.syntax = StringUtils.replaceAll(this.syntax, "||", "@concat@");
        this.syntax = StringUtils.replaceAll(this.syntax, "a-z|_", "@az_@");
        this.syntax = StringUtils.replaceAll(this.syntax, "A-Z|_", "@az_@");
        this.syntax = StringUtils.replaceAll(this.syntax, "A-F", "@af@");
        this.syntax = StringUtils.replaceAll(this.syntax, "0-9", "@digit@");
        this.syntax = StringUtils.replaceAll(this.syntax, "'['", "@openBracket@");
        this.syntax = StringUtils.replaceAll(this.syntax, "']'", "@closeBracket@");
        StringTokenizer tokenizer = Bnf.getTokenizer(this.syntax);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if ((s = StringUtils.cache(s)).length() == 1 && " \r\n".indexOf(s.charAt(0)) >= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[0]);
    }

    public HashMap<String, String> getNextTokenList(String query) {
        Sentence sentence = new Sentence();
        sentence.setQuery(query);
        try {
            for (RuleHead head : this.statements) {
                if (!head.getSection().startsWith("Commands")) continue;
                sentence.start();
                if (!head.getRule().autoComplete(sentence)) continue;
                break;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return sentence.getNext();
    }

    public void linkStatements() {
        for (RuleHead r : this.ruleMap.values()) {
            r.getRule().setLinks(this.ruleMap);
        }
    }

    public void updateTopic(String topic, DbContextRule rule) {
        RuleHead head = this.ruleMap.get(topic = StringUtils.toLowerEnglish(topic));
        if (head == null) {
            head = new RuleHead("db", topic, rule);
            this.ruleMap.put(topic, head);
            this.statements.add(head);
        } else {
            head.setRule(rule);
        }
    }

    public ArrayList<RuleHead> getStatements() {
        return this.statements;
    }

    public static StringTokenizer getTokenizer(String s) {
        return new StringTokenizer(s, " [](){}|.,\r\n<>:-+*/=\"!'$", true);
    }
}

