/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;

public class RuleExtension
implements Rule {
    private final Rule rule;
    private final boolean compatibility;
    private boolean mapSet;

    public RuleExtension(Rule rule, boolean compatibility) {
        this.rule = rule;
        this.compatibility = compatibility;
    }

    @Override
    public void accept(BnfVisitor visitor) {
        visitor.visitRuleExtension(this.rule, this.compatibility);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
        if (!this.mapSet) {
            this.rule.setLinks(ruleMap);
            this.mapSet = true;
        }
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        sentence.stopIfRequired();
        this.rule.autoComplete(sentence);
        return true;
    }

    public String toString() {
        return (this.compatibility ? "@c@ " : "@h2@ ") + this.rule.toString();
    }
}

