/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.Token;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.dml.DataChangeStatement;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbSettings;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;

public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    static void clearCTE(SessionLocal session, Prepared prepared) {
        List<TableView> cteCleanups = prepared.getCteCleanups();
        if (cteCleanups != null) {
            CommandContainer.clearCTE(session, cteCleanups);
        }
    }

    static void clearCTE(SessionLocal session, List<TableView> views) {
        for (TableView view : views) {
            if (view.getName() == null) continue;
            session.removeLocalTempTable(view);
        }
    }

    public CommandContainer(SessionLocal session, String sql, Prepared prepared) {
        super(session, sql);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        ArrayList<Parameter> parameters = this.prepared.getParameters();
        if (parameters.size() > 0 && this.prepared.isWithParamValues()) {
            parameters = new ArrayList();
        }
        return parameters;
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String sql = this.prepared.getSQL();
            ArrayList<Token> tokens = this.prepared.getSQLTokens();
            Parser parser = new Parser(this.session);
            parser.setSuppliedParameters(this.prepared.getParameters());
            this.prepared = parser.parse(sql, tokens);
            long mod = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            this.prepared.prepare();
            this.prepared.setModificationMetaId(mod);
        }
    }

    @Override
    public ResultWithGeneratedKeys update(Object generatedKeysRequest) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultWithGeneratedKeys result = generatedKeysRequest != null && !Boolean.FALSE.equals(generatedKeysRequest) ? (this.prepared instanceof DataChangeStatement && this.prepared.getType() != 58 ? this.executeUpdateWithGeneratedKeys((DataChangeStatement)this.prepared, generatedKeysRequest) : new ResultWithGeneratedKeys.WithKeys(this.prepared.update(), new LocalResult())) : ResultWithGeneratedKeys.of(this.prepared.update());
        this.prepared.trace(this.startTimeNanos, result.getUpdateCount());
        this.setProgress(6);
        return result;
    }

    private ResultWithGeneratedKeys executeUpdateWithGeneratedKeys(DataChangeStatement statement, Object generatedKeysRequest) {
        int columnCount;
        ArrayList<Object> expressionColumns;
        Database db = this.session.getDatabase();
        Table table = statement.getTable();
        if (Boolean.TRUE.equals(generatedKeysRequest)) {
            expressionColumns = Utils.newSmallArrayList();
            Column[] columns = table.getColumns();
            Index primaryKey = table.findPrimaryKey();
            for (Column column : columns) {
                Expression e;
                if (!column.isIdentity() && ((e = column.getEffectiveDefaultExpression()) == null || e.isConstant()) && (primaryKey == null || primaryKey.getColumnIndex(column) < 0)) continue;
                expressionColumns.add(new ExpressionColumn(db, column));
            }
        } else if (generatedKeysRequest instanceof int[]) {
            int[] indexes = (int[])generatedKeysRequest;
            Object[] columns = table.getColumns();
            int cnt = columns.length;
            expressionColumns = new ArrayList(indexes.length);
            for (int idx : indexes) {
                if (idx < 1 || idx > cnt) {
                    throw DbException.get(42122, "Index: " + idx);
                }
                expressionColumns.add(new ExpressionColumn(db, (Column)columns[idx - 1]));
            }
        } else if (generatedKeysRequest instanceof String[]) {
            String[] names = (String[])generatedKeysRequest;
            expressionColumns = new ArrayList(names.length);
            for (String name : names) {
                Column column;
                block18: {
                    column = table.findColumn(name);
                    if (column == null) {
                        DbSettings settings = db.getSettings();
                        if (settings.databaseToUpper) {
                            column = table.findColumn(StringUtils.toUpperEnglish(name));
                        } else if (settings.databaseToLower) {
                            column = table.findColumn(StringUtils.toLowerEnglish(name));
                        }
                        if (column == null) {
                            for (Column c : table.getColumns()) {
                                if (!c.getName().equalsIgnoreCase(name)) continue;
                                column = c;
                                break block18;
                            }
                            throw DbException.get(42122, name);
                        }
                    }
                }
                expressionColumns.add(new ExpressionColumn(db, column));
            }
        } else {
            throw DbException.getInternalError();
        }
        if ((columnCount = expressionColumns.size()) == 0) {
            return new ResultWithGeneratedKeys.WithKeys(statement.update(), new LocalResult());
        }
        int[] indexes = new int[columnCount];
        Expression[] expressions = expressionColumns.toArray(new ExpressionColumn[0]);
        for (int i = 0; i < columnCount; ++i) {
            indexes[i] = expressions[i].getColumn().getColumnId();
        }
        LocalResult result = new LocalResult(this.session, expressions, columnCount, columnCount);
        return new ResultWithGeneratedKeys.WithKeys(statement.update(new GeneratedKeysCollector(indexes, result), DataChangeDeltaTable.ResultOption.FINAL), result);
    }

    @Override
    public ResultInterface query(long maxrows) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface result = this.prepared.query(maxrows);
        this.prepared.trace(this.startTimeNanos, result.isLazy() ? 0L : result.getRowCount());
        this.setProgress(6);
        return result;
    }

    @Override
    public void stop() {
        super.stop();
        CommandContainer.clearCTE(this.session, this.prepared);
    }

    @Override
    public boolean canReuse() {
        return super.canReuse() && this.prepared.getCteCleanups() == null;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }

    void clearCTE() {
        CommandContainer.clearCTE(this.session, this.prepared);
    }

    @Override
    public Set<DbObject> getDependencies() {
        HashSet<DbObject> dependencies = new HashSet<DbObject>();
        this.prepared.collectDependencies(dependencies);
        return dependencies;
    }

    @Override
    protected boolean isCurrentCommandADefineCommand() {
        return this.prepared instanceof DefineCommand;
    }

    private static final class GeneratedKeysCollector
    implements ResultTarget {
        private final int[] indexes;
        private final LocalResult result;

        GeneratedKeysCollector(int[] indexes, LocalResult result) {
            this.indexes = indexes;
            this.result = result;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public long getRowCount() {
            return 0L;
        }

        @Override
        public void addRow(Value ... values) {
            int length = this.indexes.length;
            Value[] row = new Value[length];
            for (int i = 0; i < length; ++i) {
                row[i] = values[this.indexes[i]];
            }
            this.result.addRow(row);
        }
    }
}

