/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.ListIterator;
import org.h2.command.Token;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueNumeric;

public final class Tokenizer {
    private final CastDataProvider provider;
    private final boolean identifiersToUpper;
    private final boolean identifiersToLower;
    private final BitSet nonKeywords;

    Tokenizer(CastDataProvider provider, boolean identifiersToUpper, boolean identifiersToLower, BitSet nonKeywords) {
        this.provider = provider;
        this.identifiersToUpper = identifiersToUpper;
        this.identifiersToLower = identifiersToLower;
        this.nonKeywords = nonKeywords;
    }

    ArrayList<Token> tokenize(String sql, boolean stopOnCloseParen, BitSet parameters) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int end = sql.length() - 1;
        boolean foundUnicode = false;
        int lastParameter = 0;
        int i = 0;
        block59: while (i <= end) {
            Token token;
            int tokenStart = i;
            int c = sql.charAt(i);
            switch (c) {
                case 33: {
                    char c2;
                    if (i < end) {
                        if ((c2 = sql.charAt(++i)) == '=') {
                            token = new Token.KeywordToken(tokenStart, 100);
                            break;
                        }
                        if (c2 == '~') {
                            token = new Token.KeywordToken(tokenStart, 122);
                            break;
                        }
                    }
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                case 34: 
                case 96: {
                    i = this.readQuotedIdentifier(sql, end, tokenStart, i, (char)c, false, tokens);
                    continue block59;
                }
                case 35: {
                    if (this.provider.getMode().supportPoundSymbolForColumnNames) {
                        i = this.readIdentifier(sql, end, tokenStart, i, c, tokens);
                        continue block59;
                    }
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                case 36: {
                    char c2;
                    if (i < end) {
                        c2 = sql.charAt(i + 1);
                        if (c2 == '$') {
                            int stringEnd = sql.indexOf("$$", i += 2);
                            if (stringEnd < 0) {
                                throw DbException.getSyntaxError(sql, tokenStart);
                            }
                            token = new Token.CharacterStringToken(tokenStart, sql.substring(i, stringEnd), false);
                            i = stringEnd + 1;
                            break;
                        }
                        i = Tokenizer.parseParameterIndex(sql, end, i, tokens);
                        lastParameter = Tokenizer.assignParameterIndex(tokens, lastParameter, parameters);
                        continue block59;
                    }
                    token = new Token.ParameterToken(tokenStart, 0);
                    break;
                }
                case 37: {
                    token = new Token.KeywordToken(tokenStart, 114);
                    break;
                }
                case 38: {
                    if (i < end && sql.charAt(i + 1) == '&') {
                        ++i;
                        token = new Token.KeywordToken(tokenStart, 107);
                        break;
                    }
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                case 39: {
                    i = Tokenizer.readCharacterString(sql, tokenStart, end, i, false, tokens);
                    continue block59;
                }
                case 40: {
                    token = new Token.KeywordToken(tokenStart, 105);
                    break;
                }
                case 41: {
                    token = new Token.KeywordToken(tokenStart, 106);
                    if (!stopOnCloseParen) break;
                    tokens.add(token);
                    end = Tokenizer.skipWhitespace(sql, end, i + 1) - 1;
                    break block59;
                }
                case 42: {
                    token = new Token.KeywordToken(tokenStart, 108);
                    break;
                }
                case 43: {
                    token = new Token.KeywordToken(tokenStart, 103);
                    break;
                }
                case 44: {
                    token = new Token.KeywordToken(tokenStart, 109);
                    break;
                }
                case 45: {
                    if (i < end && sql.charAt(i + 1) == '-') {
                        i = Tokenizer.skipSimpleComment(sql, end, i);
                        continue block59;
                    }
                    token = new Token.KeywordToken(tokenStart, 102);
                    break;
                }
                case 46: {
                    char c2;
                    if (i < end && (c2 = sql.charAt(i + 1)) >= '0' && c2 <= '9') {
                        i = Tokenizer.readNumeric(sql, tokenStart, end, i + 1, c2, false, false, tokens);
                        continue block59;
                    }
                    token = new Token.KeywordToken(tokenStart, 110);
                    break;
                }
                case 47: {
                    char c2;
                    if (i < end) {
                        c2 = sql.charAt(i + 1);
                        if (c2 == '*') {
                            i = Tokenizer.skipBracketedComment(sql, tokenStart, end, i);
                            continue block59;
                        }
                        if (c2 == '/') {
                            i = Tokenizer.skipSimpleComment(sql, end, i);
                            continue block59;
                        }
                    }
                    token = new Token.KeywordToken(tokenStart, 113);
                    break;
                }
                case 48: {
                    char c2;
                    if (i < end && ((c2 = sql.charAt(i + 1)) == 'X' || c2 == 'x')) {
                        i = Tokenizer.readHexNumber(sql, this.provider, tokenStart, end, i + 2, tokens);
                        continue block59;
                    }
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    i = Tokenizer.readNumeric(sql, tokenStart, end, i + 1, (char)c, tokens);
                    continue block59;
                }
                case 58: {
                    char c2;
                    if (i < end) {
                        c2 = sql.charAt(i + 1);
                        if (c2 == ':') {
                            ++i;
                            token = new Token.KeywordToken(tokenStart, 120);
                            break;
                        }
                        if (c2 == '=') {
                            ++i;
                            token = new Token.KeywordToken(tokenStart, 121);
                            break;
                        }
                    }
                    token = new Token.KeywordToken(tokenStart, 116);
                    break;
                }
                case 59: {
                    token = new Token.KeywordToken(tokenStart, 115);
                    break;
                }
                case 60: {
                    char c2;
                    if (i < end) {
                        c2 = sql.charAt(i + 1);
                        if (c2 == '=') {
                            ++i;
                            token = new Token.KeywordToken(tokenStart, 99);
                            break;
                        }
                        if (c2 == '>') {
                            ++i;
                            token = new Token.KeywordToken(tokenStart, 100);
                            break;
                        }
                    }
                    token = new Token.KeywordToken(tokenStart, 98);
                    break;
                }
                case 61: {
                    token = new Token.KeywordToken(tokenStart, 95);
                    break;
                }
                case 62: {
                    if (i < end && sql.charAt(i + 1) == '=') {
                        ++i;
                        token = new Token.KeywordToken(tokenStart, 96);
                        break;
                    }
                    token = new Token.KeywordToken(tokenStart, 97);
                    break;
                }
                case 63: {
                    char c3;
                    if (i + 1 < end && sql.charAt(i + 1) == '?') {
                        c3 = sql.charAt(i + 2);
                        if (c3 == '(') {
                            i += 2;
                            token = new Token.KeywordToken(tokenStart, 117);
                            break;
                        }
                        if (c3 == ')') {
                            i += 2;
                            token = new Token.KeywordToken(tokenStart, 118);
                            break;
                        }
                    }
                    i = Tokenizer.parseParameterIndex(sql, end, i, tokens);
                    lastParameter = Tokenizer.assignParameterIndex(tokens, lastParameter, parameters);
                    continue block59;
                }
                case 64: {
                    token = new Token.KeywordToken(tokenStart, 101);
                    break;
                }
                case 65: 
                case 97: {
                    i = this.readA(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 66: 
                case 98: {
                    i = this.readB(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 67: 
                case 99: {
                    i = this.readC(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 68: 
                case 100: {
                    i = this.readD(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 69: 
                case 101: {
                    i = this.readE(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 70: 
                case 102: {
                    i = this.readF(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 71: 
                case 103: {
                    i = this.readG(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 72: 
                case 104: {
                    i = this.readH(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 73: 
                case 105: {
                    i = this.readI(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 74: 
                case 106: {
                    i = this.readJ(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 75: 
                case 107: {
                    i = this.readK(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 76: 
                case 108: {
                    i = this.readL(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 77: 
                case 109: {
                    i = this.readM(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 78: 
                case 110: {
                    if (i < end && sql.charAt(i + 1) == '\'') {
                        i = Tokenizer.readCharacterString(sql, tokenStart, end, i + 1, false, tokens);
                        continue block59;
                    }
                    i = this.readN(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 79: 
                case 111: {
                    i = this.readO(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 80: 
                case 112: {
                    i = this.readP(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 81: 
                case 113: {
                    i = this.readQ(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 82: 
                case 114: {
                    i = this.readR(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 83: 
                case 115: {
                    i = this.readS(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 84: 
                case 116: {
                    i = this.readT(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 85: 
                case 117: {
                    char c3;
                    if (i + 1 < end && sql.charAt(i + 1) == '&') {
                        c3 = sql.charAt(i + 2);
                        if (c3 == '\"') {
                            i = this.readQuotedIdentifier(sql, end, tokenStart, i + 2, '\"', true, tokens);
                            foundUnicode = true;
                            continue block59;
                        }
                        if (c3 == '\'') {
                            i = Tokenizer.readCharacterString(sql, tokenStart, end, i + 2, true, tokens);
                            foundUnicode = true;
                            continue block59;
                        }
                    }
                    i = this.readU(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 86: 
                case 118: {
                    i = this.readV(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 87: 
                case 119: {
                    i = this.readW(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 88: 
                case 120: {
                    if (i < end && sql.charAt(i + 1) == '\'') {
                        i = Tokenizer.readBinaryString(sql, tokenStart, end, i + 1, tokens);
                        continue block59;
                    }
                    i = this.readIdentifier(sql, end, tokenStart, i, c, tokens);
                    continue block59;
                }
                case 89: 
                case 121: {
                    i = this.readY(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 90: 
                case 122: {
                    i = this.readIdentifier(sql, end, tokenStart, i, c, tokens);
                    continue block59;
                }
                case 91: {
                    if (this.provider.getMode().squareBracketQuotedNames) {
                        int identifierEnd;
                        if ((identifierEnd = sql.indexOf(93, ++i)) < 0) {
                            throw DbException.getSyntaxError(sql, tokenStart);
                        }
                        token = new Token.IdentifierToken(tokenStart, sql.substring(i, identifierEnd), true, false);
                        i = identifierEnd;
                        break;
                    }
                    token = new Token.KeywordToken(tokenStart, 117);
                    break;
                }
                case 93: {
                    token = new Token.KeywordToken(tokenStart, 118);
                    break;
                }
                case 95: {
                    i = this.read_(sql, end, tokenStart, i, tokens);
                    continue block59;
                }
                case 123: {
                    token = new Token.KeywordToken(tokenStart, 111);
                    break;
                }
                case 124: {
                    if (i < end && sql.charAt(++i) == '|') {
                        token = new Token.KeywordToken(tokenStart, 104);
                        break;
                    }
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                case 125: {
                    token = new Token.KeywordToken(tokenStart, 112);
                    break;
                }
                case 126: {
                    token = new Token.KeywordToken(tokenStart, 119);
                    break;
                }
                default: {
                    if (c <= 32) {
                        ++i;
                        continue block59;
                    }
                    int cp = Character.isHighSurrogate((char)c) ? sql.codePointAt(i++) : c;
                    if (Character.isSpaceChar(cp)) continue block59;
                    if (Character.isJavaIdentifierStart(cp)) {
                        i = this.readIdentifier(sql, end, tokenStart, i, cp, tokens);
                        continue block59;
                    }
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
            }
            tokens.add(token);
            ++i;
        }
        if (foundUnicode) {
            Tokenizer.processUescape(sql, tokens);
        }
        tokens.add(new Token.EndOfInputToken(end + 1));
        return tokens;
    }

    private int readIdentifier(String sql, int end, int tokenStart, int i, int cp, ArrayList<Token> tokens) {
        if (cp >= 65536) {
            ++i;
        }
        int endIndex = this.findIdentifierEnd(sql, end, i + Character.charCount(cp) - 1);
        tokens.add(new Token.IdentifierToken(tokenStart, this.extractIdentifier(sql, tokenStart, endIndex), false, false));
        return endIndex;
    }

    private int readA(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = length == 2 ? ((sql.charAt(tokenStart + 1) & 0xFFDF) == 83 ? 7 : 2) : (Tokenizer.eq("ALL", sql, tokenStart, length) ? 3 : (Tokenizer.eq("AND", sql, tokenStart, length) ? 4 : (Tokenizer.eq("ANY", sql, tokenStart, length) ? 5 : (Tokenizer.eq("ARRAY", sql, tokenStart, length) ? 6 : (Tokenizer.eq("ASYMMETRIC", sql, tokenStart, length) ? 8 : (Tokenizer.eq("AUTHORIZATION", sql, tokenStart, length) ? 9 : 2))))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readB(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("BETWEEN", sql, tokenStart, length) ? 10 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readC(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("CASE", sql, tokenStart, length) ? 11 : (Tokenizer.eq("CAST", sql, tokenStart, length) ? 12 : (Tokenizer.eq("CHECK", sql, tokenStart, length) ? 13 : (Tokenizer.eq("CONSTRAINT", sql, tokenStart, length) ? 14 : (Tokenizer.eq("CROSS", sql, tokenStart, length) ? 15 : (length >= 12 && Tokenizer.eq("CURRENT_", sql, tokenStart, 8) ? Tokenizer.getTokenTypeCurrent(sql, tokenStart, length) : 2)))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private static int getTokenTypeCurrent(String s, int tokenStart, int length) {
        tokenStart += 8;
        switch (length) {
            case 12: {
                if (Tokenizer.eqCurrent("CURRENT_DATE", s, tokenStart, length)) {
                    return 17;
                }
                if (Tokenizer.eqCurrent("CURRENT_PATH", s, tokenStart, length)) {
                    return 18;
                }
                if (Tokenizer.eqCurrent("CURRENT_ROLE", s, tokenStart, length)) {
                    return 19;
                }
                if (Tokenizer.eqCurrent("CURRENT_TIME", s, tokenStart, length)) {
                    return 21;
                }
                if (!Tokenizer.eqCurrent("CURRENT_USER", s, tokenStart, length)) break;
                return 23;
            }
            case 14: {
                if (!Tokenizer.eqCurrent("CURRENT_SCHEMA", s, tokenStart, length)) break;
                return 20;
            }
            case 15: {
                if (!Tokenizer.eqCurrent("CURRENT_CATALOG", s, tokenStart, length)) break;
                return 16;
            }
            case 17: {
                if (!Tokenizer.eqCurrent("CURRENT_TIMESTAMP", s, tokenStart, length)) break;
                return 22;
            }
        }
        return 2;
    }

    private static boolean eqCurrent(String expected, String s, int start, int length) {
        for (int i = 8; i < length; ++i) {
            if (expected.charAt(i) == (s.charAt(start++) & 0xFFDF)) continue;
            return false;
        }
        return true;
    }

    private int readD(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("DAY", sql, tokenStart, length) ? 24 : (Tokenizer.eq("DEFAULT", sql, tokenStart, length) ? 25 : (Tokenizer.eq("DISTINCT", sql, tokenStart, length) ? 26 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readE(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("ELSE", sql, tokenStart, length) ? 27 : (Tokenizer.eq("END", sql, tokenStart, length) ? 28 : (Tokenizer.eq("EXCEPT", sql, tokenStart, length) ? 29 : (Tokenizer.eq("EXISTS", sql, tokenStart, length) ? 30 : 2)));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readF(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("FETCH", sql, tokenStart, length) ? 32 : (Tokenizer.eq("FROM", sql, tokenStart, length) ? 35 : (Tokenizer.eq("FOR", sql, tokenStart, length) ? 33 : (Tokenizer.eq("FOREIGN", sql, tokenStart, length) ? 34 : (Tokenizer.eq("FULL", sql, tokenStart, length) ? 36 : (Tokenizer.eq("FALSE", sql, tokenStart, length) ? 31 : 2)))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readG(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("GROUP", sql, tokenStart, length) ? 37 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readH(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("HAVING", sql, tokenStart, length) ? 38 : (Tokenizer.eq("HOUR", sql, tokenStart, length) ? 39 : 2);
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readI(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int type;
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        if (length == 2) {
            switch (sql.charAt(tokenStart + 1) & 0xFFDF) {
                case 70: {
                    type = 40;
                    break;
                }
                case 78: {
                    type = 41;
                    break;
                }
                case 83: {
                    type = 45;
                    break;
                }
                default: {
                    type = 2;
                    break;
                }
            }
        } else {
            type = Tokenizer.eq("INNER", sql, tokenStart, length) ? 42 : (Tokenizer.eq("INTERSECT", sql, tokenStart, length) ? 43 : (Tokenizer.eq("INTERVAL", sql, tokenStart, length) ? 44 : 2));
        }
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readJ(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("JOIN", sql, tokenStart, length) ? 46 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readK(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("KEY", sql, tokenStart, length) ? 47 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readL(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("LEFT", sql, tokenStart, length) ? 48 : (Tokenizer.eq("LIMIT", sql, tokenStart, length) ? (this.provider.getMode().limit ? 50 : 2) : (Tokenizer.eq("LIKE", sql, tokenStart, length) ? 49 : (Tokenizer.eq("LOCALTIME", sql, tokenStart, length) ? 51 : (Tokenizer.eq("LOCALTIMESTAMP", sql, tokenStart, length) ? 52 : 2))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readM(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("MINUS", sql, tokenStart, length) ? (this.provider.getMode().minusIsExcept ? 53 : 2) : (Tokenizer.eq("MINUTE", sql, tokenStart, length) ? 54 : (Tokenizer.eq("MONTH", sql, tokenStart, length) ? 55 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readN(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("NOT", sql, tokenStart, length) ? 57 : (Tokenizer.eq("NATURAL", sql, tokenStart, length) ? 56 : (Tokenizer.eq("NULL", sql, tokenStart, length) ? 58 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readO(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int type;
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        if (length == 2) {
            switch (sql.charAt(tokenStart + 1) & 0xFFDF) {
                case 78: {
                    type = 60;
                    break;
                }
                case 82: {
                    type = 61;
                    break;
                }
                default: {
                    type = 2;
                    break;
                }
            }
        } else {
            type = Tokenizer.eq("OFFSET", sql, tokenStart, length) ? 59 : (Tokenizer.eq("ORDER", sql, tokenStart, length) ? 62 : 2);
        }
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readP(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("PRIMARY", sql, tokenStart, length) ? 63 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readQ(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("QUALIFY", sql, tokenStart, length) ? 64 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readR(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("RIGHT", sql, tokenStart, length) ? 65 : (Tokenizer.eq("ROW", sql, tokenStart, length) ? 66 : (Tokenizer.eq("ROWNUM", sql, tokenStart, length) ? 67 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readS(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("SECOND", sql, tokenStart, length) ? 68 : (Tokenizer.eq("SELECT", sql, tokenStart, length) ? 69 : (Tokenizer.eq("SESSION_USER", sql, tokenStart, length) ? 70 : (Tokenizer.eq("SET", sql, tokenStart, length) ? 71 : (Tokenizer.eq("SOME", sql, tokenStart, length) ? 72 : (Tokenizer.eq("SYMMETRIC", sql, tokenStart, length) ? 73 : (Tokenizer.eq("SYSTEM_USER", sql, tokenStart, length) ? 74 : 2))))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readT(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = length == 2 ? ((sql.charAt(tokenStart + 1) & 0xFFDF) == 79 ? 76 : 2) : (Tokenizer.eq("TABLE", sql, tokenStart, length) ? 75 : (Tokenizer.eq("TRUE", sql, tokenStart, length) ? 77 : 2));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readU(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("UESCAPE", sql, tokenStart, length) ? 78 : (Tokenizer.eq("UNION", sql, tokenStart, length) ? 79 : (Tokenizer.eq("UNIQUE", sql, tokenStart, length) ? 80 : (Tokenizer.eq("UNKNOWN", sql, tokenStart, length) ? 81 : (Tokenizer.eq("USER", sql, tokenStart, length) ? 82 : (Tokenizer.eq("USING", sql, tokenStart, length) ? 83 : 2)))));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readV(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("VALUE", sql, tokenStart, length) ? 84 : (Tokenizer.eq("VALUES", sql, tokenStart, length) ? 85 : 2);
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readW(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("WHEN", sql, tokenStart, length) ? 86 : (Tokenizer.eq("WHERE", sql, tokenStart, length) ? 87 : (Tokenizer.eq("WINDOW", sql, tokenStart, length) ? 88 : (Tokenizer.eq("WITH", sql, tokenStart, length) ? 89 : 2)));
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readY(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int length = endIndex - tokenStart;
        int type = Tokenizer.eq("YEAR", sql, tokenStart, length) ? 90 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int read_(String sql, int end, int tokenStart, int i, ArrayList<Token> tokens) {
        int endIndex = this.findIdentifierEnd(sql, end, i);
        int type = endIndex - tokenStart == 7 && "_ROWID_".regionMatches(true, 1, sql, tokenStart + 1, 6) ? 91 : 2;
        return this.readIdentifierOrKeyword(sql, tokenStart, tokens, endIndex, type);
    }

    private int readIdentifierOrKeyword(String sql, int tokenStart, ArrayList<Token> tokens, int endIndex, int type) {
        Token token = type == 2 ? new Token.IdentifierToken(tokenStart, this.extractIdentifier(sql, tokenStart, endIndex), false, false) : (this.nonKeywords != null && this.nonKeywords.get(type) ? new Token.KeywordOrIdentifierToken(tokenStart, type, this.extractIdentifier(sql, tokenStart, endIndex)) : new Token.KeywordToken(tokenStart, type));
        tokens.add(token);
        return endIndex;
    }

    private static boolean eq(String expected, String s, int start, int length) {
        if (length != expected.length()) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (expected.charAt(i) == (s.charAt(++start) & 0xFFDF)) continue;
            return false;
        }
        return true;
    }

    private int findIdentifierEnd(String sql, int end, int i) {
        int cp;
        ++i;
        while (i <= end && (Character.isJavaIdentifierPart(cp = sql.codePointAt(i)) || cp == 35 && this.provider.getMode().supportPoundSymbolForColumnNames)) {
            i += Character.charCount(cp);
        }
        return i;
    }

    private String extractIdentifier(String sql, int beginIndex, int endIndex) {
        return this.convertCase(sql.substring(beginIndex, endIndex));
    }

    private int readQuotedIdentifier(String sql, int end, int tokenStart, int i, char c, boolean unicode, ArrayList<Token> tokens) {
        int identifierEnd;
        if ((identifierEnd = sql.indexOf(c, ++i)) < 0) {
            throw DbException.getSyntaxError(sql, tokenStart);
        }
        String s = sql.substring(i, identifierEnd);
        i = identifierEnd + 1;
        if (i <= end && sql.charAt(i) == c) {
            StringBuilder builder = new StringBuilder(s);
            do {
                if ((identifierEnd = sql.indexOf(c, i + 1)) < 0) {
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                builder.append(sql, i, identifierEnd);
            } while ((i = identifierEnd + 1) <= end && sql.charAt(i) == c);
            s = builder.toString();
        }
        if (c == '`') {
            s = this.convertCase(s);
        }
        tokens.add(new Token.IdentifierToken(tokenStart, s, true, unicode));
        return i;
    }

    private String convertCase(String s) {
        if (this.identifiersToUpper) {
            s = StringUtils.toUpperEnglish(s);
        } else if (this.identifiersToLower) {
            s = StringUtils.toLowerEnglish(s);
        }
        return s;
    }

    private static int readBinaryString(String sql, int tokenStart, int end, int i, ArrayList<Token> tokens) {
        int stringEnd;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        do {
            if ((stringEnd = sql.indexOf(39, ++i)) < 0 || stringEnd < end && sql.charAt(stringEnd + 1) == '\'') {
                throw DbException.getSyntaxError(sql, tokenStart);
            }
            StringUtils.convertHexWithSpacesToBytes(result, sql, i, stringEnd);
        } while ((i = Tokenizer.skipWhitespace(sql, end, stringEnd + 1)) <= end && sql.charAt(i) == '\'');
        tokens.add(new Token.BinaryStringToken(tokenStart, result.toByteArray()));
        return i;
    }

    private static int readCharacterString(String sql, int tokenStart, int end, int i, boolean unicode, ArrayList<Token> tokens) {
        String s = null;
        StringBuilder builder = null;
        do {
            int stringEnd;
            if ((stringEnd = sql.indexOf(39, ++i)) < 0) {
                throw DbException.getSyntaxError(sql, tokenStart);
            }
            if (s == null) {
                s = sql.substring(i, stringEnd);
            } else {
                if (builder == null) {
                    builder = new StringBuilder(s);
                }
                builder.append(sql, i, stringEnd);
            }
            i = stringEnd + 1;
            if (i > end || sql.charAt(i) != '\'') continue;
            if (builder == null) {
                builder = new StringBuilder(s);
            }
            do {
                if ((stringEnd = sql.indexOf(39, i + 1)) < 0) {
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                builder.append(sql, i, stringEnd);
            } while ((i = stringEnd + 1) <= end && sql.charAt(i) == '\'');
        } while ((i = Tokenizer.skipWhitespace(sql, end, i)) <= end && sql.charAt(i) == '\'');
        if (builder != null) {
            s = builder.toString();
        }
        tokens.add(new Token.CharacterStringToken(tokenStart, s, unicode));
        return i;
    }

    private static int skipWhitespace(String sql, int end, int i) {
        while (i <= end) {
            int cp = sql.codePointAt(i);
            if (!Character.isWhitespace(cp)) {
                if (cp != 47 || i >= end) break;
                char c2 = sql.charAt(i + 1);
                if (c2 == '*') {
                    i = Tokenizer.skipBracketedComment(sql, i, end, i);
                    continue;
                }
                if (c2 != '/') break;
                i = Tokenizer.skipSimpleComment(sql, end, i);
                continue;
            }
            i += Character.charCount(cp);
        }
        return i;
    }

    private static int readHexNumber(String sql, CastDataProvider provider, int tokenStart, int end, int i, ArrayList<Token> tokens) {
        boolean bigint;
        char c;
        if (provider.getMode().zeroExLiteralsAreBinaryStrings) {
            char c2;
            int start = i;
            while (i <= end && ((c2 = sql.charAt(i)) >= '0' && c2 <= '9' || (c2 = (char)(c2 & 0xFFDF)) >= 'A' && c2 <= 'F')) {
                ++i;
            }
            if (i <= end && Character.isJavaIdentifierPart(sql.codePointAt(i))) {
                throw DbException.get(90004, sql.substring(start, i + 1));
            }
            tokens.add(new Token.BinaryStringToken(start, StringUtils.convertHexToBytes(sql.substring(start, i))));
            return i;
        }
        if (i > end) {
            throw DbException.getSyntaxError(sql, tokenStart, "Hex number");
        }
        int start = i;
        long number = 0L;
        do {
            if ((c = sql.charAt(i)) >= '0' && c <= '9') {
                number = (number << 4) + (long)c - 48L;
            } else if ((c = (char)(c & 0xFFDF)) >= 'A' && c <= 'F') {
                number = (number << 4) + (long)c - 55L;
            } else {
                if (i != start) break;
                throw DbException.getSyntaxError(sql, tokenStart, "Hex number");
            }
            if (number <= Integer.MAX_VALUE) continue;
            while (++i <= end && ((c = sql.charAt(i)) >= '0' && c <= '9' || (c = (char)(c & 0xFFDF)) >= 'A' && c <= 'F')) {
            }
            return Tokenizer.finishBigInteger(sql, tokenStart, end, i, start, i <= end && c == 'L', 16, tokens);
        } while (++i <= end);
        boolean bl = bigint = i <= end && c == 'L';
        if (bigint) {
            ++i;
        }
        if (i <= end && Character.isJavaIdentifierPart(sql.codePointAt(i))) {
            throw DbException.getSyntaxError(sql, tokenStart, "Hex number");
        }
        tokens.add(bigint ? new Token.BigintToken(start, number) : new Token.IntegerToken(start, (int)number));
        return i;
    }

    private static int readNumeric(String sql, int tokenStart, int end, int i, char c, ArrayList<Token> tokens) {
        long number = c - 48;
        while (i <= end) {
            c = sql.charAt(i);
            if (c < '0' || c > '9') {
                switch (c) {
                    case '.': {
                        return Tokenizer.readNumeric(sql, tokenStart, end, i, c, false, false, tokens);
                    }
                    case 'E': 
                    case 'e': {
                        return Tokenizer.readNumeric(sql, tokenStart, end, i, c, false, true, tokens);
                    }
                    case 'L': 
                    case 'l': {
                        return Tokenizer.finishBigInteger(sql, tokenStart, end, i, tokenStart, true, 10, tokens);
                    }
                }
                break;
            }
            if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                return Tokenizer.readNumeric(sql, tokenStart, end, i, c, true, false, tokens);
            }
            ++i;
        }
        tokens.add(new Token.IntegerToken(tokenStart, (int)number));
        return i;
    }

    private static int readNumeric(String sql, int tokenStart, int end, int i, char c, boolean integer, boolean approximate, ArrayList<Token> tokens) {
        BigDecimal bd;
        if (!approximate) {
            while (++i <= end) {
                c = sql.charAt(i);
                if (c == '.') {
                    integer = false;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
            }
        }
        if (i <= end && (c == 'E' || c == 'e')) {
            integer = false;
            approximate = true;
            if (i == end) {
                throw DbException.getSyntaxError(sql, tokenStart);
            }
            if ((c = sql.charAt(++i)) == '+' || c == '-') {
                if (i == end) {
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                c = sql.charAt(++i);
            }
            if (c < '0' || c > '9') {
                throw DbException.getSyntaxError(sql, tokenStart);
            }
            while (++i <= end && (c = sql.charAt(i)) >= '0' && c <= '9') {
            }
        }
        if (integer) {
            return Tokenizer.finishBigInteger(sql, tokenStart, end, i, tokenStart, i < end && c == 'L' || c == 'l', 10, tokens);
        }
        String string = sql.substring(tokenStart, i);
        try {
            bd = new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, string);
        }
        tokens.add(new Token.ValueToken(tokenStart, approximate ? ValueDecfloat.get(bd) : ValueNumeric.get(bd)));
        return i;
    }

    private static int finishBigInteger(String sql, int tokenStart, int end, int i, int start, boolean asBigint, int radix, ArrayList<Token> tokens) {
        Token.LiteralToken token;
        int endIndex = i++;
        if (asBigint) {
            // empty if block
        }
        if (radix == 16 && i <= end && Character.isJavaIdentifierPart(sql.codePointAt(i))) {
            throw DbException.getSyntaxError(sql, tokenStart, "Hex number");
        }
        BigInteger bigInteger = new BigInteger(sql.substring(start, endIndex), radix);
        if (bigInteger.compareTo(ValueBigint.MAX_BI) > 0) {
            if (asBigint) {
                throw DbException.getSyntaxError(sql, tokenStart);
            }
            token = new Token.ValueToken(tokenStart, ValueNumeric.get(bigInteger));
        } else {
            token = new Token.BigintToken(start, bigInteger.longValue());
        }
        tokens.add(token);
        return i;
    }

    private static int skipBracketedComment(String sql, int tokenStart, int end, int i) {
        i += 2;
        int level = 1;
        block0: while (level > 0) {
            while (true) {
                char c;
                if (i >= end) {
                    throw DbException.getSyntaxError(sql, tokenStart);
                }
                if ((c = sql.charAt(i++)) == '*') {
                    if (sql.charAt(i) != '/') continue;
                    --level;
                    ++i;
                    continue block0;
                }
                if (c != '/' || sql.charAt(i) != '*') continue;
                ++level;
                ++i;
            }
        }
        return i;
    }

    private static int skipSimpleComment(String sql, int end, int i) {
        char c;
        i += 2;
        while (i <= end && (c = sql.charAt(i)) != '\n' && c != '\r') {
            ++i;
        }
        return i;
    }

    private static int parseParameterIndex(String sql, int end, int i, ArrayList<Token> tokens) {
        char c;
        int tokenStart = i;
        long number = 0L;
        while (++i <= end && (c = sql.charAt(i)) >= '0' && c <= '9') {
            if ((number = number * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
            throw DbException.getInvalidValueException("parameter index", number);
        }
        if (i > tokenStart + 1 && number == 0L) {
            throw DbException.getInvalidValueException("parameter index", number);
        }
        tokens.add(new Token.ParameterToken(tokenStart, (int)number));
        return i;
    }

    private static int assignParameterIndex(ArrayList<Token> tokens, int lastParameter, BitSet parameters) {
        Token.ParameterToken parameter = (Token.ParameterToken)tokens.get(tokens.size() - 1);
        int index = parameter.index;
        if (index == 0) {
            if (lastParameter < 0) {
                throw DbException.get(90123);
            }
            parameter.index = index = ++lastParameter;
        } else {
            if (lastParameter > 0) {
                throw DbException.get(90123);
            }
            lastParameter = -1;
        }
        parameters.set(index - 1);
        return lastParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processUescape(String sql, ArrayList<Token> tokens) {
        ListIterator<Token> i = tokens.listIterator();
        while (i.hasNext()) {
            Token t2;
            Token token = i.next();
            if (!token.needsUnicodeConversion()) continue;
            int uescape = 92;
            if (i.hasNext() && (t2 = i.next()).tokenType() == 78) {
                int escape;
                String s;
                i.remove();
                if (!i.hasNext()) throw DbException.getSyntaxError(sql, t2.start() + 7, "'<Unicode escape character>'");
                Token t3 = i.next();
                i.remove();
                if (!(t3 instanceof Token.CharacterStringToken) || (s = ((Token.CharacterStringToken)t3).string).codePointCount(0, s.length()) != 1 || Character.isWhitespace(escape = s.codePointAt(0)) || escape >= 48 && escape <= 57 || escape >= 65 && escape <= 70 || escape >= 97 && escape <= 102) throw DbException.getSyntaxError(sql, t2.start() + 7, "'<Unicode escape character>'");
                switch (escape) {
                    default: {
                        uescape = escape;
                        break;
                    }
                    case 34: 
                    case 39: 
                    case 43: {
                        throw DbException.getSyntaxError(sql, t2.start() + 7, "'<Unicode escape character>'");
                    }
                }
            }
            token.convertUnicode(uescape);
        }
    }
}

