/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public abstract class AlterTable
extends SchemaCommand {
    String tableName;
    boolean ifTableExists;

    AlterTable(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public final void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public final void setIfTableExists(boolean b) {
        this.ifTableExists = b;
    }

    @Override
    public final long update() {
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0L;
            }
            throw DbException.get(42102, this.tableName);
        }
        this.session.getUser().checkTableRight(table, 32);
        return this.update(table);
    }

    abstract long update(Table var1);
}

