/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterTable;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.DataType;

public class AlterTableAddConstraint
extends AlterTable {
    private final int type;
    private String constraintName;
    private IndexColumn[] indexColumns;
    private ConstraintActionType deleteAction = ConstraintActionType.RESTRICT;
    private ConstraintActionType updateAction = ConstraintActionType.RESTRICT;
    private Schema refSchema;
    private String refTableName;
    private IndexColumn[] refIndexColumns;
    private Expression checkExpression;
    private Index index;
    private Index refIndex;
    private String comment;
    private boolean checkExisting;
    private boolean primaryKeyHash;
    private final boolean ifNotExists;
    private final ArrayList<Index> createdIndexes = new ArrayList();
    private ConstraintUnique createdUniqueConstraint;

    public AlterTableAddConstraint(SessionLocal session, Schema schema, int type, boolean ifNotExists) {
        super(session, schema);
        this.ifNotExists = ifNotExists;
        this.type = type;
    }

    private String generateConstraintName(Table table) {
        if (this.constraintName == null) {
            this.constraintName = this.getSchema().getUniqueConstraintName(this.session, table);
        }
        return this.constraintName;
    }

    @Override
    public long update(Table table) {
        try {
            long l = this.tryUpdate(table);
            return l;
        }
        catch (DbException e) {
            try {
                if (this.createdUniqueConstraint != null) {
                    Index index = this.createdUniqueConstraint.getIndex();
                    this.session.getDatabase().removeSchemaObject(this.session, this.createdUniqueConstraint);
                    this.createdIndexes.remove(index);
                }
                for (Index index : this.createdIndexes) {
                    this.session.getDatabase().removeSchemaObject(this.session, index);
                }
            }
            catch (Throwable ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        finally {
            this.getSchema().freeUniqueName(this.constraintName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryUpdate(Table table) {
        Constraint constraint;
        if (this.constraintName != null && this.getSchema().findConstraint(this.session, this.constraintName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            if (!this.session.isQuirksMode()) {
                throw DbException.get(90045, this.constraintName);
            }
            this.constraintName = null;
        }
        Database db = this.session.getDatabase();
        db.lockMeta(this.session);
        table.lock(this.session, 2);
        switch (this.type) {
            case 6: {
                IndexColumn.mapColumns(this.indexColumns, table);
                this.index = table.findPrimaryKey();
                ArrayList<Constraint> constraints = table.getConstraints();
                for (int i = 0; constraints != null && i < constraints.size(); ++i) {
                    Constraint c = constraints.get(i);
                    if (Constraint.Type.PRIMARY_KEY != c.getConstraintType()) continue;
                    throw DbException.get(90017);
                }
                if (this.index != null) {
                    IndexColumn[] pkCols = this.index.getIndexColumns();
                    if (pkCols.length != this.indexColumns.length) {
                        throw DbException.get(90017);
                    }
                    for (int i = 0; i < pkCols.length; ++i) {
                        if (pkCols[i].column == this.indexColumns[i].column) continue;
                        throw DbException.get(90017);
                    }
                } else {
                    IndexType indexType = IndexType.createPrimaryKey(table.isPersistIndexes(), this.primaryKeyHash);
                    String indexName = table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_");
                    int indexId = this.session.getDatabase().allocateObjectId();
                    try {
                        this.index = table.addIndex(this.session, indexName, indexId, this.indexColumns, this.indexColumns.length, indexType, true, null);
                    }
                    finally {
                        this.getSchema().freeUniqueName(indexName);
                    }
                }
                this.index.getIndexType().setBelongsToConstraint(true);
                int id = this.getObjectId();
                String name = this.generateConstraintName(table);
                ConstraintUnique pk = new ConstraintUnique(this.getSchema(), id, name, table, true);
                pk.setColumns(this.indexColumns);
                pk.setIndex(this.index, true);
                constraint = pk;
                break;
            }
            case 4: {
                if (this.indexColumns == null) {
                    Column[] columns = table.getColumns();
                    int columnCount = columns.length;
                    ArrayList<IndexColumn> list = new ArrayList<IndexColumn>(columnCount);
                    for (int i = 0; i < columnCount; ++i) {
                        Column c = columns[i];
                        if (!c.getVisible()) continue;
                        IndexColumn indexColumn = new IndexColumn(c.getName());
                        indexColumn.column = c;
                        list.add(indexColumn);
                    }
                    if (list.isEmpty()) {
                        throw DbException.get(42000, "UNIQUE(VALUE) on table without columns");
                    }
                    this.indexColumns = list.toArray(new IndexColumn[0]);
                } else {
                    IndexColumn.mapColumns(this.indexColumns, table);
                }
                constraint = this.createUniqueConstraint(table, this.index, this.indexColumns, false);
                break;
            }
            case 3: {
                int id = this.getObjectId();
                String name = this.generateConstraintName(table);
                ConstraintCheck check = new ConstraintCheck(this.getSchema(), id, name, table);
                TableFilter filter = new TableFilter(this.session, table, null, false, null, 0, null);
                this.checkExpression.mapColumns(filter, 0, 0);
                this.checkExpression = this.checkExpression.optimize(this.session);
                check.setExpression(this.checkExpression);
                check.setTableFilter(filter);
                constraint = check;
                if (!this.checkExisting) break;
                check.checkExistingData(this.session);
                break;
            }
            case 5: {
                Table refTable = this.refSchema.resolveTableOrView(this.session, this.refTableName);
                if (refTable == null) {
                    throw DbException.get(42102, this.refTableName);
                }
                if (refTable != table) {
                    this.session.getUser().checkTableRight(refTable, 32);
                }
                if (!refTable.canReference()) {
                    StringBuilder builder = new StringBuilder("Reference ");
                    refTable.getSQL(builder, 3);
                    throw DbException.getUnsupportedException(builder.toString());
                }
                boolean isOwner = false;
                IndexColumn.mapColumns(this.indexColumns, table);
                if (this.refIndexColumns == null) {
                    this.refIndexColumns = refTable.getPrimaryKey().getIndexColumns();
                } else {
                    IndexColumn.mapColumns(this.refIndexColumns, refTable);
                }
                int columnCount = this.indexColumns.length;
                if (this.refIndexColumns.length != columnCount) {
                    throw DbException.get(21002);
                }
                for (IndexColumn indexColumn : this.indexColumns) {
                    Column column = indexColumn.column;
                    if (!column.isGeneratedAlways()) continue;
                    switch (this.deleteAction) {
                        case SET_DEFAULT: 
                        case SET_NULL: {
                            throw DbException.get(90155, column.getSQLWithTable(new StringBuilder(), 3).toString(), "ON DELETE " + this.deleteAction.getSqlName());
                        }
                    }
                    switch (this.updateAction) {
                        case SET_DEFAULT: 
                        case SET_NULL: 
                        case CASCADE: {
                            throw DbException.get(90155, column.getSQLWithTable(new StringBuilder(), 3).toString(), "ON UPDATE " + this.updateAction.getSqlName());
                        }
                    }
                }
                for (int i = 0; i < columnCount; ++i) {
                    Column column1 = this.indexColumns[i].column;
                    Column column2 = this.refIndexColumns[i].column;
                    if (DataType.areStableComparable(column1.getType(), column2.getType())) continue;
                    throw DbException.get(90153, column1.getCreateSQL(), column2.getCreateSQL());
                }
                ConstraintUnique unique = AlterTableAddConstraint.getUniqueConstraint(refTable, this.refIndexColumns);
                if (unique == null && !this.session.isQuirksMode() && !this.session.getMode().createUniqueConstraintForReferencedColumns) {
                    throw DbException.get(90057, IndexColumn.writeColumns(new StringBuilder("PRIMARY KEY | UNIQUE ("), this.refIndexColumns, 3).append(')').toString());
                }
                if (this.index != null && AlterTableAddConstraint.canUseIndex(this.index, table, this.indexColumns, false)) {
                    isOwner = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = AlterTableAddConstraint.getIndex(table, this.indexColumns, false);
                    if (this.index == null) {
                        this.index = this.createIndex(table, this.indexColumns, false);
                        isOwner = true;
                    }
                }
                int id = this.getObjectId();
                String name = this.generateConstraintName(table);
                ConstraintReferential refConstraint = new ConstraintReferential(this.getSchema(), id, name, table);
                refConstraint.setColumns(this.indexColumns);
                refConstraint.setIndex(this.index, isOwner);
                refConstraint.setRefTable(refTable);
                refConstraint.setRefColumns(this.refIndexColumns);
                if (unique == null) {
                    unique = this.createUniqueConstraint(refTable, this.refIndex, this.refIndexColumns, true);
                    this.addConstraintToTable(db, refTable, unique);
                    this.createdUniqueConstraint = unique;
                }
                refConstraint.setRefConstraint(unique);
                if (this.checkExisting) {
                    refConstraint.checkExistingData(this.session);
                }
                refTable.addConstraint(refConstraint);
                refConstraint.setDeleteAction(this.deleteAction);
                refConstraint.setUpdateAction(this.updateAction);
                constraint = refConstraint;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        constraint.setComment(this.comment);
        this.addConstraintToTable(db, table, constraint);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstraintUnique createUniqueConstraint(Table table, Index index, IndexColumn[] indexColumns, boolean forForeignKey) {
        String name;
        int id;
        boolean isOwner = false;
        if (index != null && AlterTableAddConstraint.canUseIndex(index, table, indexColumns, true)) {
            isOwner = true;
            index.getIndexType().setBelongsToConstraint(true);
        } else {
            index = AlterTableAddConstraint.getIndex(table, indexColumns, true);
            if (index == null) {
                index = this.createIndex(table, indexColumns, true);
                isOwner = true;
            }
        }
        Schema tableSchema = table.getSchema();
        if (forForeignKey) {
            id = this.session.getDatabase().allocateObjectId();
            try {
                tableSchema.reserveUniqueName(this.constraintName);
                name = tableSchema.getUniqueConstraintName(this.session, table);
            }
            finally {
                tableSchema.freeUniqueName(this.constraintName);
            }
        } else {
            id = this.getObjectId();
            name = this.generateConstraintName(table);
        }
        ConstraintUnique unique = new ConstraintUnique(tableSchema, id, name, table, false);
        unique.setColumns(indexColumns);
        unique.setIndex(index, isOwner);
        return unique;
    }

    private void addConstraintToTable(Database db, Table table, Constraint constraint) {
        if (table.isTemporary() && !table.isGlobalTemporary()) {
            this.session.addLocalTempTableConstraint(constraint);
        } else {
            db.addSchemaObject(this.session, constraint);
        }
        table.addConstraint(constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index createIndex(Table t, IndexColumn[] cols, boolean unique) {
        int indexId = this.session.getDatabase().allocateObjectId();
        IndexType indexType = unique ? IndexType.createUnique(t.isPersistIndexes(), false) : IndexType.createNonUnique(t.isPersistIndexes());
        indexType.setBelongsToConstraint(true);
        String prefix = this.constraintName == null ? "CONSTRAINT" : this.constraintName;
        String indexName = t.getSchema().getUniqueIndexName(this.session, t, prefix + "_INDEX_");
        try {
            Index index = t.addIndex(this.session, indexName, indexId, cols, unique ? cols.length : 0, indexType, true, null);
            this.createdIndexes.add(index);
            Index index2 = index;
            return index2;
        }
        finally {
            this.getSchema().freeUniqueName(indexName);
        }
    }

    public void setDeleteAction(ConstraintActionType action) {
        this.deleteAction = action;
    }

    public void setUpdateAction(ConstraintActionType action) {
        this.updateAction = action;
    }

    private static ConstraintUnique getUniqueConstraint(Table t, IndexColumn[] cols) {
        ArrayList<Constraint> constraints = t.getConstraints();
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                Constraint.Type constraintType;
                if (constraint.getTable() != t || (constraintType = constraint.getConstraintType()) != Constraint.Type.PRIMARY_KEY && constraintType != Constraint.Type.UNIQUE || !AlterTableAddConstraint.canUseIndex(constraint.getIndex(), t, cols, true)) continue;
                return (ConstraintUnique)constraint;
            }
        }
        return null;
    }

    private static Index getIndex(Table t, IndexColumn[] cols, boolean unique) {
        ArrayList<Index> indexes = t.getIndexes();
        Index index = null;
        if (indexes != null) {
            for (Index idx : indexes) {
                if (!AlterTableAddConstraint.canUseIndex(idx, t, cols, unique) || index != null && idx.getIndexColumns().length >= index.getIndexColumns().length) continue;
                index = idx;
            }
        }
        return index;
    }

    private static boolean canUseIndex(Index index, Table table, IndexColumn[] cols, boolean unique) {
        int allowedColumns;
        if (index.getTable() != table) {
            return false;
        }
        if (unique ? (allowedColumns = index.getUniqueColumnCount()) != cols.length : index.getCreateSQL() == null || (allowedColumns = index.getColumns().length) != cols.length) {
            return false;
        }
        for (IndexColumn col : cols) {
            int i = index.getColumnIndex(col.column);
            if (i >= 0 && i < allowedColumns) continue;
            return false;
        }
        return true;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setCheckExpression(Expression expression) {
        this.checkExpression = expression;
    }

    public void setIndexColumns(IndexColumn[] indexColumns) {
        this.indexColumns = indexColumns;
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public void setRefTableName(Schema refSchema, String ref) {
        this.refSchema = refSchema;
        this.refTableName = ref;
    }

    public void setRefIndexColumns(IndexColumn[] indexColumns) {
        this.refIndexColumns = indexColumns;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setRefIndex(Index refIndex) {
        this.refIndex = refIndex;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCheckExisting(boolean b) {
        this.checkExisting = b;
    }

    public void setPrimaryKeyHash(boolean b) {
        this.primaryKeyHash = b;
    }
}

