/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.CommandContainer;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableView;
import org.h2.util.Utils;

public class AlterTableAlterColumn
extends CommandWithColumns {
    private String tableName;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private Expression usingExpression;
    private boolean addFirst;
    private String addBefore;
    private String addAfter;
    private boolean ifTableExists;
    private boolean ifNotExists;
    private ArrayList<Column> columnsToAdd;
    private ArrayList<Column> columnsToRemove;
    private boolean booleanFlag;

    public AlterTableAlterColumn(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean b) {
        this.ifTableExists = b;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setOldColumn(Column oldColumn) {
        this.oldColumn = oldColumn;
    }

    public void setAddFirst() {
        this.addFirst = true;
    }

    public void setAddBefore(String before) {
        this.addBefore = before;
    }

    public void setAddAfter(String after) {
        this.addAfter = after;
    }

    @Override
    public long update() {
        Database db = this.session.getDatabase();
        Table table = this.getSchema().resolveTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0L;
            }
            throw DbException.get(42102, this.tableName);
        }
        this.session.getUser().checkTableRight(table, 32);
        table.checkSupportAlter();
        table.lock(this.session, 2);
        if (this.newColumn != null) {
            AlterTableAlterColumn.checkDefaultReferencesTable(table, this.newColumn.getDefaultExpression());
            this.checkClustering(this.newColumn);
        }
        if (this.columnsToAdd != null) {
            for (Column column : this.columnsToAdd) {
                AlterTableAlterColumn.checkDefaultReferencesTable(table, column.getDefaultExpression());
                this.checkClustering(column);
            }
        }
        switch (this.type) {
            case 8: {
                if (this.oldColumn == null || !this.oldColumn.isNullable()) break;
                this.checkNoNullValues(table);
                this.oldColumn.setNullable(false);
                db.updateMeta(this.session, table);
                break;
            }
            case 9: {
                if (this.oldColumn == null || this.oldColumn.isNullable()) break;
                this.checkNullable(table);
                this.oldColumn.setNullable(true);
                db.updateMeta(this.session, table);
                break;
            }
            case 10: 
            case 98: {
                if (this.oldColumn == null || this.oldColumn.isIdentity()) break;
                if (this.defaultExpression != null) {
                    if (this.oldColumn.isGenerated()) break;
                    AlterTableAlterColumn.checkDefaultReferencesTable(table, this.defaultExpression);
                    this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                } else {
                    if (this.type == 98 != this.oldColumn.isGenerated()) break;
                    this.oldColumn.setDefaultExpression(this.session, null);
                }
                db.updateMeta(this.session, table);
                break;
            }
            case 99: {
                Sequence sequence;
                if (this.oldColumn == null || (sequence = this.oldColumn.getSequence()) == null) break;
                this.oldColumn.setSequence(null, false);
                this.removeSequence(table, sequence);
                db.updateMeta(this.session, table);
                break;
            }
            case 90: {
                if (this.oldColumn == null) break;
                if (this.defaultExpression != null) {
                    if (this.oldColumn.isIdentity() || this.oldColumn.isGenerated()) break;
                    AlterTableAlterColumn.checkDefaultReferencesTable(table, this.defaultExpression);
                    this.oldColumn.setOnUpdateExpression(this.session, this.defaultExpression);
                } else {
                    this.oldColumn.setOnUpdateExpression(this.session, null);
                }
                db.updateMeta(this.session, table);
                break;
            }
            case 11: {
                if (this.oldColumn == null) break;
                if (this.oldColumn.isWideningConversion(this.newColumn) && this.usingExpression == null) {
                    this.convertIdentityColumn(table, this.newColumn);
                    this.oldColumn.copy(this.newColumn);
                    db.updateMeta(this.session, table);
                } else {
                    this.oldColumn.setSequence(null, false);
                    this.oldColumn.setDefaultExpression(this.session, null);
                    if (this.oldColumn.isNullable() && !this.newColumn.isNullable()) {
                        this.checkNoNullValues(table);
                    } else if (!this.oldColumn.isNullable() && this.newColumn.isNullable()) {
                        this.checkNullable(table);
                    }
                    if (this.oldColumn.getVisible() ^ this.newColumn.getVisible()) {
                        this.oldColumn.setVisible(this.newColumn.getVisible());
                    }
                    this.convertIdentityColumn(table, this.newColumn);
                    this.copyData(table, null, true);
                }
                table.setModified();
                break;
            }
            case 7: {
                if (this.ifNotExists && this.columnsToAdd != null && this.columnsToAdd.size() == 1 && table.doesColumnExist(this.columnsToAdd.get(0).getName())) break;
                ArrayList<Sequence> sequences = this.generateSequences(this.columnsToAdd, false);
                if (this.columnsToAdd != null) {
                    this.changePrimaryKeysToNotNull(this.columnsToAdd);
                }
                this.copyData(table, sequences, true);
                break;
            }
            case 12: {
                if (table.getColumns().length - this.columnsToRemove.size() < 1) {
                    throw DbException.get(90084, this.columnsToRemove.get(0).getTraceSQL());
                }
                table.dropMultipleColumnsConstraintsAndIndexes(this.session, this.columnsToRemove);
                this.copyData(table, null, false);
                break;
            }
            case 13: {
                if (this.oldColumn == null) break;
                int value = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(value);
                db.updateMeta(this.session, table);
                break;
            }
            case 87: {
                if (this.oldColumn == null || this.oldColumn.getVisible() == this.booleanFlag) break;
                this.oldColumn.setVisible(this.booleanFlag);
                table.setModified();
                db.updateMeta(this.session, table);
                break;
            }
            case 100: {
                if (this.oldColumn == null || this.oldColumn.isDefaultOnNull() == this.booleanFlag) break;
                this.oldColumn.setDefaultOnNull(this.booleanFlag);
                table.setModified();
                db.updateMeta(this.session, table);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        return 0L;
    }

    private static void checkDefaultReferencesTable(Table table, Expression defaultExpression) {
        if (defaultExpression == null) {
            return;
        }
        HashSet<DbObject> dependencies = new HashSet<DbObject>();
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        defaultExpression.isEverything(visitor);
        if (dependencies.contains(table)) {
            throw DbException.get(90083, defaultExpression.getTraceSQL());
        }
    }

    private void checkClustering(Column c) {
        if (!"''".equals(this.session.getDatabase().getCluster()) && c.hasIdentityOptions()) {
            throw DbException.getUnsupportedException("CLUSTERING && identity columns");
        }
    }

    private void convertIdentityColumn(Table table, Column c) {
        if (c.hasIdentityOptions()) {
            if (c.isPrimaryKey()) {
                this.addConstraintCommand(Parser.newPrimaryKeyConstraintCommand(this.session, table.getSchema(), table.getName(), c));
            }
            int objId = this.getObjectId();
            c.initializeSequence(this.session, this.getSchema(), objId, table.isTemporary());
        }
    }

    private void removeSequence(Table table, Sequence sequence) {
        if (sequence != null) {
            table.removeSequence(sequence);
            sequence.setBelongsToTable(false);
            Database db = this.session.getDatabase();
            db.removeSchemaObject(this.session, sequence);
        }
    }

    private void copyData(Table table, ArrayList<Sequence> sequences, boolean createConstraints) {
        if (table.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        Database db = this.session.getDatabase();
        String baseName = table.getName();
        String tempName = db.getTempTableName(baseName, this.session);
        Column[] columns = table.getColumns();
        ArrayList<Column> newColumns = new ArrayList<Column>(columns.length);
        Table newTable = this.cloneTableStructure(table, columns, db, tempName, newColumns);
        if (sequences != null) {
            for (Sequence sequence : sequences) {
                table.addSequence(sequence);
            }
        }
        try {
            this.checkViews(table, newTable);
        }
        catch (DbException e) {
            StringBuilder builder = new StringBuilder("DROP TABLE ");
            newTable.getSQL(builder, 0);
            this.execute(builder.toString());
            throw e;
        }
        String tableName = table.getName();
        ArrayList<TableView> dependentViews = new ArrayList<TableView>(table.getDependentViews());
        for (TableView view : dependentViews) {
            table.removeDependentView(view);
        }
        StringBuilder builder = new StringBuilder("DROP TABLE ");
        table.getSQL(builder, 0).append(" IGNORE");
        this.execute(builder.toString());
        db.renameSchemaObject(this.session, newTable, tableName);
        for (DbObject child : newTable.getChildren()) {
            String name;
            if (child instanceof Sequence || (name = child.getName()) == null || child.getCreateSQL() == null || !name.startsWith(tempName + "_")) continue;
            name = name.substring(tempName.length() + 1);
            SchemaObject so = (SchemaObject)child;
            if (so instanceof Constraint) {
                if (so.getSchema().findConstraint(this.session, name) != null) {
                    name = so.getSchema().getUniqueConstraintName(this.session, newTable);
                }
            } else if (so instanceof Index && so.getSchema().findIndex(this.session, name) != null) {
                name = so.getSchema().getUniqueIndexName(this.session, newTable, name);
            }
            db.renameSchemaObject(this.session, so, name);
        }
        if (createConstraints) {
            this.createConstraints();
        }
        for (TableView view : dependentViews) {
            String sql = view.getCreateSQL(true, true);
            this.execute(sql);
        }
    }

    private Table cloneTableStructure(Table table, Column[] columns, Database db, String tempName, ArrayList<Column> newColumns) {
        for (Column col : columns) {
            newColumns.add(col.getClone());
        }
        switch (this.type) {
            case 12: {
                for (Column removeCol : this.columnsToRemove) {
                    Column foundCol = null;
                    for (Column newCol : newColumns) {
                        if (!newCol.getName().equals(removeCol.getName())) continue;
                        foundCol = newCol;
                        break;
                    }
                    if (foundCol == null) {
                        throw DbException.getInternalError(removeCol.getCreateSQL());
                    }
                    newColumns.remove(foundCol);
                }
                break;
            }
            case 7: {
                int position = this.addFirst ? 0 : (this.addBefore != null ? table.getColumn(this.addBefore).getColumnId() : (this.addAfter != null ? table.getColumn(this.addAfter).getColumnId() + 1 : columns.length));
                if (this.columnsToAdd == null) break;
                for (Column column : this.columnsToAdd) {
                    newColumns.add(position++, column);
                }
                break;
            }
            case 11: {
                newColumns.set(this.oldColumn.getColumnId(), this.newColumn);
            }
        }
        int id = db.allocateObjectId();
        CreateTableData data = new CreateTableData();
        data.tableName = tempName;
        data.id = id;
        data.columns = newColumns;
        data.temporary = table.isTemporary();
        data.persistData = table.isPersistData();
        data.persistIndexes = table.isPersistIndexes();
        data.isHidden = table.isHidden();
        data.session = this.session;
        Table newTable = this.getSchema().createTable(data);
        newTable.setComment(table.getComment());
        String newTableSQL = newTable.getCreateSQLForMeta();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnValues = new StringBuilder();
        block15: for (Column nc : newColumns) {
            if (nc.isGenerated()) continue;
            switch (this.type) {
                case 7: {
                    if (this.columnsToAdd == null || !this.columnsToAdd.contains(nc)) break;
                    if (this.usingExpression == null) continue block15;
                    this.usingExpression.getUnenclosedSQL(AlterTableAlterColumn.addColumn(nc, columnNames, columnValues), 0);
                    continue block15;
                }
                case 11: {
                    if (!nc.equals(this.newColumn) || this.usingExpression == null) break;
                    this.usingExpression.getUnenclosedSQL(AlterTableAlterColumn.addColumn(nc, columnNames, columnValues), 0);
                    continue block15;
                }
            }
            nc.getSQL(AlterTableAlterColumn.addColumn(nc, columnNames, columnValues), 0);
        }
        String newTableName = newTable.getName();
        Schema newTableSchema = newTable.getSchema();
        newTable.removeChildrenAndResources(this.session);
        this.execute(newTableSQL);
        newTable = newTableSchema.getTableOrView(this.session, newTableName);
        ArrayList<String> children = Utils.newSmallArrayList();
        ArrayList<String> triggers = Utils.newSmallArrayList();
        boolean hasDelegateIndex = false;
        for (DbObject child : table.getChildren()) {
            ConstraintReferential r;
            String createSQL;
            Index idx;
            if (child instanceof Sequence || child instanceof Index && (idx = (Index)child).getIndexType().getBelongsToConstraint() || (createSQL = child.getCreateSQL()) == null || child instanceof TableView) continue;
            if (child.getType() == 0) {
                throw DbException.getInternalError();
            }
            String quotedName = Parser.quoteIdentifier(tempName + "_" + child.getName(), 0);
            String sql = null;
            if (child instanceof ConstraintReferential && (r = (ConstraintReferential)child).getTable() != table) {
                sql = r.getCreateSQLForCopy(r.getTable(), newTable, quotedName, false);
            }
            if (sql == null) {
                sql = child.getCreateSQLForCopy(newTable, quotedName);
            }
            if (sql == null) continue;
            if (child instanceof TriggerObject) {
                triggers.add(sql);
                continue;
            }
            if (!hasDelegateIndex) {
                Index index = null;
                if (child instanceof ConstraintUnique) {
                    ConstraintUnique constraint = (ConstraintUnique)child;
                    if (constraint.getConstraintType() == Constraint.Type.PRIMARY_KEY) {
                        index = constraint.getIndex();
                    }
                } else if (child instanceof Index) {
                    index = (Index)child;
                }
                if (index != null && TableBase.getMainIndexColumn(index.getIndexType(), index.getIndexColumns()) != -1) {
                    this.execute(sql);
                    hasDelegateIndex = true;
                    continue;
                }
            }
            children.add(sql);
        }
        StringBuilder builder = newTable.getSQL(new StringBuilder(128).append("INSERT INTO "), 0).append('(').append((CharSequence)columnNames).append(") OVERRIDING SYSTEM VALUE SELECT ");
        if (columnValues.length() == 0) {
            builder.append('*');
        } else {
            builder.append((CharSequence)columnValues);
        }
        table.getSQL(builder.append(" FROM "), 0);
        try {
            this.execute(builder.toString());
        }
        catch (Throwable t) {
            builder = new StringBuilder("DROP TABLE ");
            newTable.getSQL(builder, 0);
            this.execute(builder.toString());
            throw t;
        }
        for (String sql : children) {
            this.execute(sql);
        }
        table.setModified();
        for (Column col : newColumns) {
            Sequence seq = col.getSequence();
            if (seq == null) continue;
            table.removeSequence(seq);
            col.setSequence(null, false);
        }
        for (String sql : triggers) {
            this.execute(sql);
        }
        return newTable;
    }

    private static StringBuilder addColumn(Column column, StringBuilder columnNames, StringBuilder columnValues) {
        if (columnNames.length() > 0) {
            columnNames.append(", ");
        }
        column.getSQL(columnNames, 0);
        if (columnValues.length() > 0) {
            columnValues.append(", ");
        }
        return columnValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkViews(SchemaObject sourceTable, SchemaObject newTable) {
        String sourceTableName = sourceTable.getName();
        String newTableName = newTable.getName();
        Database db = sourceTable.getDatabase();
        String temp = db.getTempTableName(sourceTableName, this.session);
        db.renameSchemaObject(this.session, sourceTable, temp);
        try {
            db.renameSchemaObject(this.session, newTable, sourceTableName);
            this.checkViewsAreValid(sourceTable);
        }
        finally {
            try {
                db.renameSchemaObject(this.session, newTable, newTableName);
            }
            finally {
                db.renameSchemaObject(this.session, sourceTable, sourceTableName);
            }
        }
    }

    private void checkViewsAreValid(DbObject tableOrView) {
        for (DbObject view : tableOrView.getChildren()) {
            if (!(view instanceof TableView)) continue;
            String sql = ((TableView)view).getQuerySQL();
            try {
                this.session.prepare(sql);
            }
            catch (DbException e) {
                throw DbException.get(90083, e, view.getTraceSQL());
            }
            this.checkViewsAreValid(view);
        }
    }

    private void execute(String sql) {
        Prepared command = this.session.prepare(sql);
        CommandContainer commandContainer = new CommandContainer(this.session, sql, command);
        commandContainer.executeUpdate(null);
    }

    private void checkNullable(Table table) {
        if (this.oldColumn.isIdentity()) {
            throw DbException.get(90023, this.oldColumn.getName());
        }
        for (Index index : table.getIndexes()) {
            IndexType indexType;
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey()) continue;
            throw DbException.get(90023, this.oldColumn.getName());
        }
    }

    private void checkNoNullValues(Table table) {
        StringBuilder builder = new StringBuilder("SELECT COUNT(*) FROM ");
        table.getSQL(builder, 0).append(" WHERE ");
        this.oldColumn.getSQL(builder, 0).append(" IS NULL");
        String sql = builder.toString();
        Prepared command = this.session.prepare(sql);
        ResultInterface result = command.query(0L);
        result.next();
        if (result.currentRow()[0].getInt() > 0) {
            throw DbException.get(90081, this.oldColumn.getTraceSQL());
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSelectivity(Expression selectivity) {
        this.newSelectivity = selectivity;
    }

    public void setDefaultExpression(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void setUsingExpression(Expression usingExpression) {
        this.usingExpression = usingExpression;
    }

    public void setNewColumn(Column newColumn) {
        this.newColumn = newColumn;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void addColumn(Column column) {
        if (this.columnsToAdd == null) {
            this.columnsToAdd = new ArrayList();
        }
        this.columnsToAdd.add(column);
    }

    public void setColumnsToRemove(ArrayList<Column> columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    public void setBooleanFlag(boolean booleanFlag) {
        this.booleanFlag = booleanFlag;
    }
}

