/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.AlterTable;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableDropConstraint
extends AlterTable {
    private String constraintName;
    private final boolean ifExists;
    private ConstraintActionType dropAction;

    public AlterTableDropConstraint(SessionLocal session, Schema schema, boolean ifExists) {
        super(session, schema);
        this.ifExists = ifExists;
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public void setDropAction(ConstraintActionType dropAction) {
        this.dropAction = dropAction;
    }

    @Override
    public long update(Table table) {
        Constraint.Type constraintType;
        Constraint constraint = this.getSchema().findConstraint(this.session, this.constraintName);
        if (constraint == null || (constraintType = constraint.getConstraintType()) == Constraint.Type.DOMAIN || constraint.getTable() != table) {
            if (!this.ifExists) {
                throw DbException.get(90057, this.constraintName);
            }
        } else {
            Table refTable = constraint.getRefTable();
            if (refTable != table) {
                this.session.getUser().checkTableRight(refTable, 32);
            }
            if (constraintType == Constraint.Type.PRIMARY_KEY || constraintType == Constraint.Type.UNIQUE) {
                for (Constraint c : constraint.getTable().getConstraints()) {
                    if (c.getReferencedConstraint() != constraint) continue;
                    if (this.dropAction == ConstraintActionType.RESTRICT) {
                        throw DbException.get(90152, constraint.getTraceSQL(), c.getTraceSQL());
                    }
                    Table t = c.getTable();
                    if (t == table || t == refTable) continue;
                    this.session.getUser().checkTableRight(t, 32);
                }
            }
            this.session.getDatabase().removeSchemaObject(this.session, constraint);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 14;
    }
}

