/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.AlterTable;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterTableRenameColumn
extends AlterTable {
    private boolean ifExists;
    private String oldName;
    private String newName;

    public AlterTableRenameColumn(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setOldColumnName(String oldName) {
        this.oldName = oldName;
    }

    public void setNewColumnName(String newName) {
        this.newName = newName;
    }

    @Override
    public long update(Table table) {
        Column column = table.getColumn(this.oldName, this.ifExists);
        if (column == null) {
            return 0L;
        }
        table.checkSupportAlter();
        table.renameColumn(column, this.newName);
        table.setModified();
        Database db = this.session.getDatabase();
        db.updateMeta(this.session, table);
        for (DbObject childDbObject : table.getChildren()) {
            if (!(childDbObject instanceof ConstraintReferential)) continue;
            ConstraintReferential ref = (ConstraintReferential)childDbObject;
            ref.updateOnTableColumnRename();
        }
        for (DbObject child : table.getChildren()) {
            if (child.getCreateSQL() == null) continue;
            db.updateMeta(this.session, child);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 16;
    }
}

