/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;
import org.h2.util.StringUtils;

public class CreateFunctionAlias
extends SchemaCommand {
    private String aliasName;
    private String javaClassMethod;
    private boolean deterministic;
    private boolean ifNotExists;
    private boolean force;
    private String source;

    public CreateFunctionAlias(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        Schema schema = this.getSchema();
        if (schema.findFunctionOrAggregate(this.aliasName) != null) {
            if (!this.ifNotExists) {
                throw DbException.get(90076, this.aliasName);
            }
        } else {
            int id = this.getObjectId();
            FunctionAlias functionAlias = this.javaClassMethod != null ? FunctionAlias.newInstance(schema, id, this.aliasName, this.javaClassMethod, this.force) : FunctionAlias.newInstanceFromSource(schema, id, this.aliasName, this.source, this.force);
            functionAlias.setDeterministic(this.deterministic);
            db.addSchemaObject(this.session, functionAlias);
        }
        return 0L;
    }

    public void setAliasName(String name) {
        this.aliasName = name;
    }

    public void setJavaClassMethod(String method) {
        this.javaClassMethod = StringUtils.replaceAll(method, " ", "");
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public int getType() {
        return 24;
    }
}

