/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class CreateIndex
extends SchemaCommand {
    private String tableName;
    private String indexName;
    private IndexColumn[] indexColumns;
    private int uniqueColumnCount;
    private boolean primaryKey;
    private boolean hash;
    private boolean spatial;
    private boolean ifTableExists;
    private boolean ifNotExists;
    private String comment;

    public CreateIndex(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean b) {
        this.ifTableExists = b;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setIndexColumns(IndexColumn[] columns) {
        this.indexColumns = columns;
    }

    @Override
    public long update() {
        IndexType indexType;
        Database db = this.session.getDatabase();
        boolean persistent = db.isPersistent();
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0L;
            }
            throw DbException.get(42102, this.tableName);
        }
        if (this.indexName != null && this.getSchema().findIndex(this.session, this.indexName) != null) {
            if (this.ifNotExists) {
                return 0L;
            }
            throw DbException.get(42111, this.indexName);
        }
        this.session.getUser().checkTableRight(table, 32);
        table.lock(this.session, 2);
        if (!table.isPersistIndexes()) {
            persistent = false;
        }
        int id = this.getObjectId();
        if (this.indexName == null) {
            this.indexName = this.primaryKey ? table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_") : table.getSchema().getUniqueIndexName(this.session, table, "INDEX_");
        }
        if (this.primaryKey) {
            if (table.findPrimaryKey() != null) {
                throw DbException.get(90017);
            }
            indexType = IndexType.createPrimaryKey(persistent, this.hash);
        } else {
            indexType = this.uniqueColumnCount > 0 ? IndexType.createUnique(persistent, this.hash) : IndexType.createNonUnique(persistent, this.hash, this.spatial);
        }
        IndexColumn.mapColumns(this.indexColumns, table);
        table.addIndex(this.session, this.indexName, id, this.indexColumns, this.uniqueColumnCount, indexType, this.create, this.comment);
        return 0L;
    }

    public void setPrimaryKey(boolean b) {
        this.primaryKey = b;
    }

    public void setUniqueColumnCount(int uniqueColumnCount) {
        this.uniqueColumnCount = uniqueColumnCount;
    }

    public void setHash(boolean b) {
        this.hash = b;
    }

    public void setSpatial(boolean b) {
        this.spatial = b;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public int getType() {
        return 25;
    }
}

