/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;

public class CreateSchema
extends DefineCommand {
    private String schemaName;
    private String authorization;
    private boolean ifNotExists;
    private ArrayList<String> tableEngineParams;

    public CreateSchema(SessionLocal session) {
        super(session);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Override
    public long update() {
        this.session.getUser().checkSchemaAdmin();
        Database db = this.session.getDatabase();
        RightOwner owner = db.findUserOrRole(this.authorization);
        if (owner == null) {
            throw DbException.get(90071, this.authorization);
        }
        if (db.findSchema(this.schemaName) != null) {
            if (this.ifNotExists) {
                return 0L;
            }
            throw DbException.get(90078, this.schemaName);
        }
        int id = this.getObjectId();
        Schema schema = new Schema(db, id, this.schemaName, owner, false);
        schema.setTableEngineParams(this.tableEngineParams);
        db.addDatabaseObject(this.session, schema);
        return 0L;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public void setAuthorization(String userName) {
        this.authorization = userName;
    }

    public void setTableEngineParams(ArrayList<String> tableEngineParams) {
        this.tableEngineParams = tableEngineParams;
    }

    @Override
    public int getType() {
        return 28;
    }
}

