/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.Insert;
import org.h2.command.query.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;

public class CreateTable
extends CommandWithColumns {
    private final CreateTableData data = new CreateTableData();
    private boolean ifNotExists;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean withNoData;

    public CreateTable(SessionLocal session, Schema schema) {
        super(session, schema);
        this.data.persistIndexes = true;
        this.data.persistData = true;
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean temporary) {
        this.data.temporary = temporary;
    }

    public void setTableName(String tableName) {
        this.data.tableName = tableName;
    }

    @Override
    public void addColumn(Column column) {
        this.data.columns.add(column);
    }

    public ArrayList<Column> getColumns() {
        return this.data.columns;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long update() {
        block31: {
            Schema schema = this.getSchema();
            boolean isSessionTemporary = this.data.temporary && !this.data.globalTemporary;
            Database db = this.session.getDatabase();
            String tableEngine = this.data.tableEngine;
            if (tableEngine != null || db.getSettings().defaultTableEngine != null) {
                this.session.getUser().checkAdmin();
            } else if (!isSessionTemporary) {
                this.session.getUser().checkSchemaOwner(schema);
            }
            if (!db.isPersistent()) {
                this.data.persistIndexes = false;
            }
            if (!isSessionTemporary) {
                db.lockMeta(this.session);
            }
            if (schema.resolveTableOrView(this.session, this.data.tableName) != null) {
                if (this.ifNotExists) {
                    return 0L;
                }
                throw DbException.get(42101, this.data.tableName);
            }
            if (this.asQuery != null) {
                this.asQuery.prepare();
                if (this.data.columns.isEmpty()) {
                    this.generateColumnsFromQuery();
                } else {
                    if (this.data.columns.size() != this.asQuery.getColumnCount()) {
                        throw DbException.get(21002);
                    }
                    ArrayList<Column> columns = this.data.columns;
                    for (int i = 0; i < columns.size(); ++i) {
                        Column column = columns.get(i);
                        if (column.getType().getValueType() != -1) continue;
                        columns.set(i, new Column(column.getName(), this.asQuery.getExpressions().get(i).getType()));
                    }
                }
            }
            this.changePrimaryKeysToNotNull(this.data.columns);
            this.data.id = this.getObjectId();
            this.data.session = this.session;
            Table table = schema.createTable(this.data);
            ArrayList<Sequence> sequences = this.generateSequences(this.data.columns, this.data.temporary);
            table.setComment(this.comment);
            if (isSessionTemporary) {
                if (this.onCommitDrop) {
                    table.setOnCommitDrop(true);
                }
                if (this.onCommitTruncate) {
                    table.setOnCommitTruncate(true);
                }
                this.session.addLocalTempTable(table);
            } else {
                db.lockMeta(this.session);
                db.addSchemaObject(this.session, table);
            }
            try {
                boolean bl;
                Sequence s;
                for (Column column : this.data.columns) {
                    column.prepareExpressions(this.session);
                }
                for (Sequence sequence : sequences) {
                    table.addSequence(sequence);
                }
                this.createConstraints();
                HashSet<DbObject> set = new HashSet<DbObject>();
                table.addDependencies(set);
                for (DbObject dbObject : set) {
                    Table t;
                    if (dbObject == table || dbObject.getType() != 0 || !(dbObject instanceof Table) || (t = (Table)dbObject).getId() <= table.getId()) continue;
                    throw DbException.get(50100, "Table depends on another table with a higher ID: " + t + ", this is currently not supported, as it would prevent the database from being re-opened");
                }
                if (this.asQuery == null || this.withNoData) break block31;
                boolean bl2 = false;
                if (!isSessionTemporary) {
                    db.unlockMeta(this.session);
                    Column[] columnArray = table.getColumns();
                    int n = columnArray.length;
                    for (int i = 0; i < n; ++i) {
                        Column c = columnArray[i];
                        s = c.getSequence();
                        if (s == null) continue;
                        bl = true;
                        s.setTemporary(true);
                    }
                }
                try {
                    this.session.startStatementWithinTransaction(null);
                    Insert insert = new Insert(this.session);
                    insert.setQuery(this.asQuery);
                    insert.setTable(table);
                    insert.setInsertFromSelect(true);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.endStatement();
                }
                if (bl) {
                    db.lockMeta(this.session);
                    for (Column c : table.getColumns()) {
                        s = c.getSequence();
                        if (s == null) continue;
                        s.setTemporary(false);
                        s.flush(this.session);
                    }
                }
            }
            catch (DbException e) {
                try {
                    db.checkPowerOff();
                    db.removeSchemaObject(this.session, table);
                    if (!this.transactional) {
                        this.session.commit(true);
                    }
                }
                catch (Throwable throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        return 0L;
    }

    private void generateColumnsFromQuery() {
        int columnCount = this.asQuery.getColumnCount();
        ArrayList<Expression> expressions = this.asQuery.getExpressions();
        for (int i = 0; i < columnCount; ++i) {
            Expression expr = expressions.get(i);
            this.addColumn(new Column(expr.getColumnNameForView(this.session, i), expr.getType()));
        }
    }

    public void setPersistIndexes(boolean persistIndexes) {
        this.data.persistIndexes = persistIndexes;
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.data.globalTemporary = globalTemporary;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setPersistData(boolean persistData) {
        this.data.persistData = persistData;
        if (!persistData) {
            this.data.persistIndexes = false;
        }
    }

    public void setWithNoData(boolean withNoData) {
        this.withNoData = withNoData;
    }

    public void setTableEngine(String tableEngine) {
        this.data.tableEngine = tableEngine;
    }

    public void setTableEngineParams(ArrayList<String> tableEngineParams) {
        this.data.tableEngineParams = tableEngineParams;
    }

    public void setHidden(boolean isHidden) {
        this.data.isHidden = isHidden;
    }

    @Override
    public int getType() {
        return 30;
    }
}

