/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.value.ValueNull;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(SessionLocal session) {
        super(session);
    }

    @Override
    public long update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0L;
    }

    private void dropAllObjects() {
        boolean runLoopAgain;
        User user = this.session.getUser();
        user.checkAdmin();
        Database db = this.session.getDatabase();
        db.lockMeta(this.session);
        do {
            ArrayList<Table> tables = db.getAllTablesAndViews();
            ArrayList<Table> toRemove = new ArrayList<Table>(tables.size());
            for (Table t : tables) {
                if (t.getName() == null || TableType.VIEW != t.getTableType()) continue;
                toRemove.add(t);
            }
            for (Table t : tables) {
                if (t.getName() == null || TableType.TABLE_LINK != t.getTableType()) continue;
                toRemove.add(t);
            }
            for (Table t : tables) {
                if (t.getName() == null || TableType.TABLE != t.getTableType() || t.isHidden()) continue;
                toRemove.add(t);
            }
            for (Table t : tables) {
                if (t.getName() == null || TableType.EXTERNAL_TABLE_ENGINE != t.getTableType() || t.isHidden()) continue;
                toRemove.add(t);
            }
            runLoopAgain = false;
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                Table t;
                t = (Table)iterator.next();
                if (t.getName() == null) continue;
                if (db.getDependentTable(t, t) == null) {
                    db.removeSchemaObject(this.session, t);
                    continue;
                }
                runLoopAgain = true;
            }
        } while (runLoopAgain);
        Collection<Schema> schemas = db.getAllSchemasNoMeta();
        for (Schema schema : schemas) {
            if (!schema.canDrop()) continue;
            db.removeDatabaseObject(this.session, schema);
        }
        ArrayList<SchemaObject> list = new ArrayList<SchemaObject>();
        for (Schema schema : schemas) {
            for (Sequence sequence : schema.getAllSequences()) {
                if (sequence.getBelongsToTable()) continue;
                list.add(sequence);
            }
        }
        DropDatabase.addAll(schemas, 5, list);
        DropDatabase.addAll(schemas, 4, list);
        DropDatabase.addAll(schemas, 11, list);
        DropDatabase.addAll(schemas, 9, list);
        DropDatabase.addAll(schemas, 12, list);
        for (SchemaObject obj : list) {
            if (!obj.getSchema().isValid() || obj.isHidden()) continue;
            db.removeSchemaObject(this.session, obj);
        }
        Role role = db.getPublicRole();
        for (RightOwner rightOwner : db.getAllUsersAndRoles()) {
            if (rightOwner == user || rightOwner == role) continue;
            db.removeDatabaseObject(this.session, rightOwner);
        }
        for (Right right : db.getAllRights()) {
            db.removeDatabaseObject(this.session, right);
        }
        for (Iterator<DbObject> iterator : db.getSessions(false)) {
            ((SessionLocal)((Object)iterator)).setLastIdentity(ValueNull.INSTANCE);
        }
    }

    private static void addAll(Collection<Schema> schemas, int type, ArrayList<SchemaObject> list) {
        for (Schema schema : schemas) {
            schema.getAll(type, list);
        }
    }

    public void setDropAllObjects(boolean b) {
        this.dropAllObjects = b;
    }

    public void setDeleteFiles(boolean b) {
        this.deleteFiles = b;
    }

    @Override
    public int getType() {
        return 38;
    }
}

