/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;

public class DropFunctionAlias
extends SchemaOwnerCommand {
    private String aliasName;
    private boolean ifExists;

    public DropFunctionAlias(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    @Override
    long update(Schema schema) {
        Database db = this.session.getDatabase();
        FunctionAlias functionAlias = schema.findFunction(this.aliasName);
        if (functionAlias == null) {
            if (!this.ifExists) {
                throw DbException.get(90077, this.aliasName);
            }
        } else {
            db.removeSchemaObject(this.session, functionAlias);
        }
        return 0L;
    }

    public void setAliasName(String name) {
        this.aliasName = name;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public int getType() {
        return 39;
    }
}

