/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class DropIndex
extends SchemaCommand {
    private String indexName;
    private boolean ifExists;

    public DropIndex(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public long update() {
        Database db = this.session.getDatabase();
        Index index = this.getSchema().findIndex(this.session, this.indexName);
        if (index == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.indexName);
            }
        } else {
            Table table = index.getTable();
            this.session.getUser().checkTableRight(index.getTable(), 32);
            Constraint pkConstraint = null;
            ArrayList<Constraint> constraints = table.getConstraints();
            for (int i = 0; constraints != null && i < constraints.size(); ++i) {
                Constraint cons = constraints.get(i);
                if (!cons.usesIndex(index)) continue;
                if (Constraint.Type.PRIMARY_KEY == cons.getConstraintType()) {
                    for (Constraint c : constraints) {
                        if (c.getReferencedConstraint() != cons) continue;
                        throw DbException.get(90085, this.indexName, cons.getName());
                    }
                    pkConstraint = cons;
                    continue;
                }
                throw DbException.get(90085, this.indexName, cons.getName());
            }
            index.getTable().setModified();
            if (pkConstraint != null) {
                db.removeSchemaObject(this.session, pkConstraint);
            } else {
                db.removeSchemaObject(this.session, index);
            }
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 40;
    }
}

