/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.h2.command.ddl.DefineCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.Utils;

public class DropTable
extends DefineCommand {
    private boolean ifExists;
    private ConstraintActionType dropAction;
    private final ArrayList<SchemaAndTable> tables = Utils.newSmallArrayList();

    public DropTable(SessionLocal session) {
        super(session);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void addTable(Schema schema, String tableName) {
        this.tables.add(new SchemaAndTable(schema, tableName));
    }

    private boolean prepareDrop() {
        HashSet<Table> tablesToDrop = new HashSet<Table>();
        for (SchemaAndTable schemaAndTable : this.tables) {
            String tableName = schemaAndTable.tableName;
            Table table = schemaAndTable.schema.findTableOrView(this.session, tableName);
            if (table == null) {
                if (this.ifExists) continue;
                throw DbException.get(42102, tableName);
            }
            this.session.getUser().checkTableRight(table, 32);
            if (!table.canDrop()) {
                throw DbException.get(90118, tableName);
            }
            tablesToDrop.add(table);
        }
        if (tablesToDrop.isEmpty()) {
            return false;
        }
        for (Table table : tablesToDrop) {
            ArrayList<String> dependencies = new ArrayList<String>();
            if (this.dropAction == ConstraintActionType.RESTRICT) {
                ArrayList<Constraint> constraints;
                CopyOnWriteArrayList<TableView> dependentViews = table.getDependentViews();
                if (dependentViews != null && !dependentViews.isEmpty()) {
                    for (TableView v : dependentViews) {
                        if (tablesToDrop.contains(v)) continue;
                        dependencies.add(v.getName());
                    }
                }
                if ((constraints = table.getConstraints()) != null && !constraints.isEmpty()) {
                    for (Constraint c : constraints) {
                        if (tablesToDrop.contains(c.getTable())) continue;
                        dependencies.add(c.getName());
                    }
                }
                if (!dependencies.isEmpty()) {
                    throw DbException.get(90107, table.getName(), String.join((CharSequence)", ", dependencies));
                }
            }
            table.lock(this.session, 2);
        }
        return true;
    }

    private void executeDrop() {
        for (SchemaAndTable schemaAndTable : this.tables) {
            Table table = schemaAndTable.schema.findTableOrView(this.session, schemaAndTable.tableName);
            if (table == null) continue;
            table.setModified();
            Database db = this.session.getDatabase();
            db.lockMeta(this.session);
            db.removeSchemaObject(this.session, table);
        }
    }

    @Override
    public long update() {
        if (this.prepareDrop()) {
            this.executeDrop();
        }
        return 0L;
    }

    public void setDropAction(ConstraintActionType dropAction) {
        this.dropAction = dropAction;
    }

    @Override
    public int getType() {
        return 44;
    }

    private static final class SchemaAndTable {
        final Schema schema;
        final String tableName;

        SchemaAndTable(Schema schema, String tableName) {
            this.schema = schema;
            this.tableName = tableName;
        }
    }
}

