/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.message.DbException;

public class DropUser
extends DefineCommand {
    private boolean ifExists;
    private String userName;

    public DropUser(SessionLocal session) {
        super(session);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        User user = db.findUser(this.userName);
        if (user == null) {
            if (!this.ifExists) {
                throw DbException.get(90032, this.userName);
            }
        } else {
            if (user == this.session.getUser()) {
                int adminUserCount = 0;
                for (RightOwner rightOwner : db.getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof User) || !((User)rightOwner).isAdmin()) continue;
                    ++adminUserCount;
                }
                if (adminUserCount == 1) {
                    throw DbException.get(90019);
                }
            }
            user.checkOwnsNoSchemas();
            db.removeDatabaseObject(this.session, user);
        }
        return 0L;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public int getType() {
        return 46;
    }
}

