/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.table.TableView;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropView(SessionLocal session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setDropAction(ConstraintActionType dropAction) {
        this.dropAction = dropAction;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public long update() {
        Table view = this.getSchema().findTableOrView(this.session, this.viewName);
        if (view == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (TableType.VIEW != view.getTableType()) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkSchemaOwner(view.getSchema());
            if (this.dropAction == ConstraintActionType.RESTRICT) {
                for (DbObject child : view.getChildren()) {
                    if (!(child instanceof TableView)) continue;
                    throw DbException.get(90107, this.viewName, child.getName());
                }
            }
            TableView tableView = (TableView)view;
            ArrayList<Table> copyOfDependencies = new ArrayList<Table>(tableView.getTables());
            view.lock(this.session, 2);
            this.session.getDatabase().removeSchemaObject(this.session, view);
            for (Table childTable : copyOfDependencies) {
                TableView childTableView;
                if (TableType.VIEW != childTable.getTableType() || !(childTableView = (TableView)childTable).isTableExpression() || childTableView.getName() == null) continue;
                this.session.getDatabase().removeSchemaObject(this.session, childTableView);
            }
            this.session.getDatabase().unlockMeta(this.session);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 48;
    }
}

