/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class SetComment
extends DefineCommand {
    private String schemaName;
    private String objectName;
    private boolean column;
    private String columnName;
    private int objectType;
    private Expression expr;

    public SetComment(SessionLocal session) {
        super(session);
    }

    @Override
    public long update() {
        Database db = this.session.getDatabase();
        DbObject object = null;
        int errorCode = 50000;
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        switch (this.objectType) {
            case 11: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.getConstant(this.objectName);
                break;
            }
            case 5: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.getConstraint(this.objectName);
                break;
            }
            case 9: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.findFunction(this.objectName);
                errorCode = 90077;
                break;
            }
            case 1: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.getIndex(this.objectName);
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                this.schemaName = null;
                object = db.findRole(this.objectName);
                errorCode = 90070;
                break;
            }
            case 10: {
                this.schemaName = null;
                Schema schema = db.getSchema(this.objectName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema;
                break;
            }
            case 3: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.getSequence(this.objectName);
                break;
            }
            case 0: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.getTableOrView(this.session, this.objectName);
                break;
            }
            case 4: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.findTrigger(this.objectName);
                errorCode = 90042;
                break;
            }
            case 2: {
                this.session.getUser().checkAdmin();
                this.schemaName = null;
                object = db.getUser(this.objectName);
                break;
            }
            case 12: {
                Schema schema = db.getSchema(this.schemaName);
                this.session.getUser().checkSchemaOwner(schema);
                object = schema.findDomain(this.objectName);
                errorCode = 90120;
                break;
            }
        }
        if (object == null) {
            throw DbException.get(errorCode, this.objectName);
        }
        String text = this.expr.optimize(this.session).getValue(this.session).getString();
        if (text != null && text.isEmpty()) {
            text = null;
        }
        if (this.column) {
            Table table = (Table)object;
            table.getColumn(this.columnName).setComment(text);
        } else {
            object.setComment(text);
        }
        if (this.column || this.objectType == 0 || this.objectType == 2 || this.objectType == 1 || this.objectType == 5) {
            db.updateMeta(this.session, object);
        } else {
            Comment comment = db.findComment(object);
            if (comment == null) {
                if (text != null) {
                    int id = this.getObjectId();
                    comment = new Comment(db, id, object);
                    comment.setCommentText(text);
                    db.addDatabaseObject(this.session, comment);
                }
            } else if (text == null) {
                db.removeDatabaseObject(this.session, comment);
            } else {
                comment.setCommentText(text);
                db.updateMeta(this.session, comment);
            }
        }
        return 0L;
    }

    public void setCommentExpression(Expression expr) {
        this.expr = expr;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setObjectType(int objectType) {
        this.objectType = objectType;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setColumn(boolean column) {
        this.column = column;
    }

    @Override
    public int getType() {
        return 52;
    }
}

