/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.Store;
import org.h2.result.ResultInterface;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(SessionLocal session) {
        super(session);
    }

    public void setFileName(Expression fileName) {
        this.fileNameExpr = fileName;
    }

    @Override
    public long update() {
        String name = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(name);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String fileName) {
        Database db = this.session.getDatabase();
        if (!db.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            Store store = db.getStore();
            store.flush();
            String name = db.getName();
            name = FileUtils.getName(name);
            try (OutputStream zip = FileUtils.newOutputStream(fileName, false);){
                ZipOutputStream out = new ZipOutputStream(zip);
                db.flush();
                String base = FileUtils.getParent(db.getName());
                Object object = db.getLobSyncObject();
                synchronized (object) {
                    String prefix = db.getDatabasePath();
                    String dir = FileUtils.getParent(prefix);
                    dir = FileLister.getDir(dir);
                    ArrayList<String> fileList = FileLister.getDatabaseFiles(dir, name, true);
                    for (String n : fileList) {
                        if (!n.endsWith(".mv.db")) continue;
                        MVStore s = store.getMvStore();
                        boolean before = s.getReuseSpace();
                        s.setReuseSpace(false);
                        try {
                            InputStream in = store.getInputStream();
                            BackupCommand.backupFile(out, base, n, in);
                        }
                        finally {
                            s.setReuseSpace(before);
                        }
                    }
                }
                out.close();
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, fileName);
        }
    }

    private static void backupFile(ZipOutputStream out, String base, String fn, InputStream in) throws IOException {
        String f = FileUtils.toRealPath(fn);
        if (!f.startsWith(base = FileUtils.toRealPath(base))) {
            throw DbException.getInternalError(f + " does not start with " + base);
        }
        f = f.substring(base.length());
        f = BackupCommand.correctFileName(f);
        out.putNextEntry(new ZipEntry(f));
        IOUtils.copyAndCloseInput(in, out);
        out.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String f) {
        if ((f = f.replace('\\', '/')).startsWith("/")) {
            f = f.substring(1);
        }
        return f;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

