/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.engine.SessionLocal;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.table.TableFunction;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.value.Value;

public class Call
extends Prepared {
    private Expression expression;
    private TableFunction tableFunction;
    private Expression[] expressions;

    public Call(SessionLocal session) {
        super(session);
    }

    @Override
    public ResultInterface queryMeta() {
        int columnCount = this.expressions.length;
        LocalResult result = new LocalResult(this.session, this.expressions, columnCount, columnCount);
        result.done();
        return result;
    }

    @Override
    public long update() {
        if (this.tableFunction != null) {
            return super.update();
        }
        Value v = this.expression.getValue(this.session);
        int type = v.getValueType();
        switch (type) {
            case -1: 
            case 0: {
                return 0L;
            }
        }
        return v.getInt();
    }

    @Override
    public ResultInterface query(long maxrows) {
        this.setCurrentRowNumber(1L);
        if (this.tableFunction != null) {
            return this.tableFunction.getValue(this.session);
        }
        LocalResult result = new LocalResult(this.session, this.expressions, 1, 1);
        result.addRow(this.expression.getValue(this.session));
        result.done();
        return result;
    }

    @Override
    public void prepare() {
        if (this.tableFunction != null) {
            this.prepareAlways = true;
            this.tableFunction.optimize(this.session);
            ResultInterface result = this.tableFunction.getValueTemplate(this.session);
            int columnCount = result.getVisibleColumnCount();
            this.expressions = new Expression[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String name = result.getColumnName(i);
                String alias = result.getAlias(i);
                Expression e = new ExpressionColumn(this.session.getDatabase(), new Column(name, result.getColumnType(i)));
                if (!alias.equals(name)) {
                    e = new Alias(e, alias, false);
                }
                this.expressions[i] = e;
            }
        } else {
            this.expression = this.expression.optimize(this.session);
            this.expressions = new Expression[]{this.expression};
        }
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setTableFunction(TableFunction tableFunction) {
        this.tableFunction = tableFunction;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.tableFunction == null && this.expression.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public int getType() {
        return 57;
    }

    @Override
    public boolean isCacheable() {
        return this.tableFunction == null;
    }
}

