/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashSet;
import org.h2.command.dml.FilteredDataChangeStatement;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class Delete
extends FilteredDataChangeStatement {
    public Delete(SessionLocal session) {
        super(session);
    }

    @Override
    public long update(ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        Value v;
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        this.session.getUser().checkTableRight(table, 2);
        table.fire(this.session, 4, true);
        table.lock(this.session, 1);
        long limitRows = -1L;
        if (this.fetchExpr != null && ((v = this.fetchExpr.getValue(this.session)) == ValueNull.INSTANCE || (limitRows = v.getLong()) < 0L)) {
            throw DbException.getInvalidValueException("FETCH", v);
        }
        try (LocalResult rows = LocalResult.forTable(this.session, table);){
            this.setCurrentRowNumber(0L);
            long count = 0L;
            while (this.nextRow(limitRows, count)) {
                Row row = this.targetTableFilter.get();
                if (table.isRowLockable()) {
                    Row lockedRow = table.lockRow(this.session, row);
                    if (lockedRow == null) continue;
                    if (!row.hasSharedData(lockedRow)) {
                        row = lockedRow;
                        this.targetTableFilter.set(row);
                        if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                    }
                }
                if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.OLD) {
                    deltaChangeCollector.addRow(row.getValueList());
                }
                if (!table.fireRow() || !table.fireBeforeRow(this.session, row, null)) {
                    rows.addRowForTable(row);
                }
                ++count;
            }
            rows.done();
            long rowScanCount = 0L;
            while (rows.next()) {
                if ((++rowScanCount & 0x7FL) == 0L) {
                    this.checkCanceled();
                }
                Row row = rows.currentRowForTable();
                table.removeRow(this.session, row);
            }
            if (table.fireRow()) {
                rows.reset();
                while (rows.next()) {
                    table.fireAfterRow(this.session, rows.currentRowForTable(), null, false);
                }
            }
            table.fire(this.session, 4, false);
            long l = count;
            return l;
        }
    }

    @Override
    public String getPlanSQL(int sqlFlags) {
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        this.targetTableFilter.getPlanSQL(builder, false, sqlFlags);
        this.appendFilterCondition(builder, sqlFlags);
        return builder.toString();
    }

    @Override
    void doPrepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            this.condition = this.condition.optimizeCondition(this.session);
            if (this.condition != null) {
                this.condition.createIndexConditions(this.session, this.targetTableFilter);
            }
        }
        TableFilter[] filters = new TableFilter[]{this.targetTableFilter};
        PlanItem item = this.targetTableFilter.getBestPlanItem(this.session, filters, 0, new AllColumnsForPlan(filters));
        this.targetTableFilter.setPlanItem(item);
        this.targetTableFilter.prepare();
    }

    @Override
    public int getType() {
        return 58;
    }

    @Override
    public String getStatementName() {
        return "DELETE";
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        if (this.condition != null) {
            this.condition.isEverything(visitor);
        }
    }
}

