/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;

public class ExecuteImmediate
extends Prepared {
    private Expression statement;

    public ExecuteImmediate(SessionLocal session, Expression statement) {
        super(session);
        this.statement = statement.optimize(session);
    }

    @Override
    public long update() {
        String sql = this.statement.getValue(this.session).getString();
        if (sql == null) {
            throw DbException.getInvalidValueException("SQL command", null);
        }
        Prepared command = this.session.prepare(sql);
        if (command.isQuery()) {
            throw DbException.get(42001, sql, "<not a query>");
        }
        return command.update();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public int getType() {
        return 91;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }
}

