/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.TimeZoneOperation;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.mode.DefaultNullOrdering;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.security.auth.AuthenticatorFactory;
import org.h2.table.Table;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

public class Set
extends Prepared {
    private final int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(SessionLocal session, int type) {
        super(session);
        this.type = type;
    }

    public void setString(String v) {
        this.stringValue = v;
    }

    @Override
    public boolean isTransactional() {
        switch (this.type) {
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long update() {
        Database database = this.session.getDatabase();
        String name = SetTypes.getTypeName(this.type);
        block42 : switch (this.type) {
            case 21: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", value);
                }
                Database database2 = database;
                synchronized (database2) {
                    database.setAllowLiterals(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 7: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("CACHE_SIZE", value);
                }
                Database database3 = database;
                synchronized (database3) {
                    database.setCacheSize(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 12: {
                SessionLocal sysSession;
                String value;
                if ("TRUE".equals(this.stringValue) || (value = StringUtils.quoteStringSQL(this.stringValue)).equals(database.getCluster())) break;
                if (!value.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(value);
                SessionLocal sessionLocal = sysSession = database.getSystemSession();
                synchronized (sessionLocal) {
                    Database database4 = database;
                    synchronized (database4) {
                        this.addOrUpdateSetting(sysSession, name, value, 0);
                        sysSession.commit(true);
                        break;
                    }
                }
            }
            case 11: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                StringBuilder buff = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0);
                } else {
                    int strength = this.getIntValue();
                    buff.append(" STRENGTH ");
                    if (strength == 3) {
                        buff.append("IDENTICAL");
                    } else if (strength == 0) {
                        buff.append("PRIMARY");
                    } else if (strength == 1) {
                        buff.append("SECONDARY");
                    } else if (strength == 2) {
                        buff.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, strength);
                }
                Database database5 = database;
                synchronized (database5) {
                    CompareMode old = database.getCompareMode();
                    if (old.equals(compareMode)) {
                        break;
                    }
                    Table table = database.getFirstUserTable();
                    if (table != null) {
                        throw DbException.get(90089, table.getTraceSQL());
                    }
                    this.addOrUpdateSetting(name, buff.toString(), 0);
                    database.setCompareMode(compareMode);
                    break;
                }
            }
            case 28: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int value = this.getIntValue();
                Database buff = database;
                synchronized (buff) {
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 14: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value != -1 && value < 0) {
                    throw DbException.getInvalidValueException("DB_CLOSE_DELAY", value);
                }
                Database buff = database;
                synchronized (buff) {
                    database.setCloseDelay(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 5: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("DEFAULT_LOCK_TIMEOUT", value);
                }
                Database buff = database;
                synchronized (buff) {
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 6: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                Database buff = database;
                synchronized (buff) {
                    database.setDefaultTableType(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 27: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                switch (value) {
                    case 0: {
                        if (database.unsetExclusiveSession(this.session)) break block42;
                        throw DbException.get(90135);
                    }
                    case 1: {
                        if (database.setExclusiveSession(this.session, false)) break block42;
                        throw DbException.get(90135);
                    }
                    case 2: {
                        if (database.setExclusiveSession(this.session, true)) break block42;
                        throw DbException.get(90135);
                    }
                    default: {
                        throw DbException.getInvalidValueException("EXCLUSIVE", value);
                    }
                }
            }
            case 32: {
                this.session.getUser().checkAdmin();
                Database value = database;
                synchronized (value) {
                    Table table = database.getFirstUserTable();
                    if (table != null) {
                        throw DbException.get(90141, table.getTraceSQL());
                    }
                    database.setJavaObjectSerializerName(this.stringValue);
                    this.addOrUpdateSetting(name, this.stringValue, 0);
                    break;
                }
            }
            case 0: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                Database table = database;
                synchronized (table) {
                    database.setIgnoreCase(value == 1);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 16: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                Database table = database;
                synchronized (table) {
                    database.setLockMode(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 4: {
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("LOCK_TIMEOUT", value);
                }
                this.session.setLockTimeout(value);
                break;
            }
            case 20: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", value);
                }
                Database table = database;
                synchronized (table) {
                    database.setMaxLengthInplaceLob(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 1: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value >= 0) break;
                throw DbException.getInvalidValueException("MAX_LOG_SIZE", value);
            }
            case 15: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_ROWS", value);
                }
                Database table = database;
                synchronized (table) {
                    database.setMaxMemoryRows(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 19: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", value);
                }
                Database table = database;
                synchronized (table) {
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 26: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_OPERATION_MEMORY", value);
                }
                database.setMaxOperationMemory(value);
                break;
            }
            case 2: {
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                if (database.getMode() == mode) break;
                this.session.getUser().checkAdmin();
                database.setMode(mode);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 30: {
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("QUERY_TIMEOUT", value);
                }
                this.session.setQueryTimeout(value);
                break;
            }
            case 31: {
                DbException.getUnsupportedException("MV_STORE + SET REDO_LOG_BINARY");
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", value);
                }
                database.setReferentialIntegrity(value == 1);
                break;
            }
            case 34: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS", value);
                }
                database.setQueryStatistics(value == 1);
                break;
            }
            case 35: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS_MAX_ENTRIES", value);
                }
                database.setQueryStatisticsMaxEntries(value);
                break;
            }
            case 22: {
                Schema schema = database.getSchema(this.expression.optimize(this.session).getValue(this.session).getString());
                this.session.setCurrentSchema(schema);
                break;
            }
            case 24: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 40: {
                String shortName = database.getShortName();
                String value = this.expression.optimize(this.session).getValue(this.session).getString();
                if (value != null && (database.equalsIdentifiers(shortName, value) || database.equalsIdentifiers(shortName, value.trim()))) break;
                throw DbException.get(90013, this.stringValue);
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("TRACE_MAX_FILE_SIZE", value);
                }
                int size = value * 0x100000;
                Database database6 = database;
                synchronized (database6) {
                    database.getTraceSystem().setMaxFileSize(size);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 18: {
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", value);
                }
                this.session.setThrottle(value);
                break;
            }
            case 29: {
                Expression expr = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expr.getValue(this.session));
                break;
            }
            case 13: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("WRITE_DELAY", value);
                }
                Database size = database;
                synchronized (size) {
                    database.setWriteDelay(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 33: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("RETENTION_TIME", value);
                }
                Database size = database;
                synchronized (size) {
                    database.setRetentionTime(value);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 36: {
                int value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("LAZY_QUERY_EXECUTION", value);
                }
                this.session.setLazyQueryExecution(value == 1);
                break;
            }
            case 37: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("BUILTIN_ALIAS_OVERRIDE", value);
                }
                database.setAllowBuiltinAliasOverride(value == 1);
                break;
            }
            case 38: {
                this.session.getUser().checkAdmin();
                boolean value = this.expression.optimize(this.session).getBooleanValue(this.session);
                try {
                    Database size = database;
                    synchronized (size) {
                        if (value) {
                            database.setAuthenticator(AuthenticatorFactory.createAuthenticator());
                        } else {
                            database.setAuthenticator(null);
                        }
                        this.addOrUpdateSetting(name, value ? "TRUE" : "FALSE", 0);
                    }
                }
                catch (Exception e) {
                    if (!database.isStarting()) {
                        throw DbException.convert(e);
                    }
                    database.getTrace(2).error(e, "{0}: failed to set authenticator during database start ", this.expression.toString());
                }
                break;
            }
            case 39: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                Database e = database;
                synchronized (e) {
                    database.setIgnoreCatalogs(value == 1);
                    this.addOrUpdateSetting(name, null, value);
                    break;
                }
            }
            case 41: {
                this.session.setNonKeywords(Parser.parseNonKeywords(this.stringValueList));
                break;
            }
            case 42: {
                this.session.setTimeZone(this.expression == null ? DateTimeUtils.getTimeZone() : Set.parseTimeZone(this.expression.getValue(this.session)));
                break;
            }
            case 43: {
                this.session.setVariableBinary(this.expression.getBooleanValue(this.session));
                break;
            }
            case 44: {
                DefaultNullOrdering defaultNullOrdering;
                try {
                    defaultNullOrdering = DefaultNullOrdering.valueOf(StringUtils.toUpperEnglish(this.stringValue));
                }
                catch (RuntimeException e) {
                    throw DbException.getInvalidValueException("DEFAULT_NULL_ORDERING", this.stringValue);
                }
                if (database.getDefaultNullOrdering() == defaultNullOrdering) break;
                this.session.getUser().checkAdmin();
                database.setDefaultNullOrdering(defaultNullOrdering);
                break;
            }
            case 45: {
                this.session.setTruncateLargeLength(this.expression.getBooleanValue(this.session));
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0L;
    }

    private static TimeZoneProvider parseTimeZone(Value v) {
        if (DataType.isCharacterStringType(v.getValueType())) {
            TimeZoneProvider timeZone;
            try {
                timeZone = TimeZoneProvider.ofId(v.getString());
            }
            catch (IllegalArgumentException ex) {
                throw DbException.getInvalidValueException("TIME ZONE", v.getTraceSQL());
            }
            return timeZone;
        }
        if (v == ValueNull.INSTANCE) {
            throw DbException.getInvalidValueException("TIME ZONE", v);
        }
        return TimeZoneProvider.ofOffset(TimeZoneOperation.parseInterval(v));
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int value) {
        this.expression = ValueExpression.get(ValueInteger.get(value));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String name, String s, int v) {
        this.addOrUpdateSetting(this.session, name, s, v);
    }

    private void addOrUpdateSetting(SessionLocal session, String name, String s, int v) {
        Database database = session.getDatabase();
        assert (Thread.holdsLock(database));
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(name);
        boolean addNew = false;
        if (setting == null) {
            addNew = true;
            int id = this.getObjectId();
            setting = new Setting(database, id, name);
        }
        if (s != null) {
            if (!addNew && setting.getStringValue().equals(s)) {
                return;
            }
            setting.setStringValue(s);
        } else {
            if (!addNew && setting.getIntValue() == v) {
                return;
            }
            setting.setIntValue(v);
        }
        if (addNew) {
            database.addDatabaseObject(session, setting);
        } else {
            database.updateMeta(session, setting);
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] list) {
        this.stringValueList = list;
    }

    @Override
    public int getType() {
        return 67;
    }
}

