/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashSet;
import org.h2.command.Prepared;
import org.h2.command.dml.FilteredDataChangeStatement;
import org.h2.command.dml.Insert;
import org.h2.command.dml.SetClauseList;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class Update
extends FilteredDataChangeStatement {
    private SetClauseList setClauseList;
    private Insert onDuplicateKeyInsert;
    private TableFilter fromTableFilter;

    public Update(SessionLocal session) {
        super(session);
    }

    public void setSetClauseList(SetClauseList setClauseList) {
        this.setClauseList = setClauseList;
    }

    public void setFromTableFilter(TableFilter tableFilter) {
        this.fromTableFilter = tableFilter;
    }

    @Override
    public long update(ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode) {
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        try (LocalResult rows = LocalResult.forTable(this.session, table);){
            Value v;
            this.session.getUser().checkTableRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, 1);
            this.setCurrentRowNumber(0L);
            long count = 0L;
            long limitRows = -1L;
            if (this.fetchExpr != null && ((v = this.fetchExpr.getValue(this.session)) == ValueNull.INSTANCE || (limitRows = v.getLong()) < 0L)) {
                throw DbException.getInvalidValueException("FETCH", v);
            }
            while (this.nextRow(limitRows, count)) {
                Row oldRow = this.targetTableFilter.get();
                if (table.isRowLockable()) {
                    Row lockedRow = table.lockRow(this.session, oldRow);
                    if (lockedRow == null) continue;
                    if (!oldRow.hasSharedData(lockedRow)) {
                        oldRow = lockedRow;
                        this.targetTableFilter.set(oldRow);
                        if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                    }
                }
                if (!this.setClauseList.prepareUpdate(table, this.session, deltaChangeCollector, deltaChangeCollectionMode, rows, oldRow, this.onDuplicateKeyInsert != null)) continue;
                ++count;
            }
            Update.doUpdate(this, this.session, table, rows);
            table.fire(this.session, 2, false);
            long l = count;
            return l;
        }
    }

    static void doUpdate(Prepared prepared, SessionLocal session, Table table, LocalResult rows) {
        rows.done();
        table.updateRows(prepared, session, rows);
        if (table.fireRow()) {
            rows.reset();
            while (rows.next()) {
                Row o = rows.currentRowForTable();
                rows.next();
                Row n = rows.currentRowForTable();
                table.fireAfterRow(session, o, n, false);
            }
        }
    }

    @Override
    public String getPlanSQL(int sqlFlags) {
        StringBuilder builder = new StringBuilder("UPDATE ");
        this.targetTableFilter.getPlanSQL(builder, false, sqlFlags);
        if (this.fromTableFilter != null) {
            builder.append("\nFROM ");
            this.fromTableFilter.getPlanSQL(builder, false, sqlFlags);
        }
        this.setClauseList.getSQL(builder, sqlFlags);
        this.appendFilterCondition(builder, sqlFlags);
        return builder.toString();
    }

    @Override
    void doPrepare() {
        if (this.fromTableFilter != null) {
            this.targetTableFilter.addJoin(this.fromTableFilter, false, null);
        }
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            if (this.fromTableFilter != null) {
                this.condition.mapColumns(this.fromTableFilter, 0, 0);
            }
            this.condition = this.condition.optimizeCondition(this.session);
            if (this.condition != null) {
                this.condition.createIndexConditions(this.session, this.targetTableFilter);
            }
        }
        this.setClauseList.mapAndOptimize(this.session, this.targetTableFilter, this.fromTableFilter);
        TableFilter[] filters = null;
        filters = this.fromTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.fromTableFilter};
        PlanItem item = this.targetTableFilter.getBestPlanItem(this.session, filters, 0, new AllColumnsForPlan(filters));
        this.targetTableFilter.setPlanItem(item);
        this.targetTableFilter.prepare();
    }

    @Override
    public int getType() {
        return 68;
    }

    @Override
    public String getStatementName() {
        return "UPDATE";
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        if (this.condition != null) {
            this.condition.isEverything(visitor);
        }
        this.setClauseList.isEverything(visitor);
    }

    public Insert getOnDuplicateKeyInsert() {
        return this.onDuplicateKeyInsert;
    }

    void setOnDuplicateKeyInsert(Insert onDuplicateKeyInsert) {
        this.onDuplicateKeyInsert = onDuplicateKeyInsert;
    }
}

