/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.expression.ExpressionVisitor;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public class AllColumnsForPlan {
    private final TableFilter[] filters;
    private HashMap<Table, ArrayList<Column>> map;

    public AllColumnsForPlan(TableFilter[] filters) {
        this.filters = filters;
    }

    public void add(Column newCol) {
        ArrayList<Column> cols = this.map.get(newCol.getTable());
        if (cols == null) {
            cols = new ArrayList();
            this.map.put(newCol.getTable(), cols);
        }
        if (!cols.contains(newCol)) {
            cols.add(newCol);
        }
    }

    public ArrayList<Column> get(Table table) {
        if (this.map == null) {
            this.map = new HashMap();
            ExpressionVisitor.allColumnsForTableFilters(this.filters, this);
        }
        return this.map.get(table);
    }
}

