/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.command.query.Optimizer;
import org.h2.command.query.Query;
import org.h2.command.query.SelectGroups;
import org.h2.command.query.SelectListColumnResolver;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.Wildcard;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.Window;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.expression.condition.ConditionLocalAndGlobal;
import org.h2.expression.function.CoalesceFunction;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.QueryExpressionIndex;
import org.h2.message.DbException;
import org.h2.mode.DefaultNullOrdering;
import org.h2.result.LazyResult;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueRow;

public class Select
extends Query {
    TableFilter topTableFilter;
    private final ArrayList<TableFilter> filters = Utils.newSmallArrayList();
    private final ArrayList<TableFilter> topFilters = Utils.newSmallArrayList();
    private Select parentSelect;
    private Expression condition;
    private Expression having;
    private Expression qualify;
    private Expression[] distinctExpressions;
    private int[] distinctIndexes;
    private ArrayList<Expression> group;
    int[] groupIndex;
    boolean[] groupByExpression;
    SelectGroups groupData;
    private int havingIndex;
    private int qualifyIndex;
    private int[] groupByCopies;
    private boolean isExplicitTable;
    boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isWindowQuery;
    private boolean isForUpdate;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean sortUsingIndex;
    private boolean isGroupWindowStage2;
    private HashMap<String, Window> windows;

    public Select(SessionLocal session, Select parentSelect) {
        super(session);
        this.parentSelect = parentSelect;
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    public void addTableFilter(TableFilter filter, boolean isTop) {
        this.filters.add(filter);
        if (isTop) {
            this.topFilters.add(filter);
        }
    }

    public ArrayList<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ArrayList<Expression> expressions) {
        this.expressions = expressions;
    }

    public void setExplicitTable() {
        this.setWildcard();
        this.isExplicitTable = true;
    }

    public void setWildcard() {
        this.expressions = new ArrayList(1);
        this.expressions.add(new Wildcard(null, null));
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setWindowQuery() {
        this.isWindowQuery = true;
    }

    public void setGroupBy(ArrayList<Expression> group) {
        this.group = group;
    }

    public ArrayList<Expression> getGroupBy() {
        return this.group;
    }

    public SelectGroups getGroupDataIfCurrent(boolean window) {
        return this.groupData != null && (window || this.groupData.isCurrentGroup()) ? this.groupData : null;
    }

    public void setDistinct() {
        if (this.distinctExpressions != null) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinct = true;
    }

    public void setDistinct(Expression[] distinctExpressions) {
        if (this.distinct) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinctExpressions = distinctExpressions;
    }

    @Override
    public boolean isAnyDistinct() {
        return this.distinct || this.distinctExpressions != null;
    }

    public boolean addWindow(String name, Window window) {
        if (this.windows == null) {
            this.windows = new HashMap();
        }
        return this.windows.put(name, window) == null;
    }

    public Window getWindow(String name) {
        return this.windows != null ? this.windows.get(name) : null;
    }

    public void addCondition(Expression cond) {
        this.condition = this.condition == null ? cond : new ConditionAndOr(0, cond, this.condition);
    }

    public Expression getCondition() {
        return this.condition;
    }

    private LazyResult queryGroupSorted(int columnCount, ResultTarget result, long offset, boolean quickOffset) {
        LazyResultGroupSorted lazyResult = new LazyResultGroupSorted(this.expressionArray, columnCount);
        Select.skipOffset(lazyResult, offset, quickOffset);
        if (result == null) {
            return lazyResult;
        }
        while (lazyResult.next()) {
            result.addRow(lazyResult.currentRow());
        }
        return null;
    }

    Value[] createGroupSortedRow(Value[] keyValues, int columnCount) {
        Value[] row = this.constructGroupResultRow(keyValues, columnCount);
        if (this.isHavingNullOrFalse(row)) {
            return null;
        }
        return this.rowForResult(row, columnCount);
    }

    private Value[] rowForResult(Value[] row, int columnCount) {
        if (columnCount == this.resultColumnCount) {
            return row;
        }
        return Arrays.copyOf(row, this.resultColumnCount);
    }

    private boolean isHavingNullOrFalse(Value[] row) {
        return this.havingIndex >= 0 && !row[this.havingIndex].isTrue();
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ArrayList<Index> indexes = this.topTableFilter.getTable().getIndexes();
        if (indexes != null) {
            for (Index index : indexes) {
                if (index.getIndexType().isScan() || index.getIndexType().isHash() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
                return index;
            }
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        int i;
        Column[] indexColumns = index.getColumns();
        boolean[] grouped = new boolean[indexColumns.length];
        int size = this.expressions.size();
        block0: for (i = 0; i < size; ++i) {
            if (!this.groupByExpression[i]) continue;
            Expression expr = ((Expression)this.expressions.get(i)).getNonAliasExpression();
            if (!(expr instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn exprCol = (ExpressionColumn)expr;
            for (int j = 0; j < indexColumns.length; ++j) {
                if (tableFilter != exprCol.getTableFilter() || !indexColumns[j].equals(exprCol.getColumn())) continue;
                grouped[j] = true;
                continue block0;
            }
            return false;
        }
        for (i = 1; i < grouped.length; ++i) {
            if (grouped[i - 1] || !grouped[i]) continue;
            return false;
        }
        return true;
    }

    boolean isConditionMetForUpdate() {
        if (this.isConditionMet()) {
            int count = this.filters.size();
            boolean notChanged = true;
            for (int i = 0; i < count; ++i) {
                TableFilter tableFilter = this.filters.get(i);
                if (tableFilter.isJoinOuter() || tableFilter.isJoinOuterIndirect()) continue;
                Row row = tableFilter.get();
                Table table = tableFilter.getTable();
                if (!table.isRowLockable()) continue;
                Row lockedRow = table.lockRow(this.session, row);
                if (lockedRow == null) {
                    return false;
                }
                if (row.hasSharedData(lockedRow)) continue;
                tableFilter.set(lockedRow);
                notChanged = false;
            }
            return notChanged || this.isConditionMet();
        }
        return false;
    }

    boolean isConditionMet() {
        return this.condition == null || this.condition.getBooleanValue(this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryWindow(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 2);
            this.processGroupResult(columnCount, result, offset, quickOffset, false);
        }
        finally {
            this.groupData.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryGroupWindow(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 1);
            try {
                this.isGroupWindowStage2 = true;
                while (this.groupData.next() != null) {
                    if (this.havingIndex < 0 || ((Expression)this.expressions.get(this.havingIndex)).getBooleanValue(this.session)) {
                        this.updateAgg(columnCount, 2);
                        continue;
                    }
                    this.groupData.remove();
                }
                this.groupData.done();
                this.processGroupResult(columnCount, result, offset, quickOffset, false);
            }
            finally {
                this.isGroupWindowStage2 = false;
            }
        }
        finally {
            this.groupData.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryGroup(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 1);
            this.processGroupResult(columnCount, result, offset, quickOffset, true);
        }
        finally {
            this.groupData.reset();
        }
    }

    private void initGroupData(int columnCount) {
        if (this.groupData == null) {
            this.setGroupData(SelectGroups.getInstance(this.session, this.expressions, this.isGroupQuery, this.groupIndex));
        } else {
            this.updateAgg(columnCount, 0);
        }
        this.groupData.reset();
    }

    void setGroupData(SelectGroups groupData) {
        this.groupData = groupData;
        this.topTableFilter.visit(f -> {
            Select s = f.getSelect();
            if (s != null) {
                s.groupData = groupData;
            }
        });
    }

    private void gatherGroup(int columnCount, int stage) {
        long rowNumber = 0L;
        this.setCurrentRowNumber(0L);
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(rowNumber + 1L);
            if (!(this.isForUpdate ? this.isConditionMetForUpdate() : this.isConditionMet())) continue;
            ++rowNumber;
            this.groupData.nextSource();
            this.updateAgg(columnCount, stage);
        }
        this.groupData.done();
    }

    void updateAgg(int columnCount, int stage) {
        for (int i = 0; i < columnCount; ++i) {
            if (this.groupByExpression != null && this.groupByExpression[i] || this.groupByCopies != null && this.groupByCopies[i] >= 0) continue;
            Expression expr = (Expression)this.expressions.get(i);
            expr.updateAggregate(this.session, stage);
        }
    }

    private void processGroupResult(int columnCount, LocalResult result, long offset, boolean quickOffset, boolean withHaving) {
        ValueRow currentGroupsKey;
        while ((currentGroupsKey = this.groupData.next()) != null) {
            Value[] row = this.constructGroupResultRow(currentGroupsKey.getList(), columnCount);
            if (withHaving && this.isHavingNullOrFalse(row) || this.qualifyIndex >= 0 && !row[this.qualifyIndex].isTrue()) continue;
            if (quickOffset && offset > 0L) {
                --offset;
                continue;
            }
            result.addRow(this.rowForResult(row, columnCount));
        }
    }

    private Value[] constructGroupResultRow(Value[] keyValues, int columnCount) {
        int i;
        Value[] row = new Value[columnCount];
        if (this.groupIndex != null) {
            int l = this.groupIndex.length;
            for (i = 0; i < l; ++i) {
                row[this.groupIndex[i]] = keyValues[i];
            }
        }
        for (i = 0; i < columnCount; ++i) {
            int original;
            if (this.groupByExpression != null && this.groupByExpression[i]) continue;
            row[i] = this.groupByCopies != null && (original = this.groupByCopies[i]) >= 0 ? row[original] : ((Expression)this.expressions.get(i)).getValue(this.session);
        }
        return row;
    }

    private Index getSortIndex() {
        Index index;
        if (this.sort == null) {
            return null;
        }
        ArrayList<Column> sortColumns = Utils.newSmallArrayList();
        int[] queryColumnIndexes = this.sort.getQueryColumnIndexes();
        int queryIndexesLength = queryColumnIndexes.length;
        int[] sortIndex = new int[queryIndexesLength];
        int j = 0;
        for (int i = 0; i < queryIndexesLength; ++i) {
            int idx = queryColumnIndexes[i];
            if (idx < 0 || idx >= this.expressions.size()) {
                throw DbException.getInvalidValueException("ORDER BY", idx + 1);
            }
            Expression expr = (Expression)this.expressions.get(idx);
            if ((expr = expr.getNonAliasExpression()).isConstant()) continue;
            if (!(expr instanceof ExpressionColumn)) {
                return null;
            }
            ExpressionColumn exprCol = (ExpressionColumn)expr;
            if (exprCol.getTableFilter() != this.topTableFilter) {
                return null;
            }
            sortColumns.add(exprCol.getColumn());
            sortIndex[j++] = i;
        }
        Column[] sortCols = sortColumns.toArray(new Column[0]);
        if (sortCols.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ArrayList<Index> list = this.topTableFilter.getTable().getIndexes();
        if (list != null) {
            int[] sortTypes = this.sort.getSortTypesWithNullOrdering();
            DefaultNullOrdering defaultNullOrdering = this.session.getDatabase().getDefaultNullOrdering();
            block1: for (Index index2 : list) {
                IndexColumn[] indexCols;
                if (index2.getCreateSQL() == null || index2.getIndexType().isHash() || (indexCols = index2.getIndexColumns()).length < sortCols.length) continue;
                for (int j2 = 0; j2 < sortCols.length; ++j2) {
                    IndexColumn idxCol = indexCols[j2];
                    Column sortCol = sortCols[j2];
                    if (idxCol.column != sortCol) continue block1;
                    int sortType = sortTypes[sortIndex[j2]];
                    if (sortCol.isNullable() ? defaultNullOrdering.addExplicitNullOrdering(idxCol.sortType) != sortType : (idxCol.sortType & 1) != (sortType & 1)) continue block1;
                }
                return index2;
            }
        }
        if (sortCols.length == 1 && sortCols[0].getColumnId() == -1 && (index = this.topTableFilter.getTable().getScanIndex(this.session)).isRowIdIndex()) {
            return index;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void queryDistinct(ResultTarget result, long offset, long limitRows, boolean withTies, boolean quickOffset) {
        if (limitRows > 0L && offset > 0L && (limitRows += offset) < 0L) {
            limitRows = Long.MAX_VALUE;
        }
        long rowNumber = 0L;
        this.setCurrentRowNumber(0L);
        Index index = this.topTableFilter.getIndex();
        SearchRow first = null;
        int columnIndex = index.getColumns()[0].getColumnId();
        if (!quickOffset) {
            offset = 0L;
        }
        while (true) {
            this.setCurrentRowNumber(++rowNumber);
            Cursor cursor = index.findNext(this.session, first, null);
            if (!cursor.next()) return;
            SearchRow found = cursor.getSearchRow();
            Value value = found.getValue(columnIndex);
            if (first == null) {
                first = index.getRowFactory().createRow();
            }
            first.setValue(columnIndex, value);
            if (offset > 0L) {
                --offset;
                continue;
            }
            result.addRow(value);
            if ((this.sort == null || this.sortUsingIndex) && limitRows > 0L && rowNumber >= limitRows && !withTies) return;
        }
    }

    private LazyResult queryFlat(int columnCount, ResultTarget result, long offset, long limitRows, boolean withTies, boolean quickOffset) {
        if (limitRows > 0L && offset > 0L && !quickOffset && (limitRows += offset) < 0L) {
            limitRows = Long.MAX_VALUE;
        }
        LazyResultQueryFlat lazyResult = new LazyResultQueryFlat(this.expressionArray, columnCount, this.isForUpdate);
        Select.skipOffset(lazyResult, offset, quickOffset);
        if (result == null) {
            return lazyResult;
        }
        if (limitRows < 0L || this.sort != null && !this.sortUsingIndex || withTies && !quickOffset) {
            limitRows = Long.MAX_VALUE;
        }
        Value[] row = null;
        while (result.getRowCount() < limitRows && lazyResult.next()) {
            row = lazyResult.currentRow();
            result.addRow(row);
        }
        if (limitRows != Long.MAX_VALUE && withTies && this.sort != null && row != null) {
            Value[] expected = row;
            while (lazyResult.next() && this.sort.compare(expected, row = lazyResult.currentRow()) == 0) {
                result.addRow(row);
            }
            result.limitsWereApplied();
        }
        return null;
    }

    private static void skipOffset(LazyResultSelect lazyResult, long offset, boolean quickOffset) {
        if (quickOffset) {
            while (offset > 0L && lazyResult.skip()) {
                --offset;
            }
        }
    }

    private void queryQuick(int columnCount, ResultTarget result, boolean skipResult) {
        Value[] row = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Expression expr = (Expression)this.expressions.get(i);
            row[i] = expr.getValue(this.session);
        }
        if (!skipResult) {
            result.addRow(row);
        }
    }

    @Override
    protected ResultInterface queryWithoutCache(long maxRows, ResultTarget target) {
        boolean quickOffset;
        this.disableLazyForJoinSubqueries(this.topTableFilter);
        Query.OffsetFetch offsetFetch = this.getOffsetFetch(maxRows);
        long offset = offsetFetch.offset;
        long fetch = offsetFetch.fetch;
        boolean fetchPercent = offsetFetch.fetchPercent;
        boolean lazy = this.session.isLazyQueryExecution() && target == null && !this.isForUpdate && !this.isQuickAggregateQuery && fetch != 0L && !fetchPercent && !this.withTies && offset == 0L && this.isReadOnly();
        int columnCount = this.expressions.size();
        LocalResult result = null;
        if (!(lazy || target != null && this.session.getDatabase().getSettings().optimizeInsertFromSelect)) {
            result = this.createLocalResult(result);
        }
        boolean bl = quickOffset = !fetchPercent;
        if (this.sort != null && (!this.sortUsingIndex || this.isAnyDistinct())) {
            result = this.createLocalResult(result);
            result.setSortOrder(this.sort);
            if (!this.sortUsingIndex) {
                quickOffset = false;
            }
        }
        if (this.distinct) {
            if (!this.isDistinctQuery) {
                quickOffset = false;
                result = this.createLocalResult(result);
                result.setDistinct();
            }
        } else if (this.distinctExpressions != null) {
            quickOffset = false;
            result = this.createLocalResult(result);
            result.setDistinct(this.distinctIndexes);
        }
        if (this.isWindowQuery || this.isGroupQuery && !this.isGroupSortedQuery) {
            result = this.createLocalResult(result);
        }
        if (!(lazy || fetch < 0L && offset <= 0L)) {
            result = this.createLocalResult(result);
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        this.topTableFilter.lock(this.session);
        ResultTarget to = result != null ? result : target;
        lazy &= to == null;
        LazyResult lazyResult = null;
        if (fetch != 0L) {
            long limit;
            long l = limit = fetchPercent ? -1L : fetch;
            if (this.isQuickAggregateQuery) {
                this.queryQuick(columnCount, to, quickOffset && offset > 0L);
            } else if (this.isWindowQuery) {
                if (this.isGroupQuery) {
                    this.queryGroupWindow(columnCount, result, offset, quickOffset);
                } else {
                    this.queryWindow(columnCount, result, offset, quickOffset);
                }
            } else if (this.isGroupQuery) {
                if (this.isGroupSortedQuery) {
                    lazyResult = this.queryGroupSorted(columnCount, to, offset, quickOffset);
                } else {
                    this.queryGroup(columnCount, result, offset, quickOffset);
                }
            } else if (this.isDistinctQuery) {
                this.queryDistinct(to, offset, limit, this.withTies, quickOffset);
            } else {
                lazyResult = this.queryFlat(columnCount, to, offset, limit, this.withTies, quickOffset);
            }
            if (quickOffset) {
                offset = 0L;
            }
        }
        assert (lazy == (lazyResult != null)) : lazy;
        if (lazyResult != null) {
            if (fetch > 0L) {
                lazyResult.setLimit(fetch);
            }
            if (this.randomAccessResult) {
                return this.convertToDistinct(lazyResult);
            }
            return lazyResult;
        }
        if (result != null) {
            return this.finishResult(result, offset, fetch, fetchPercent, target);
        }
        return null;
    }

    private void disableLazyForJoinSubqueries(TableFilter top) {
        if (this.session.isLazyQueryExecution()) {
            top.visit(f -> {
                QueryExpressionIndex idx;
                if (f != top && f.getTable().getTableType() == TableType.VIEW && (idx = (QueryExpressionIndex)f.getIndex()) != null && idx.getQuery() != null) {
                    idx.getQuery().setNeverLazy(true);
                }
            });
        }
    }

    private LocalResult createLocalResult(LocalResult old) {
        return old != null ? old : new LocalResult(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
    }

    private void expandColumnList() {
        int i = 0;
        while (i < this.expressions.size()) {
            Expression expr = (Expression)this.expressions.get(i);
            if (!(expr instanceof Wildcard)) {
                ++i;
                continue;
            }
            this.expressions.remove(i);
            Wildcard w = (Wildcard)expr;
            String tableAlias = w.getTableAlias();
            boolean hasExceptColumns = w.getExceptColumns() != null;
            HashMap<Column, ExpressionColumn> exceptTableColumns = null;
            if (tableAlias == null) {
                if (hasExceptColumns) {
                    for (TableFilter filter : this.filters) {
                        w.mapColumns(filter, 1, 0);
                    }
                    exceptTableColumns = w.mapExceptColumns();
                }
                for (TableFilter filter : this.filters) {
                    i = this.expandColumnList(filter, i, false, exceptTableColumns);
                }
                continue;
            }
            Database db = this.session.getDatabase();
            String schemaName = w.getSchemaName();
            TableFilter filter = null;
            for (TableFilter f : this.filters) {
                if (!db.equalsIdentifiers(tableAlias, f.getTableAlias()) || schemaName != null && !db.equalsIdentifiers(schemaName, f.getSchemaName())) continue;
                if (hasExceptColumns) {
                    w.mapColumns(f, 1, 0);
                    exceptTableColumns = w.mapExceptColumns();
                }
                filter = f;
                break;
            }
            if (filter == null) {
                throw DbException.get(42102, tableAlias);
            }
            i = this.expandColumnList(filter, i, true, exceptTableColumns);
        }
    }

    private int expandColumnList(TableFilter filter, int index, boolean forAlias, HashMap<Column, ExpressionColumn> except) {
        String schema = filter.getSchemaName();
        String alias = filter.getTableAlias();
        if (forAlias) {
            for (Column c : filter.getTable().getColumns()) {
                index = this.addExpandedColumn(filter, index, except, schema, alias, c);
            }
        } else {
            LinkedHashMap<Column, Column> commonJoinColumns = filter.getCommonJoinColumns();
            if (commonJoinColumns != null) {
                TableFilter replacementFilter = filter.getCommonJoinColumnsFilter();
                String replacementSchema = replacementFilter.getSchemaName();
                String replacementAlias = replacementFilter.getTableAlias();
                for (Map.Entry<Column, Column> entry : commonJoinColumns.entrySet()) {
                    Column left = entry.getKey();
                    Column right = entry.getValue();
                    if (filter.isCommonJoinColumnToExclude(right) || except != null && (except.remove(left) != null || except.remove(right) != null)) continue;
                    Database database = this.session.getDatabase();
                    Expression e = left == right || DataType.hasTotalOrdering(left.getType().getValueType()) && DataType.hasTotalOrdering(right.getType().getValueType()) ? new ExpressionColumn(database, replacementSchema, replacementAlias, replacementFilter.getColumnName(right)) : new Alias(new CoalesceFunction(0, new ExpressionColumn(database, schema, alias, filter.getColumnName(left)), new ExpressionColumn(database, replacementSchema, replacementAlias, replacementFilter.getColumnName(right))), left.getName(), true);
                    this.expressions.add(index++, e);
                }
            }
            for (Column c : filter.getTable().getColumns()) {
                if (commonJoinColumns != null && commonJoinColumns.containsKey(c) || filter.isCommonJoinColumnToExclude(c)) continue;
                index = this.addExpandedColumn(filter, index, except, schema, alias, c);
            }
        }
        return index;
    }

    private int addExpandedColumn(TableFilter filter, int index, HashMap<Column, ExpressionColumn> except, String schema, String alias, Column c) {
        if ((except == null || except.remove(c) == null) && c.getVisible()) {
            ExpressionColumn ec = new ExpressionColumn(this.session.getDatabase(), schema, alias, filter.getColumnName(c));
            this.expressions.add(index++, ec);
        }
        return index;
    }

    @Override
    public void init() {
        ArrayList<String> expressionSQL;
        if (this.checkInit) {
            throw DbException.getInternalError();
        }
        this.filters.sort(TableFilter.ORDER_IN_FROM_COMPARATOR);
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.visibleColumnCount > 16384) {
            throw DbException.get(54011, "16384");
        }
        if (this.distinctExpressions != null || this.orderList != null || this.group != null) {
            expressionSQL = new ArrayList<String>(this.visibleColumnCount);
            for (int i = 0; i < this.visibleColumnCount; ++i) {
                Object expr = (Expression)this.expressions.get(i);
                expr = ((Expression)expr).getNonAliasExpression();
                expressionSQL.add(((Expression)expr).getSQL(0, 2));
            }
        } else {
            expressionSQL = null;
        }
        if (this.distinctExpressions != null) {
            BitSet set = new BitSet();
            for (Expression e : this.distinctExpressions) {
                set.set(this.initExpression(expressionSQL, e, false, this.filters));
            }
            int idx = 0;
            int cnt = set.cardinality();
            this.distinctIndexes = new int[cnt];
            for (int i = 0; i < cnt; ++i) {
                idx = set.nextSetBit(idx);
                this.distinctIndexes[i] = idx++;
            }
        }
        if (this.orderList != null) {
            this.initOrder(expressionSQL, this.isAnyDistinct(), this.filters);
        }
        this.resultColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.qualify != null) {
            this.expressions.add(this.qualify);
            this.qualifyIndex = this.expressions.size() - 1;
            this.qualify = null;
        } else {
            this.qualifyIndex = -1;
        }
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
        Database db = this.session.getDatabase();
        if (this.group != null) {
            block28: {
                int size = this.group.size();
                int expSize = expressionSQL.size();
                int fullExpSize = this.expressions.size();
                if (fullExpSize > expSize) {
                    expressionSQL.ensureCapacity(fullExpSize);
                    for (int i = expSize; i < fullExpSize; ++i) {
                        expressionSQL.add(((Expression)this.expressions.get(i)).getSQL(0, 2));
                    }
                }
                this.groupIndex = new int[size];
                for (int i = 0; i < size; ++i) {
                    int j;
                    Expression expr = this.group.get(i);
                    String sql = expr.getSQL(0, 2);
                    int found = -1;
                    for (j = 0; j < expSize; ++j) {
                        String s2 = expressionSQL.get(j);
                        if (!db.equalsIdentifiers(s2, sql)) continue;
                        found = this.mergeGroupByExpressions(db, j, expressionSQL, false);
                        break;
                    }
                    if (found < 0) {
                        for (j = 0; j < expSize; ++j) {
                            Expression e = (Expression)this.expressions.get(j);
                            if (db.equalsIdentifiers(sql, e.getAlias(this.session, j))) {
                                found = this.mergeGroupByExpressions(db, j, expressionSQL, true);
                                break;
                            }
                            sql = expr.getAlias(this.session, j);
                            if (!db.equalsIdentifiers(sql, e.getAlias(this.session, j))) continue;
                            found = this.mergeGroupByExpressions(db, j, expressionSQL, true);
                            break;
                        }
                    }
                    if (found < 0) {
                        int index;
                        this.groupIndex[i] = index = this.expressions.size();
                        this.expressions.add(expr);
                        continue;
                    }
                    this.groupIndex[i] = found;
                }
                if (this.groupByCopies != null) {
                    for (int i : this.groupByCopies) {
                        if (i < 0) {
                            continue;
                        }
                        break block28;
                    }
                    this.groupByCopies = null;
                }
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (int gi : this.groupIndex) {
                this.groupByExpression[gi] = true;
            }
            this.group = null;
        }
        for (TableFilter f : this.filters) {
            this.mapColumns(f, 0);
        }
        this.mapCondition(this.havingIndex);
        this.mapCondition(this.qualifyIndex);
        this.checkInit = true;
    }

    private void mapCondition(int index) {
        if (index >= 0) {
            Expression expr = (Expression)this.expressions.get(index);
            SelectListColumnResolver res = new SelectListColumnResolver(this);
            expr.mapColumns(res, 0, 0);
        }
    }

    private int mergeGroupByExpressions(Database db, int index, ArrayList<String> expressionSQL, boolean scanPrevious) {
        if (this.groupByCopies != null) {
            int c = this.groupByCopies[index];
            if (c >= 0) {
                return c;
            }
            if (c == -2) {
                return index;
            }
        } else {
            this.groupByCopies = new int[expressionSQL.size()];
            Arrays.fill(this.groupByCopies, -1);
        }
        String sql = expressionSQL.get(index);
        if (scanPrevious) {
            for (int i = 0; i < index; ++i) {
                if (!db.equalsIdentifiers(sql, expressionSQL.get(i))) continue;
                index = i;
                break;
            }
        }
        int l = expressionSQL.size();
        for (int i = index + 1; i < l; ++i) {
            if (!db.equalsIdentifiers(sql, expressionSQL.get(i))) continue;
            this.groupByCopies[i] = index;
        }
        this.groupByCopies[index] = -2;
        return index;
    }

    @Override
    public void prepareExpressions() {
        Mode.ExpressionNames expressionNames;
        if (this.orderList != null) {
            this.prepareOrder(this.orderList, this.expressions.size());
        }
        if ((expressionNames = this.session.getMode().expressionNames) == Mode.ExpressionNames.ORIGINAL_SQL || expressionNames == Mode.ExpressionNames.POSTGRESQL_STYLE) {
            this.optimizeExpressionsAndPreserveAliases();
        } else {
            for (int i = 0; i < this.expressions.size(); ++i) {
                this.expressions.set(i, ((Expression)this.expressions.get(i)).optimize(this.session));
            }
        }
        if (this.sort != null) {
            this.cleanupOrder();
        }
        if (this.condition != null) {
            this.condition = this.condition.optimizeCondition(this.session);
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.qualifyIndex < 0 && this.condition == null && this.filters.size() == 1) {
            this.isQuickAggregateQuery = this.isEverything(ExpressionVisitor.getOptimizableVisitor(this.filters.get(0).getTable()));
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
    }

    @Override
    public void preparePlan() {
        Index current;
        Index index;
        if (this.condition != null) {
            for (TableFilter f : this.filters) {
                if (f.isJoinOuter() || f.isJoinOuterIndirect()) continue;
                this.condition.createIndexConditions(this.session, f);
            }
        }
        this.cost = this.preparePlan(this.session.isParsingCreateView());
        if (this.distinct && this.session.getDatabase().getSettings().optimizeDistinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expr = (Expression)this.expressions.get(0);
            if ((expr = expr.getNonAliasExpression()) instanceof ExpressionColumn) {
                Index current2;
                Column column = ((ExpressionColumn)expr).getColumn();
                int selectivity = column.getSelectivity();
                Index columnIndex = this.topTableFilter.getTable().getIndexForColumn(column, false, true);
                if (columnIndex != null && selectivity != 50 && selectivity < 20 && ((current2 = this.topTableFilter.getIndex()) == null || current2.getIndexType().isScan() || columnIndex == current2)) {
                    this.topTableFilter.setIndex(columnIndex);
                    this.isDistinctQuery = true;
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery) {
            index = this.getSortIndex();
            current = this.topTableFilter.getIndex();
            if (index != null && current != null) {
                if (current.getIndexType().isScan() || current == index) {
                    this.topTableFilter.setIndex(index);
                    if (!this.topTableFilter.hasInComparisons()) {
                        this.sortUsingIndex = true;
                    }
                } else if (index.getIndexColumns() != null && index.getIndexColumns().length >= current.getIndexColumns().length) {
                    IndexColumn[] sortColumns = index.getIndexColumns();
                    IndexColumn[] currentColumns = current.getIndexColumns();
                    boolean swapIndex = false;
                    for (int i = 0; i < currentColumns.length; ++i) {
                        if (sortColumns[i].column != currentColumns[i].column) {
                            swapIndex = false;
                            break;
                        }
                        if (sortColumns[i].sortType == currentColumns[i].sortType) continue;
                        swapIndex = true;
                    }
                    if (swapIndex) {
                        this.topTableFilter.setIndex(index);
                        this.sortUsingIndex = true;
                    }
                }
            }
            if (this.sortUsingIndex && this.isForUpdate && !this.topTableFilter.getIndex().isRowIdIndex()) {
                this.sortUsingIndex = false;
            }
        }
        if (!this.isQuickAggregateQuery && this.isGroupQuery && (index = this.getGroupSortedIndex()) != null && (current = this.topTableFilter.getIndex()) != null && (current.getIndexType().isScan() || current == index)) {
            this.topTableFilter.setIndex(index);
            this.isGroupSortedQuery = true;
        }
        this.isPrepared = true;
    }

    private void optimizeExpressionsAndPreserveAliases() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression optimized;
            Expression original = (Expression)this.expressions.get(i);
            if (i < this.visibleColumnCount) {
                String alias = original.getAlias(this.session, i);
                optimized = original.optimize(this.session);
                if (!optimized.getAlias(this.session, i).equals(alias)) {
                    optimized = new Alias(optimized, alias, true);
                }
            } else {
                optimized = original.optimize(this.session);
            }
            this.expressions.set(i, optimized);
        }
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> set = new HashSet<Table>();
        for (TableFilter filter : this.filters) {
            set.add(filter.getTable());
        }
        return set;
    }

    @Override
    public void fireBeforeSelectTriggers() {
        for (TableFilter filter : this.filters) {
            filter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan(boolean parse) {
        TableFilter[] topArray;
        for (TableFilter t : topArray = this.topFilters.toArray(new TableFilter[0])) {
            t.createIndexConditions();
            t.setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer(topArray, this.condition, this.session);
        optimizer.optimize(parse);
        this.topTableFilter = optimizer.getTopFilter();
        double planCost = optimizer.getCost();
        this.setEvaluatableRecursive(this.topTableFilter);
        if (!parse) {
            this.topTableFilter.prepare();
        }
        return planCost;
    }

    private void setEvaluatableRecursive(TableFilter f) {
        while (f != null) {
            Expression on;
            TableFilter n;
            f.setEvaluatable(f, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(f, true);
            }
            if ((n = f.getNestedJoin()) != null) {
                this.setEvaluatableRecursive(n);
            }
            if ((on = f.getJoinCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                on = on.optimize(this.session);
                if (!f.isJoinOuter() && !f.isJoinOuterIndirect()) {
                    f.removeJoinCondition();
                    this.addCondition(on);
                }
            }
            if ((on = f.getFilterCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                f.removeFilterCondition();
                this.addCondition(on);
            }
            for (Expression e : this.expressions) {
                e.setEvaluatable(f, true);
            }
            f = f.getJoin();
        }
    }

    @Override
    public String getPlanSQL(int sqlFlags) {
        Expression[] exprList = this.expressions.toArray(new Expression[0]);
        StringBuilder builder = new StringBuilder();
        for (TableFilter f : this.topFilters) {
            Table t = f.getTable();
            TableView tableView = t instanceof TableView ? (TableView)t : null;
            if (tableView == null || !tableView.isRecursive() || !tableView.isTableExpression() || !tableView.isTemporary()) continue;
            builder.append("WITH RECURSIVE ");
            t.getSchema().getSQL(builder, sqlFlags).append('.');
            ParserUtil.quoteIdentifier(builder, t.getName(), sqlFlags).append('(');
            Column.writeColumns(builder, t.getColumns(), sqlFlags);
            builder.append(") AS ");
            t.getSQL(builder, sqlFlags).append('\n');
        }
        if (this.isExplicitTable) {
            builder.append("TABLE ");
            this.filters.get(0).getPlanSQL(builder, false, sqlFlags);
        } else {
            block30: {
                builder.append("SELECT");
                if (this.isAnyDistinct()) {
                    builder.append(" DISTINCT");
                    if (this.distinctExpressions != null) {
                        Expression.writeExpressions(builder.append(" ON("), this.distinctExpressions, sqlFlags).append(')');
                    }
                }
                for (int i = 0; i < this.visibleColumnCount; ++i) {
                    if (i > 0) {
                        builder.append(',');
                    }
                    builder.append('\n');
                    StringUtils.indent(builder, exprList[i].getSQL(sqlFlags, 2), 4, false);
                }
                TableFilter filter = this.topTableFilter;
                if (filter == null) {
                    int count = this.topFilters.size();
                    if (count != 1 || !this.topFilters.get(0).isNoFromClauseFilter()) {
                        builder.append("\nFROM ");
                        boolean isJoin = false;
                        for (int i = 0; i < count; ++i) {
                            isJoin = Select.getPlanFromFilter(builder, sqlFlags, this.topFilters.get(i), isJoin);
                        }
                    }
                } else if (!filter.isNoFromClauseFilter()) {
                    Select.getPlanFromFilter(builder.append("\nFROM "), sqlFlags, filter, false);
                }
                if (this.condition != null) {
                    Select.getFilterSQL(builder, "\nWHERE ", this.condition, sqlFlags);
                }
                if (this.groupIndex != null) {
                    builder.append("\nGROUP BY ");
                    int l = this.groupIndex.length;
                    for (int i = 0; i < l; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        exprList[this.groupIndex[i]].getNonAliasExpression().getUnenclosedSQL(builder, sqlFlags);
                    }
                } else if (this.group != null) {
                    builder.append("\nGROUP BY ");
                    int l = this.group.size();
                    for (int i = 0; i < l; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        this.group.get(i).getUnenclosedSQL(builder, sqlFlags);
                    }
                } else if (this.isGroupQuery && this.having == null && this.havingIndex < 0) {
                    for (int i = 0; i < this.visibleColumnCount; ++i) {
                        if (!Select.containsAggregate(exprList[i])) {
                            continue;
                        }
                        break block30;
                    }
                    builder.append("\nGROUP BY ()");
                }
            }
            Select.getFilterSQL(builder, "\nHAVING ", exprList, this.having, this.havingIndex, sqlFlags);
            Select.getFilterSQL(builder, "\nQUALIFY ", exprList, this.qualify, this.qualifyIndex, sqlFlags);
        }
        this.appendEndOfQueryToSQL(builder, sqlFlags, exprList);
        if (this.isForUpdate) {
            builder.append("\nFOR UPDATE");
        }
        if ((sqlFlags & 8) != 0) {
            if (this.isQuickAggregateQuery) {
                builder.append("\n/* direct lookup */");
            }
            if (this.isDistinctQuery) {
                builder.append("\n/* distinct */");
            }
            if (this.sortUsingIndex) {
                builder.append("\n/* index sorted */");
            }
            if (this.isGroupQuery && this.isGroupSortedQuery) {
                builder.append("\n/* group sorted */");
            }
        }
        return builder.toString();
    }

    private static boolean getPlanFromFilter(StringBuilder builder, int sqlFlags, TableFilter f, boolean isJoin) {
        do {
            if (isJoin) {
                builder.append('\n');
            }
            f.getPlanSQL(builder, isJoin, sqlFlags);
            isJoin = true;
        } while ((f = f.getJoin()) != null);
        return isJoin;
    }

    private static void getFilterSQL(StringBuilder builder, String sql, Expression[] exprList, Expression condition, int conditionIndex, int sqlFlags) {
        if (condition != null) {
            Select.getFilterSQL(builder, sql, condition, sqlFlags);
        } else if (conditionIndex >= 0) {
            Select.getFilterSQL(builder, sql, exprList[conditionIndex], sqlFlags);
        }
    }

    private static void getFilterSQL(StringBuilder builder, String sql, Expression condition, int sqlFlags) {
        condition.getNonAliasExpression().getUnenclosedSQL(builder.append(sql), sqlFlags);
    }

    private static boolean containsAggregate(Expression expression) {
        if (expression instanceof DataAnalysisOperation && ((DataAnalysisOperation)expression).isAggregate()) {
            return true;
        }
        int l = expression.getSubexpressionCount();
        for (int i = 0; i < l; ++i) {
            if (!Select.containsAggregate(expression.getSubexpression(i))) continue;
            return true;
        }
        return false;
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setQualify(Expression qualify) {
        this.qualify = qualify;
    }

    public Expression getQualify() {
        return this.qualify;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public void setForUpdate(boolean b) {
        if (b && (this.isAnyDistinct() || this.isGroupQuery)) {
            throw DbException.get(90145);
        }
        this.isForUpdate = b;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression e : this.expressions) {
            e.mapColumns(resolver, level, 0);
        }
        if (this.condition != null) {
            this.condition.mapColumns(resolver, level, 0);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.expressions) {
            e.setEvaluatable(tableFilter, b);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, b);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    public boolean isGroupQuery() {
        return this.isGroupQuery;
    }

    public boolean isWindowQuery() {
        return this.isWindowQuery;
    }

    public boolean isGroupWindowStage2() {
        return this.isGroupWindowStage2;
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
        this.addParameter(param);
        Expression col = (Expression)this.expressions.get(columnId);
        col = col.getNonAliasExpression();
        Expression comp = col.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR) ? new Comparison(comparisonType, col, param, false) : new Comparison(6, param, param, false);
        comp = ((Expression)comp).optimize(this.session);
        if (this.isWindowQuery) {
            this.qualify = Select.addGlobalCondition(this.qualify, comp);
        } else if (this.isGroupQuery) {
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != columnId) continue;
                this.condition = Select.addGlobalCondition(this.condition, comp);
                return;
            }
            if (this.havingIndex >= 0) {
                this.having = (Expression)this.expressions.get(this.havingIndex);
            }
            this.having = Select.addGlobalCondition(this.having, comp);
        } else {
            this.condition = Select.addGlobalCondition(this.condition, comp);
        }
    }

    private static Expression addGlobalCondition(Expression condition, Expression additional) {
        Expression oldGlobal;
        Expression oldLocal;
        if (!(condition instanceof ConditionLocalAndGlobal)) {
            return new ConditionLocalAndGlobal(condition, additional);
        }
        if (condition.getSubexpressionCount() == 1) {
            oldLocal = null;
            oldGlobal = condition.getSubexpression(0);
        } else {
            oldLocal = condition.getSubexpression(0);
            oldGlobal = condition.getSubexpression(1);
        }
        return new ConditionLocalAndGlobal(oldLocal, new ConditionAndOr(0, oldGlobal, additional));
    }

    @Override
    public void updateAggregate(SessionLocal s, int stage) {
        for (Expression e : this.expressions) {
            e.updateAggregate(s, stage);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(s, stage);
        }
        if (this.having != null) {
            this.having.updateAggregate(s, stage);
        }
        if (this.qualify != null) {
            this.qualify.updateAggregate(s, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                if (this.isForUpdate) {
                    return false;
                }
                for (TableFilter f : this.filters) {
                    if (f.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                for (TableFilter f : this.filters) {
                    long m = f.getTable().getMaxDataModificationId();
                    visitor.addDataModificationId(m);
                }
                break;
            }
            case 3: {
                if (this.session.getDatabase().getSettings().optimizeEvaluatableSubqueries) break;
                return false;
            }
            case 7: {
                for (TableFilter f : this.filters) {
                    Table table = f.getTable();
                    visitor.addDependency(table);
                    table.addDependencies(visitor.getDependencies());
                }
                break;
            }
        }
        ExpressionVisitor v2 = visitor.incrementQueryLevel(1);
        for (Expression e : this.expressions) {
            if (e.isEverything(v2)) continue;
            return false;
        }
        if (this.condition != null && !this.condition.isEverything(v2)) {
            return false;
        }
        if (this.having != null && !this.having.isEverything(v2)) {
            return false;
        }
        return this.qualify == null || this.qualify.isEverything(v2);
    }

    @Override
    public boolean isCacheable() {
        return !this.isForUpdate;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.offsetExpr == null && this.fetchExpr == null && this.distinctExpressions == null;
    }

    public SortOrder getSortOrder() {
        return this.sort;
    }

    public Select getParentSelect() {
        return this.parentSelect;
    }

    @Override
    public boolean isConstantQuery() {
        if (!super.isConstantQuery() || this.distinctExpressions != null || this.condition != null || this.isGroupQuery || this.isWindowQuery || !this.isNoFromClause()) {
            return false;
        }
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (((Expression)this.expressions.get(i)).isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression getIfSingleRow() {
        if (this.offsetExpr != null || this.fetchExpr != null || this.condition != null || this.isGroupQuery || this.isWindowQuery || !this.isNoFromClause()) {
            return null;
        }
        if (this.visibleColumnCount == 1) {
            return (Expression)this.expressions.get(0);
        }
        Expression[] array = new Expression[this.visibleColumnCount];
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            array[i] = (Expression)this.expressions.get(i);
        }
        return new ExpressionList(array, false);
    }

    private boolean isNoFromClause() {
        if (this.topTableFilter != null) {
            return this.topTableFilter.isNoFromClauseFilter();
        }
        if (this.topFilters.size() == 1) {
            return this.topFilters.get(0).isNoFromClauseFilter();
        }
        return false;
    }

    private final class LazyResultGroupSorted
    extends LazyResultSelect {
        private Value[] previousKeyValues;

        LazyResultGroupSorted(Expression[] expressions, int columnCount) {
            super(expressions, columnCount);
            if (Select.this.groupData == null) {
                Select.this.setGroupData(SelectGroups.getInstance(Select.this.getSession(), Select.this.expressions, Select.this.isGroupQuery, Select.this.groupIndex));
            } else {
                Select.this.updateAgg(columnCount, 0);
                Select.this.groupData.resetLazy();
            }
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.groupData.resetLazy();
            this.previousKeyValues = null;
        }

        @Override
        protected Value[] fetchNextRow() {
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                int groupSize = Select.this.groupIndex.length;
                Value[] keyValues = new Value[groupSize];
                for (int i = 0; i < groupSize; ++i) {
                    int idx = Select.this.groupIndex[i];
                    Expression expr = (Expression)Select.this.expressions.get(idx);
                    keyValues[i] = expr.getValue(Select.this.getSession());
                }
                Value[] row = null;
                if (this.previousKeyValues == null) {
                    this.previousKeyValues = keyValues;
                    Select.this.groupData.nextLazyGroup();
                } else {
                    SessionLocal session = Select.this.getSession();
                    for (int i = 0; i < groupSize; ++i) {
                        if (session.compare(this.previousKeyValues[i], keyValues[i]) == 0) continue;
                        row = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                        this.previousKeyValues = keyValues;
                        Select.this.groupData.nextLazyGroup();
                        break;
                    }
                }
                Select.this.groupData.nextLazyRow();
                Select.this.updateAgg(this.columnCount, 1);
                if (row == null) continue;
                return row;
            }
            Value[] row = null;
            if (this.previousKeyValues != null) {
                row = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                this.previousKeyValues = null;
            }
            return row;
        }
    }

    private final class LazyResultQueryFlat
    extends LazyResultSelect {
        private boolean forUpdate;

        LazyResultQueryFlat(Expression[] expressions, int columnCount, boolean forUpdate) {
            super(expressions, columnCount);
            this.forUpdate = forUpdate;
        }

        @Override
        protected Value[] fetchNextRow() {
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!(this.forUpdate ? Select.this.isConditionMetForUpdate() : Select.this.isConditionMet())) continue;
                ++this.rowNumber;
                Value[] row = new Value[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    Expression expr = (Expression)Select.this.expressions.get(i);
                    row[i] = expr.getValue(Select.this.getSession());
                }
                return row;
            }
            return null;
        }

        @Override
        protected boolean skipNextRow() {
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                return true;
            }
            return false;
        }
    }

    private abstract class LazyResultSelect
    extends LazyResult {
        long rowNumber;
        int columnCount;

        LazyResultSelect(Expression[] expressions, int columnCount) {
            super(Select.this.getSession(), expressions);
            this.columnCount = columnCount;
            Select.this.setCurrentRowNumber(0L);
        }

        @Override
        public final int getVisibleColumnCount() {
            return Select.this.visibleColumnCount;
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.topTableFilter.reset();
            Select.this.setCurrentRowNumber(0L);
            this.rowNumber = 0L;
        }
    }
}

