/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.util.HashSet;
import org.h2.command.Parser;
import org.h2.command.ddl.AlterDomain;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.constraint.Constraint;
import org.h2.constraint.DomainColumnResolver;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConstraintDomain
extends Constraint {
    private Domain domain;
    private Expression expr;
    private DomainColumnResolver resolver;

    public ConstraintDomain(Schema schema, int id, String name, Domain domain) {
        super(schema, id, name, null);
        this.domain = domain;
        this.resolver = new DomainColumnResolver(domain.getDataType());
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.DOMAIN;
    }

    public Domain getDomain() {
        return this.domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpression(SessionLocal session, Expression expr) {
        expr.mapColumns(this.resolver, 0, 0);
        expr = expr.optimize(session);
        ConstraintDomain constraintDomain = this;
        synchronized (constraintDomain) {
            this.resolver.setValue(ValueNull.INSTANCE);
            expr.getValue(session);
        }
        this.expr = expr;
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder builder = new StringBuilder("ALTER DOMAIN ");
        this.domain.getSQL(builder, 0).append(" ADD CONSTRAINT ");
        this.getSQL(builder, 0);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        builder.append(" CHECK");
        this.expr.getEnclosedSQL(builder, 0).append(" NOCHECK");
        return builder.toString();
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.domain.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.domain = null;
        this.expr = null;
        this.invalidate();
    }

    @Override
    public void checkRow(SessionLocal session, Table t, Row oldRow, Row newRow) {
        throw DbException.getInternalError(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(SessionLocal session, Value value) {
        Value v;
        ConstraintDomain constraintDomain = this;
        synchronized (constraintDomain) {
            this.resolver.setValue(value);
            v = this.expr.getValue(session);
        }
        if (v.isFalse()) {
            throw DbException.get(23513, this.expr.getTraceSQL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(SessionLocal session, String columnName) {
        String sql;
        if (columnName != null) {
            String sql2;
            ConstraintDomain constraintDomain = this;
            synchronized (constraintDomain) {
                try {
                    this.resolver.setColumnName(columnName);
                    sql2 = this.expr.getSQL(0);
                }
                finally {
                    this.resolver.resetColumnName();
                }
            }
            return new Parser(session).parseExpression(sql2);
        }
        ConstraintDomain constraintDomain = this;
        synchronized (constraintDomain) {
            sql = this.expr.getSQL(0);
        }
        return new Parser(session).parseDomainConstraintExpression(sql);
    }

    @Override
    public boolean usesIndex(Index index) {
        return false;
    }

    @Override
    public void setIndexOwner(Index index) {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> columns = new HashSet<Column>();
        this.expr.isEverything(ExpressionVisitor.getColumnsVisitor(columns, table));
        return columns;
    }

    @Override
    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(SessionLocal session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        new CheckExistingData(session, this.domain);
    }

    @Override
    public void rebuild() {
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.expr.isEverything(visitor);
    }

    private class CheckExistingData {
        private final SessionLocal session;

        CheckExistingData(SessionLocal session, Domain domain) {
            this.session = session;
            this.checkDomain(null, domain);
        }

        private boolean checkColumn(Domain domain, Column targetColumn) {
            Table table = targetColumn.getTable();
            TableFilter filter = new TableFilter(this.session, table, null, true, null, 0, null);
            TableFilter[] filters = new TableFilter[]{filter};
            PlanItem item = filter.getBestPlanItem(this.session, filters, 0, new AllColumnsForPlan(filters));
            filter.setPlanItem(item);
            filter.prepare();
            filter.startQuery(this.session);
            filter.reset();
            while (filter.next()) {
                ConstraintDomain.this.check(this.session, filter.getValue(targetColumn));
            }
            return false;
        }

        private boolean checkDomain(Domain domain, Domain targetDomain) {
            AlterDomain.forAllDependencies(this.session, targetDomain, this::checkColumn, this::checkDomain, false);
            return false;
        }
    }
}

