/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.Comparator;
import org.h2.api.DatabaseEventListener;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.value.ValueInteger;
import org.h2.value.ValueVarchar;

public class MetaRecord
implements Comparable<MetaRecord> {
    static final Comparator<Prepared> CONSTRAINTS_COMPARATOR = (o1, o2) -> {
        boolean u2;
        int t1 = o1.getType();
        int t2 = o2.getType();
        boolean u1 = t1 == 6 || t1 == 4;
        boolean bl = u2 = t2 == 6 || t2 == 4;
        if (u1 == u2) {
            return o1.getPersistedObjectId() - o2.getPersistedObjectId();
        }
        return u1 ? -1 : 1;
    };
    private final int id;
    private final int objectType;
    private final String sql;

    public static void populateRowFromDBObject(DbObject obj, SearchRow r) {
        r.setValue(0, ValueInteger.get(obj.getId()));
        r.setValue(1, ValueInteger.get(0));
        r.setValue(2, ValueInteger.get(obj.getType()));
        r.setValue(3, ValueVarchar.get(obj.getCreateSQLForMeta()));
    }

    public MetaRecord(SearchRow r) {
        this.id = r.getValue(0).getInt();
        this.objectType = r.getValue(2).getInt();
        this.sql = r.getValue(3).getString();
    }

    void prepareAndExecute(Database db, SessionLocal systemSession, DatabaseEventListener listener) {
        try {
            Prepared command = systemSession.prepare(this.sql);
            command.setPersistedObjectId(this.id);
            command.update();
        }
        catch (DbException e) {
            MetaRecord.throwException(db, listener, e, this.sql);
        }
    }

    Prepared prepare(Database db, SessionLocal systemSession, DatabaseEventListener listener) {
        try {
            Prepared command = systemSession.prepare(this.sql);
            command.setPersistedObjectId(this.id);
            return command;
        }
        catch (DbException e) {
            MetaRecord.throwException(db, listener, e, this.sql);
            return null;
        }
    }

    static void execute(Database db, Prepared command, DatabaseEventListener listener, String sql) {
        try {
            command.update();
        }
        catch (DbException e) {
            MetaRecord.throwException(db, listener, e, sql);
        }
    }

    private static void throwException(Database db, DatabaseEventListener listener, DbException e, String sql) {
        e = e.addSQL(sql);
        SQLException s = e.getSQLException();
        db.getTrace(2).error(s, sql);
        if (listener == null) {
            throw e;
        }
        listener.exceptionThrown(s, sql);
    }

    public int getId() {
        return this.id;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String getSQL() {
        return this.sql;
    }

    @Override
    public int compareTo(MetaRecord other) {
        int c2;
        int c1 = this.getCreateOrder();
        if (c1 != (c2 = other.getCreateOrder())) {
            return c1 - c2;
        }
        return this.getId() - other.getId();
    }

    private int getCreateOrder() {
        switch (this.objectType) {
            case 6: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 15: {
                return 11;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 13: {
                return 15;
            }
        }
        throw DbException.getInternalError("type=" + this.objectType);
    }

    public String toString() {
        return "MetaRecord [id=" + this.id + ", objectType=" + this.objectType + ", sql=" + this.sql + ']';
    }
}

