/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.schema.Schema;

public final class Role
extends RightOwner {
    private final boolean system;

    public Role(Database database, int id, String roleName, boolean system) {
        super(database, id, roleName, 13);
        this.system = system;
    }

    public String getCreateSQL(boolean ifNotExists) {
        if (this.system) {
            return null;
        }
        StringBuilder builder = new StringBuilder("CREATE ROLE ");
        if (ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        return this.getSQL(builder, 0).toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = new ArrayList<DbObject>();
        for (Schema schema : this.database.getAllSchemas()) {
            if (schema.getOwner() != this) continue;
            children.add(schema);
        }
        return children;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
            Right right = rightOwner.getRightForRole(this);
            if (right == null) continue;
            this.database.removeDatabaseObject(session, right);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }
}

