/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation2;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public final class ArrayElementReference
extends Operation2 {
    public ArrayElementReference(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.left.getSQL(builder, sqlFlags, 0).append('[');
        return this.right.getUnenclosedSQL(builder, sqlFlags).append(']');
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        Value r = this.right.getValue(session);
        if (l != ValueNull.INSTANCE && r != ValueNull.INSTANCE) {
            Value[] list = ((ValueArray)l).getList();
            int element = r.getInt();
            int cardinality = list.length;
            if (element >= 1 && element <= cardinality) {
                return list[element - 1];
            }
            throw DbException.get(22034, Integer.toString(element), "1.." + cardinality);
        }
        return ValueNull.INSTANCE;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        TypeInfo leftType = this.left.getType();
        switch (leftType.getValueType()) {
            case 0: {
                return ValueExpression.NULL;
            }
            case 40: {
                this.type = (TypeInfo)leftType.getExtTypeInfo();
                if (!this.left.isConstant() || !this.right.isConstant()) break;
                return TypedValueExpression.get(this.getValue(session), this.type);
            }
            default: {
                throw Store.getInvalidExpressionTypeException("Array", this.left);
            }
        }
        return this;
    }
}

