/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation2;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class CompatibilityDatePlusTimeOperation
extends Operation2 {
    public CompatibilityDatePlusTimeOperation(Expression left, Expression right) {
        super(left, right);
        int t;
        TypeInfo l = left.getType();
        TypeInfo r = right.getType();
        switch (l.getValueType()) {
            case 21: {
                if (r.getValueType() == 19) {
                    throw DbException.getUnsupportedException("TIMESTAMP WITH TIME ZONE + TIME WITH TIME ZONE");
                }
            }
            case 18: {
                t = r.getValueType() == 17 ? 20 : l.getValueType();
                break;
            }
            case 19: {
                if (r.getValueType() == 19) {
                    throw DbException.getUnsupportedException("TIME WITH TIME ZONE + TIME WITH TIME ZONE");
                }
                t = r.getValueType() == 17 ? 21 : l.getValueType();
                break;
            }
            case 20: {
                t = r.getValueType() == 19 ? 21 : 20;
                break;
            }
            default: {
                throw DbException.getUnsupportedException(Value.getTypeName(l.getValueType()) + " + " + Value.getTypeName(r.getValueType()));
            }
        }
        this.type = TypeInfo.getTypeInfo(t, 0L, Math.max(l.getScale(), r.getScale()), null);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.left.getSQL(builder, sqlFlags, 0).append(" + ");
        return this.right.getSQL(builder, sqlFlags, 0);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        Value r = this.right.getValue(session);
        if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        switch (l.getValueType()) {
            case 18: {
                if (r.getValueType() != 17) break;
                return ValueTimestamp.fromDateValueAndNanos(((ValueDate)r).getDateValue(), ((ValueTime)l).getNanos());
            }
            case 19: {
                if (r.getValueType() != 17) break;
                ValueTimeTimeZone t = (ValueTimeTimeZone)l;
                return ValueTimestampTimeZone.fromDateValueAndNanos(((ValueDate)r).getDateValue(), t.getNanos(), t.getTimeZoneOffsetSeconds());
            }
            case 20: {
                if (r.getValueType() != 19) break;
                ValueTimestamp ts = (ValueTimestamp)l;
                l = ValueTimestampTimeZone.fromDateValueAndNanos(ts.getDateValue(), ts.getTimeNanos(), ((ValueTimeTimeZone)r).getTimeZoneOffsetSeconds());
            }
        }
        long[] a = DateTimeUtils.dateAndTimeFromValue(l, session);
        long dateValue = a[0];
        long timeNanos = a[1] + (r instanceof ValueTime ? ((ValueTime)r).getNanos() : ((ValueTimeTimeZone)r).getNanos());
        if (timeNanos >= 86400000000000L) {
            timeNanos -= 86400000000000L;
            dateValue = DateTimeUtils.incrementDateValue(dateValue);
        }
        return DateTimeUtils.dateTimeToValue(l, dateValue, timeNanos);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }
}

