/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.OperationN;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.CastSpecification;
import org.h2.expression.function.ConcatFunction;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

public final class ConcatenationOperation
extends OperationN {
    public ConcatenationOperation() {
        super(new Expression[4]);
    }

    public ConcatenationOperation(Expression op1, Expression op2) {
        super(new Expression[]{op1, op2});
        this.argsCount = 2;
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        int l = this.args.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(" || ");
            }
            this.args[i].getSQL(builder, sqlFlags, 0);
        }
        return builder;
    }

    @Override
    public Value getValue(SessionLocal session) {
        int l = this.args.length;
        if (l == 2) {
            Value v1 = this.args[0].getValue(session);
            if ((v1 = v1.convertTo(this.type, (CastDataProvider)session)) == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            Value v2 = this.args[1].getValue(session);
            if ((v2 = v2.convertTo(this.type, (CastDataProvider)session)) == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            return this.getValue(session, v1, v2);
        }
        return this.getValue(session, l);
    }

    private Value getValue(SessionLocal session, Value l, Value r) {
        int valueType = this.type.getValueType();
        if (valueType == 2) {
            String s1 = l.getString();
            String s2 = r.getString();
            return ValueVarchar.get(new StringBuilder(s1.length() + s2.length()).append(s1).append(s2).toString());
        }
        if (valueType == 6) {
            byte[] leftBytes = l.getBytesNoCopy();
            byte[] rightBytes = r.getBytesNoCopy();
            int leftLength = leftBytes.length;
            int rightLength = rightBytes.length;
            byte[] bytes = Arrays.copyOf(leftBytes, leftLength + rightLength);
            System.arraycopy(rightBytes, 0, bytes, leftLength, rightLength);
            return ValueVarbinary.getNoCopy(bytes);
        }
        Value[] leftValues = ((ValueArray)l).getList();
        Value[] rightValues = ((ValueArray)r).getList();
        int leftLength = leftValues.length;
        int rightLength = rightValues.length;
        Value[] values = Arrays.copyOf(leftValues, leftLength + rightLength);
        System.arraycopy(rightValues, 0, values, leftLength, rightLength);
        return ValueArray.get((TypeInfo)this.type.getExtTypeInfo(), values, session);
    }

    private Value getValue(SessionLocal session, int l) {
        Value[] values = new Value[l];
        for (int i = 0; i < l; ++i) {
            Value v = this.args[i].getValue(session).convertTo(this.type, (CastDataProvider)session);
            if (v == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            values[i] = v;
        }
        int valueType = this.type.getValueType();
        if (valueType == 2) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < l; ++i) {
                builder.append(values[i].getString());
            }
            return ValueVarchar.get(builder.toString(), session);
        }
        if (valueType == 6) {
            int totalLength = 0;
            for (int i = 0; i < l; ++i) {
                totalLength += values[i].getBytesNoCopy().length;
            }
            byte[] v = new byte[totalLength];
            int offset = 0;
            for (int i = 0; i < l; ++i) {
                byte[] a = values[i].getBytesNoCopy();
                int length = a.length;
                System.arraycopy(a, 0, v, offset, length);
                offset += length;
            }
            return ValueVarbinary.getNoCopy(v);
        }
        int totalLength = 0;
        for (int i = 0; i < l; ++i) {
            totalLength += ((ValueArray)values[i]).getList().length;
        }
        Value[] v = new Value[totalLength];
        int offset = 0;
        for (int i = 0; i < l; ++i) {
            Value[] a = ((ValueArray)values[i]).getList();
            int length = a.length;
            System.arraycopy(a, 0, v, offset, length);
            offset += length;
        }
        return ValueArray.get((TypeInfo)this.type.getExtTypeInfo(), v, session);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.determineType(session);
        this.inlineArguments();
        if (this.type.getValueType() == 2 && session.getMode().treatEmptyStringsAsNull) {
            return new ConcatFunction(0, this.args).optimize(session);
        }
        int l = this.args.length;
        boolean allConst = true;
        boolean anyConst = false;
        for (int i = 0; i < l; ++i) {
            if (this.args[i].isConstant()) {
                anyConst = true;
                continue;
            }
            allConst = false;
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        if (anyConst) {
            int offset = 0;
            for (int i = 0; i < l; ++i) {
                Expression arg1 = this.args[i];
                if (arg1.isConstant()) {
                    Expression arg2;
                    Value v1 = arg1.getValue(session).convertTo(this.type, (CastDataProvider)session);
                    if (v1 == ValueNull.INSTANCE) {
                        return TypedValueExpression.get(ValueNull.INSTANCE, this.type);
                    }
                    if (ConcatenationOperation.isEmpty(v1)) continue;
                    while (i + 1 < l && (arg2 = this.args[i + 1]).isConstant()) {
                        Value v2 = arg2.getValue(session).convertTo(this.type, (CastDataProvider)session);
                        if (v2 == ValueNull.INSTANCE) {
                            return TypedValueExpression.get(ValueNull.INSTANCE, this.type);
                        }
                        if (!ConcatenationOperation.isEmpty(v2)) {
                            v1 = this.getValue(session, v1, v2);
                        }
                        ++i;
                    }
                    arg1 = ValueExpression.get(v1);
                }
                this.args[offset++] = arg1;
            }
            if (offset == 1) {
                Expression arg = this.args[0];
                TypeInfo argType = arg.getType();
                if (TypeInfo.areSameTypes(this.type, argType)) {
                    return arg;
                }
                return new CastSpecification(arg, this.type);
            }
            this.argsCount = offset;
            this.doneWithParameters();
        }
        return this;
    }

    private void determineType(SessionLocal session) {
        int i;
        int l = this.args.length;
        boolean anyArray = false;
        boolean allBinary = true;
        boolean allCharacter = true;
        for (int i2 = 0; i2 < l; ++i2) {
            Expression arg;
            this.args[i2] = arg = this.args[i2].optimize(session);
            int t = arg.getType().getValueType();
            if (t == 40) {
                anyArray = true;
                allCharacter = false;
                allBinary = false;
                continue;
            }
            if (t == 0) continue;
            if (DataType.isBinaryStringType(t)) {
                allCharacter = false;
                continue;
            }
            if (DataType.isCharacterStringType(t)) {
                allBinary = false;
                continue;
            }
            allCharacter = false;
            allBinary = false;
        }
        if (anyArray) {
            this.type = TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.getHigherType(this.args).getExtTypeInfo());
        } else if (allBinary) {
            long precision = this.getPrecision(0);
            for (i = 1; i < l; ++i) {
                precision = DataType.addPrecision(precision, this.getPrecision(i));
            }
            this.type = TypeInfo.getTypeInfo(6, precision, 0, null);
        } else if (allCharacter) {
            long precision = this.getPrecision(0);
            for (i = 1; i < l; ++i) {
                precision = DataType.addPrecision(precision, this.getPrecision(i));
            }
            this.type = TypeInfo.getTypeInfo(2, precision, 0, null);
        } else {
            this.type = TypeInfo.TYPE_VARCHAR;
        }
    }

    private long getPrecision(int i) {
        TypeInfo t = this.args[i].getType();
        return t.getValueType() != 0 ? t.getPrecision() : 0L;
    }

    private void inlineArguments() {
        int l;
        int valueType = this.type.getValueType();
        int count = l = this.args.length;
        for (int i = 0; i < l; ++i) {
            Expression arg = this.args[i];
            if (!(arg instanceof ConcatenationOperation) || arg.getType().getValueType() != valueType) continue;
            count += arg.getSubexpressionCount() - 1;
        }
        if (count > l) {
            Expression[] newArguments = new Expression[count];
            int offset = 0;
            for (int i = 0; i < l; ++i) {
                Expression arg = this.args[i];
                if (arg instanceof ConcatenationOperation && arg.getType().getValueType() == valueType) {
                    ConcatenationOperation c = (ConcatenationOperation)arg;
                    Expression[] innerArgs = c.args;
                    int innerLength = innerArgs.length;
                    System.arraycopy(innerArgs, 0, newArguments, offset, innerLength);
                    offset += innerLength;
                    continue;
                }
                newArguments[offset++] = arg;
            }
            this.args = newArguments;
            this.argsCount = count;
        }
    }

    private static boolean isEmpty(Value v) {
        int valueType = v.getValueType();
        if (valueType == 2) {
            return v.getString().isEmpty();
        }
        if (valueType == 6) {
            return v.getBytesNoCopy().length == 0;
        }
        return ((ValueArray)v).getList().length == 0;
    }
}

