/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueRow;

public final class ExpressionList
extends Expression {
    private final Expression[] list;
    private final boolean isArray;
    private TypeInfo type;

    public ExpressionList(Expression[] list, boolean isArray) {
        this.list = list;
        this.isArray = isArray;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value[] v = new Value[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            v[i] = this.list[i].getValue(session);
        }
        return this.isArray ? ValueArray.get((TypeInfo)this.type.getExtTypeInfo(), v, session) : ValueRow.get(this.type, v);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        for (Expression e : this.list) {
            e.mapColumns(resolver, level, state);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = true;
        int count = this.list.length;
        for (int i = 0; i < count; ++i) {
            Expression e = this.list[i].optimize(session);
            if (!e.isConstant()) {
                allConst = false;
            }
            this.list[i] = e;
        }
        this.initializeType();
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    void initializeType() {
        this.type = this.isArray ? TypeInfo.getTypeInfo(40, this.list.length, 0, TypeInfo.getHigherType(this.list)) : TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(this.list));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.list) {
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.isArray ? ExpressionList.writeExpressions(builder.append("ARRAY ["), this.list, sqlFlags).append(']') : ExpressionList.writeExpressions(builder.append("ROW ("), this.list, sqlFlags).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        for (Expression e : this.list) {
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        for (Expression e : this.list) {
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 1;
        for (Expression e : this.list) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public boolean isConstant() {
        for (Expression e : this.list) {
            if (e.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSubexpressionCount() {
        return this.list.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.list[index];
    }

    public boolean isArray() {
        return this.isArray;
    }
}

