/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Map;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation1;
import org.h2.expression.TypedValueExpression;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.util.ParserUtil;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

public final class FieldReference
extends Operation1 {
    private final String fieldName;
    private int ordinal;

    public FieldReference(Expression arg, String fieldName) {
        super(arg);
        this.fieldName = fieldName;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return ParserUtil.quoteIdentifier(this.arg.getEnclosedSQL(builder, sqlFlags).append('.'), this.fieldName, sqlFlags);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.arg.getValue(session);
        if (l != ValueNull.INSTANCE) {
            return ((ValueRow)l).getList()[this.ordinal];
        }
        return ValueNull.INSTANCE;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        TypeInfo type = this.arg.getType();
        if (type.getValueType() != 41) {
            throw Store.getInvalidExpressionTypeException("ROW", this.arg);
        }
        int ordinal = 0;
        for (Map.Entry<String, TypeInfo> entry : ((ExtTypeInfoRow)type.getExtTypeInfo()).getFields()) {
            if (this.fieldName.equals(entry.getKey())) {
                this.type = type = entry.getValue();
                this.ordinal = ordinal;
                if (this.arg.isConstant()) {
                    return TypedValueExpression.get(this.getValue(session), type);
                }
                return this;
            }
            ++ordinal;
        }
        throw DbException.get(42122, this.fieldName);
    }
}

