/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;

public abstract class Operation1_2
extends Expression {
    protected Expression left;
    protected Expression right;
    protected TypeInfo type;

    protected Operation1_2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        if (this.right != null) {
            this.right.mapColumns(resolver, level, state);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        this.left.setEvaluatable(tableFilter, value);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, value);
        }
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        if (this.right != null) {
            this.right.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && (this.right == null || this.right.isEverything(visitor));
    }

    @Override
    public int getCost() {
        int cost = this.left.getCost() + 1;
        if (this.right != null) {
            cost += this.right.getCost();
        }
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return this.right != null ? 2 : 1;
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        if (index == 1 && this.right != null) {
            return this.right;
        }
        throw new IndexOutOfBoundsException();
    }
}

