/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class Wildcard
extends Expression {
    private final String schema;
    private final String table;
    private ArrayList<ExpressionColumn> exceptColumns;

    public Wildcard(String schema, String table) {
        this.schema = schema;
        this.table = table;
    }

    public ArrayList<ExpressionColumn> getExceptColumns() {
        return this.exceptColumns;
    }

    public void setExceptColumns(ArrayList<ExpressionColumn> exceptColumns) {
        this.exceptColumns = exceptColumns;
    }

    public HashMap<Column, ExpressionColumn> mapExceptColumns() {
        HashMap<Column, ExpressionColumn> exceptTableColumns = new HashMap<Column, ExpressionColumn>();
        for (ExpressionColumn ec : this.exceptColumns) {
            Column column = ec.getColumn();
            if (column == null) {
                throw ec.getColumnException(42122);
            }
            if (exceptTableColumns.putIfAbsent(column, ec) == null) continue;
            throw ec.getColumnException(42121);
        }
        return exceptTableColumns;
    }

    @Override
    public Value getValue(SessionLocal session) {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public TypeInfo getType() {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.exceptColumns != null) {
            for (ExpressionColumn column : this.exceptColumns) {
                column.mapColumns(resolver, level, state);
            }
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        throw DbException.get(42000, this.table);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public String getTableAlias() {
        return this.table;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        if (this.table != null) {
            StringUtils.quoteIdentifier(builder, this.table).append('.');
        }
        builder.append('*');
        if (this.exceptColumns != null) {
            Wildcard.writeExpressions(builder.append(" EXCEPT ("), this.exceptColumns, sqlFlags).append(')');
        }
        return builder;
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.getType() == 8) {
            return true;
        }
        throw DbException.getInternalError(Integer.toString(visitor.getType()));
    }

    @Override
    public int getCost() {
        throw DbException.getInternalError(this.toString());
    }
}

