/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.command.query.Select;
import org.h2.command.query.SelectGroups;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.expression.analysis.WindowFrameExclusion;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public abstract class AbstractAggregate
extends DataAnalysisOperation {
    protected final boolean distinct;
    protected final Expression[] args;
    protected Expression filterCondition;
    protected TypeInfo type;

    AbstractAggregate(Select select, Expression[] args, boolean distinct) {
        super(select);
        this.args = args;
        this.distinct = distinct;
    }

    @Override
    public final boolean isAggregate() {
        return true;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(Expression filterCondition) {
        this.filterCondition = filterCondition;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver resolver, int level, int innerState) {
        for (Expression arg : this.args) {
            arg.mapColumns(resolver, level, innerState);
        }
        if (this.filterCondition != null) {
            this.filterCondition.mapColumns(resolver, level, innerState);
        }
        super.mapColumnsAnalysis(resolver, level, innerState);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = this.args[i].optimize(session);
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimizeCondition(session);
        }
        return super.optimize(session);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression arg : this.args) {
            arg.setEvaluatable(tableFilter, b);
        }
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, b);
        }
        super.setEvaluatable(tableFilter, b);
    }

    @Override
    protected void getOrderedResultLoop(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        boolean grouped;
        WindowFrame frame = this.over.getWindowFrame();
        boolean bl = grouped = frame == null || frame.getUnits() != WindowFrameUnits.ROWS && frame.getExclusion().isGroupOrNoOthers();
        if (frame == null) {
            this.aggregateFastPartition(session, result, ordered, rowIdColumn, grouped);
            return;
        }
        boolean variableBounds = frame.isVariableBounds();
        if (variableBounds) {
            variableBounds = AbstractAggregate.checkVariableBounds(frame, ordered);
        }
        if (variableBounds) {
            grouped = false;
        } else if (frame.getExclusion() == WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            boolean unboundedFollowing;
            WindowFrameBound following = frame.getFollowing();
            boolean bl2 = unboundedFollowing = following != null && following.getType() == WindowFrameBoundType.UNBOUNDED_FOLLOWING;
            if (frame.getStarting().getType() == WindowFrameBoundType.UNBOUNDED_PRECEDING) {
                if (unboundedFollowing) {
                    this.aggregateWholePartition(session, result, ordered, rowIdColumn);
                } else {
                    this.aggregateFastPartition(session, result, ordered, rowIdColumn, grouped);
                }
                return;
            }
            if (unboundedFollowing) {
                this.aggregateFastPartitionInReverse(session, result, ordered, rowIdColumn, grouped);
                return;
            }
        }
        int size = ordered.size();
        int i = 0;
        while (i < size) {
            Object aggregateData = this.createAggregateData();
            Iterator<Value[]> iter = WindowFrame.iterator(this.over, session, ordered, this.getOverOrderBySort(), i, false);
            while (iter.hasNext()) {
                this.updateFromExpressions(session, aggregateData, iter.next());
            }
            Value r = this.getAggregatedValue(session, aggregateData);
            i = this.processGroup(result, r, ordered, rowIdColumn, i, size, grouped);
        }
    }

    private static boolean checkVariableBounds(WindowFrame frame, ArrayList<Value[]> ordered) {
        int i;
        Value v;
        int offset;
        int size = ordered.size();
        WindowFrameBound bound = frame.getStarting();
        if (bound.isVariable()) {
            offset = bound.getExpressionIndex();
            v = ordered.get(0)[offset];
            for (i = 1; i < size; ++i) {
                if (v.equals(ordered.get(i)[offset])) continue;
                return true;
            }
        }
        if ((bound = frame.getFollowing()) != null && bound.isVariable()) {
            offset = bound.getExpressionIndex();
            v = ordered.get(0)[offset];
            for (i = 1; i < size; ++i) {
                if (v.equals(ordered.get(i)[offset])) continue;
                return true;
            }
        }
        return false;
    }

    private void aggregateFastPartition(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn, boolean grouped) {
        Object aggregateData = this.createAggregateData();
        int size = ordered.size();
        int lastIncludedRow = -1;
        Value r = null;
        int i = 0;
        while (i < size) {
            int newLast = WindowFrame.getEndIndex(this.over, session, ordered, this.getOverOrderBySort(), i);
            assert (newLast >= lastIncludedRow);
            if (newLast > lastIncludedRow) {
                for (int j = lastIncludedRow + 1; j <= newLast; ++j) {
                    this.updateFromExpressions(session, aggregateData, ordered.get(j));
                }
                lastIncludedRow = newLast;
                r = this.getAggregatedValue(session, aggregateData);
            } else if (r == null) {
                r = this.getAggregatedValue(session, aggregateData);
            }
            i = this.processGroup(result, r, ordered, rowIdColumn, i, size, grouped);
        }
    }

    private void aggregateFastPartitionInReverse(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn, boolean grouped) {
        Object aggregateData = this.createAggregateData();
        int firstIncludedRow = ordered.size();
        Value r = null;
        int i = firstIncludedRow - 1;
        while (i >= 0) {
            Value[] lastRowInGroup;
            int newLast = this.over.getWindowFrame().getStartIndex(session, ordered, this.getOverOrderBySort(), i);
            assert (newLast <= firstIncludedRow);
            if (newLast < firstIncludedRow) {
                for (int j = firstIncludedRow - 1; j >= newLast; --j) {
                    this.updateFromExpressions(session, aggregateData, ordered.get(j));
                }
                firstIncludedRow = newLast;
                r = this.getAggregatedValue(session, aggregateData);
            } else if (r == null) {
                r = this.getAggregatedValue(session, aggregateData);
            }
            Value[] currentRowInGroup = lastRowInGroup = ordered.get(i);
            do {
                result.put(currentRowInGroup[rowIdColumn].getInt(), r);
            } while (--i >= 0 && grouped && this.overOrderBySort.compare(lastRowInGroup, currentRowInGroup = ordered.get(i)) == 0);
        }
    }

    private int processGroup(HashMap<Integer, Value> result, Value r, ArrayList<Value[]> ordered, int rowIdColumn, int i, int size, boolean grouped) {
        Value[] firstRowInGroup;
        Value[] currentRowInGroup = firstRowInGroup = ordered.get(i);
        do {
            result.put(currentRowInGroup[rowIdColumn].getInt(), r);
        } while (++i < size && grouped && this.overOrderBySort.compare(firstRowInGroup, currentRowInGroup = ordered.get(i)) == 0);
        return i;
    }

    private void aggregateWholePartition(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        Object aggregateData = this.createAggregateData();
        for (Value[] row : ordered) {
            this.updateFromExpressions(session, aggregateData, row);
        }
        Value value = this.getAggregatedValue(session, aggregateData);
        for (Value[] row : ordered) {
            result.put(row[rowIdColumn].getInt(), value);
        }
    }

    protected abstract void updateFromExpressions(SessionLocal var1, Object var2, Value[] var3);

    @Override
    protected void updateAggregate(SessionLocal session, SelectGroups groupData, int groupRowId) {
        if (this.filterCondition == null || this.filterCondition.getBooleanValue(session)) {
            if (this.over != null) {
                if (this.over.isOrdered()) {
                    this.updateOrderedAggregate(session, groupData, groupRowId, this.over.getOrderBy());
                } else {
                    this.updateAggregate(session, this.getWindowData(session, groupData, false));
                }
            } else {
                this.updateAggregate(session, this.getGroupData(groupData, false));
            }
        } else if (this.over != null && this.over.isOrdered()) {
            this.updateOrderedAggregate(session, groupData, groupRowId, this.over.getOrderBy());
        }
    }

    protected abstract void updateAggregate(SessionLocal var1, Object var2);

    @Override
    protected void updateGroupAggregates(SessionLocal session, int stage) {
        if (this.filterCondition != null) {
            this.filterCondition.updateAggregate(session, stage);
        }
        super.updateGroupAggregates(session, stage);
    }

    @Override
    protected StringBuilder appendTailConditions(StringBuilder builder, int sqlFlags, boolean forceOrderBy) {
        if (this.filterCondition != null) {
            builder.append(" FILTER (WHERE ");
            this.filterCondition.getUnenclosedSQL(builder, sqlFlags).append(')');
        }
        return super.appendTailConditions(builder, sqlFlags, forceOrderBy);
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.args[index];
    }
}

