/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.h2.command.query.QueryOrderBy;
import org.h2.command.query.Select;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ExpressionWithFlags;
import org.h2.expression.ValueExpression;
import org.h2.expression.aggregate.AbstractAggregate;
import org.h2.expression.aggregate.AggregateData;
import org.h2.expression.aggregate.AggregateDataAvg;
import org.h2.expression.aggregate.AggregateDataBinarySet;
import org.h2.expression.aggregate.AggregateDataCollecting;
import org.h2.expression.aggregate.AggregateDataCorr;
import org.h2.expression.aggregate.AggregateDataCount;
import org.h2.expression.aggregate.AggregateDataCovar;
import org.h2.expression.aggregate.AggregateDataDefault;
import org.h2.expression.aggregate.AggregateDataDistinctWithCounts;
import org.h2.expression.aggregate.AggregateDataEnvelope;
import org.h2.expression.aggregate.AggregateDataStdVar;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.aggregate.ListaggArguments;
import org.h2.expression.aggregate.LongDataCounter;
import org.h2.expression.aggregate.Percentile;
import org.h2.expression.analysis.Window;
import org.h2.expression.function.BitFunction;
import org.h2.expression.function.JsonConstructorFunction;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.util.json.JsonConstructorUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;
import org.h2.value.ValueVarchar;

public class Aggregate
extends AbstractAggregate
implements ExpressionWithFlags {
    private static final int ADDITIONAL_SUM_PRECISION = 10;
    private static final int ADDITIONAL_AVG_SCALE = 10;
    private static final HashMap<String, AggregateType> AGGREGATES = new HashMap(128);
    private final AggregateType aggregateType;
    private ArrayList<QueryOrderBy> orderByList;
    private SortOrder orderBySort;
    private Object extraArguments;
    private int flags;

    public Aggregate(AggregateType aggregateType, Expression[] args, Select select, boolean distinct) {
        super(select, args, distinct);
        if (distinct && aggregateType == AggregateType.COUNT_ALL) {
            throw DbException.getInternalError();
        }
        this.aggregateType = aggregateType;
    }

    private static void addAggregate(String name, AggregateType type) {
        AGGREGATES.put(name, type);
    }

    public static AggregateType getAggregateType(String name) {
        return AGGREGATES.get(name);
    }

    public void setOrderByList(ArrayList<QueryOrderBy> orderByList) {
        this.orderByList = orderByList;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    public void setExtraArguments(Object extraArguments) {
        this.extraArguments = extraArguments;
    }

    public Object getExtraArguments() {
        return this.extraArguments;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    private void sortWithOrderBy(Value[] array) {
        SortOrder sortOrder = this.orderBySort;
        Arrays.sort(array, sortOrder != null ? (v1, v2) -> sortOrder.compare(((ValueRow)v1).getList(), ((ValueRow)v2).getList()) : this.select.getSession().getDatabase().getCompareMode());
    }

    @Override
    protected void updateAggregate(SessionLocal session, Object aggregateData) {
        AggregateData data = (AggregateData)aggregateData;
        Value v = this.args.length == 0 ? null : this.args[0].getValue(session);
        this.updateData(session, data, v, null);
    }

    private void updateData(SessionLocal session, AggregateData data, Value v, Value[] remembered) {
        switch (this.aggregateType) {
            case COVAR_POP: 
            case COVAR_SAMP: 
            case CORR: 
            case REGR_SLOPE: 
            case REGR_INTERCEPT: 
            case REGR_R2: 
            case REGR_SXY: {
                Value x;
                if (v == ValueNull.INSTANCE || (x = this.getSecondValue(session, remembered)) == ValueNull.INSTANCE) {
                    return;
                }
                ((AggregateDataBinarySet)data).add(session, v, x);
                return;
            }
            case REGR_COUNT: 
            case REGR_AVGY: 
            case REGR_SYY: {
                if (v != ValueNull.INSTANCE && this.getSecondValue(session, remembered) != ValueNull.INSTANCE) break;
                return;
            }
            case REGR_AVGX: 
            case REGR_SXX: {
                if (v != ValueNull.INSTANCE && (v = this.getSecondValue(session, remembered)) != ValueNull.INSTANCE) break;
                return;
            }
            case LISTAGG: {
                if (v == ValueNull.INSTANCE) {
                    return;
                }
                v = this.updateCollecting(session, v.convertTo(TypeInfo.TYPE_VARCHAR), remembered);
                break;
            }
            case ARRAY_AGG: {
                v = this.updateCollecting(session, v, remembered);
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                int i;
                int count = this.args.length;
                Value[] a = new Value[count];
                for (i = 0; i < count; ++i) {
                    a[i] = remembered != null ? remembered[i] : this.args[i].getValue(session);
                }
                ((AggregateDataCollecting)data).setSharedArgument(ValueRow.get(a));
                a = new Value[count];
                for (i = 0; i < count; ++i) {
                    a[i] = remembered != null ? remembered[count + i] : this.orderByList.get((int)i).expression.getValue(session);
                }
                v = ValueRow.get(a);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                ((AggregateDataCollecting)data).setSharedArgument(v);
                v = remembered != null ? remembered[1] : this.orderByList.get((int)0).expression.getValue(session);
                break;
            }
            case MODE: {
                v = remembered != null ? remembered[0] : this.orderByList.get((int)0).expression.getValue(session);
                break;
            }
            case JSON_ARRAYAGG: {
                v = this.updateCollecting(session, v, remembered);
                break;
            }
            case JSON_OBJECTAGG: {
                Value key = v;
                Value value = this.getSecondValue(session, remembered);
                if (key == ValueNull.INSTANCE) {
                    throw DbException.getInvalidValueException("JSON_OBJECTAGG key", "NULL");
                }
                v = ValueRow.get(new Value[]{key, value});
                break;
            }
        }
        data.add(session, v);
    }

    private Value getSecondValue(SessionLocal session, Value[] remembered) {
        return remembered != null ? remembered[1] : this.args[1].getValue(session);
    }

    @Override
    protected void updateGroupAggregates(SessionLocal session, int stage) {
        super.updateGroupAggregates(session, stage);
        for (Expression arg : this.args) {
            arg.updateAggregate(session, stage);
        }
        if (this.orderByList != null) {
            for (QueryOrderBy orderBy : this.orderByList) {
                orderBy.expression.updateAggregate(session, stage);
            }
        }
    }

    private Value updateCollecting(SessionLocal session, Value v, Value[] remembered) {
        if (this.orderByList != null) {
            int size = this.orderByList.size();
            Value[] row = new Value[1 + size];
            row[0] = v;
            if (remembered == null) {
                for (int i = 0; i < size; ++i) {
                    QueryOrderBy o = this.orderByList.get(i);
                    row[i + 1] = o.expression.getValue(session);
                }
            } else {
                System.arraycopy(remembered, 1, row, 1, size);
            }
            v = ValueRow.get(row);
        }
        return v;
    }

    @Override
    protected int getNumExpressions() {
        int n = this.args.length;
        if (this.orderByList != null) {
            n += this.orderByList.size();
        }
        if (this.filterCondition != null) {
            ++n;
        }
        return n;
    }

    @Override
    protected void rememberExpressions(SessionLocal session, Value[] array) {
        int offset = 0;
        for (Expression arg : this.args) {
            array[offset++] = arg.getValue(session);
        }
        if (this.orderByList != null) {
            for (QueryOrderBy o : this.orderByList) {
                array[offset++] = o.expression.getValue(session);
            }
        }
        if (this.filterCondition != null) {
            array[offset] = ValueBoolean.get(this.filterCondition.getBooleanValue(session));
        }
    }

    @Override
    protected void updateFromExpressions(SessionLocal session, Object aggregateData, Value[] array) {
        if (this.filterCondition == null || array[this.getNumExpressions() - 1].isTrue()) {
            AggregateData data = (AggregateData)aggregateData;
            Value v = this.args.length == 0 ? null : array[0];
            this.updateData(session, data, v, array);
        }
    }

    @Override
    protected Object createAggregateData() {
        switch (this.aggregateType) {
            case REGR_COUNT: 
            case COUNT_ALL: {
                return new AggregateDataCount(true);
            }
            case COUNT: {
                if (this.distinct) break;
                return new AggregateDataCount(false);
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: 
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: 
            case MEDIAN: {
                break;
            }
            case SUM: 
            case BIT_XOR_AGG: 
            case BIT_XNOR_AGG: {
                if (this.distinct) break;
            }
            case MIN: 
            case MAX: 
            case BIT_AND_AGG: 
            case BIT_OR_AGG: 
            case BIT_NAND_AGG: 
            case BIT_NOR_AGG: 
            case ANY: 
            case EVERY: {
                return new AggregateDataDefault(this.aggregateType, this.type);
            }
            case AVG: {
                if (this.distinct) break;
            }
            case REGR_AVGY: 
            case REGR_AVGX: {
                return new AggregateDataAvg(this.type);
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                if (this.distinct) break;
            }
            case REGR_SYY: 
            case REGR_SXX: {
                return new AggregateDataStdVar(this.aggregateType);
            }
            case HISTOGRAM: {
                return new AggregateDataDistinctWithCounts(false, 10000);
            }
            case COVAR_POP: 
            case COVAR_SAMP: 
            case REGR_SXY: {
                return new AggregateDataCovar(this.aggregateType);
            }
            case CORR: 
            case REGR_SLOPE: 
            case REGR_INTERCEPT: 
            case REGR_R2: {
                return new AggregateDataCorr(this.aggregateType);
            }
            case LISTAGG: 
            case ARRAY_AGG: {
                return new AggregateDataCollecting(this.distinct, this.orderByList != null, AggregateDataCollecting.NullCollectionMode.USED_OR_IMPOSSIBLE);
            }
            case MODE: {
                return new AggregateDataDistinctWithCounts(true, Integer.MAX_VALUE);
            }
            case ENVELOPE: {
                return new AggregateDataEnvelope();
            }
            case JSON_ARRAYAGG: {
                return new AggregateDataCollecting(this.distinct, this.orderByList != null, (this.flags & 1) != 0 ? AggregateDataCollecting.NullCollectionMode.EXCLUDED : AggregateDataCollecting.NullCollectionMode.USED_OR_IMPOSSIBLE);
            }
            case JSON_OBJECTAGG: {
                return new AggregateDataCollecting(this.distinct, false, AggregateDataCollecting.NullCollectionMode.USED_OR_IMPOSSIBLE);
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return new AggregateDataCollecting(this.distinct, false, AggregateDataCollecting.NullCollectionMode.IGNORED);
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.select.isQuickAggregateQuery() ? this.getValueQuick(session) : super.getValue(session);
    }

    private Value getValueQuick(SessionLocal session) {
        switch (this.aggregateType) {
            case COUNT_ALL: 
            case COUNT: {
                Table table = this.select.getTopTableFilter().getTable();
                return ValueBigint.get(table.getRowCount(session));
            }
            case MIN: 
            case MAX: {
                Cursor cursor;
                SearchRow row;
                boolean first = this.aggregateType == AggregateType.MIN;
                Index index = this.getMinMaxColumnIndex();
                int sortType = index.getIndexColumns()[0].sortType;
                if ((sortType & 1) != 0) {
                    first = !first;
                }
                Value v = (row = (cursor = index.findFirstOrLast(session, first)).getSearchRow()) == null ? ValueNull.INSTANCE : row.getValue(index.getColumns()[0].getColumnId());
                return v;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Value v = this.args[0].getValue(session);
                if (v == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                BigDecimal arg = v.getBigDecimal();
                if (arg.signum() >= 0 && arg.compareTo(BigDecimal.ONE) <= 0) {
                    return Percentile.getFromIndex(session, this.orderByList.get((int)0).expression, this.type.getValueType(), this.orderByList, arg, this.aggregateType == AggregateType.PERCENTILE_CONT);
                }
                throw DbException.getInvalidValueException(this.aggregateType == AggregateType.PERCENTILE_CONT ? "PERCENTILE_CONT argument" : "PERCENTILE_DISC argument", arg);
            }
            case MEDIAN: {
                return Percentile.getFromIndex(session, this.args[0], this.type.getValueType(), this.orderByList, Percentile.HALF, true);
            }
            case ENVELOPE: {
                return ((MVSpatialIndex)AggregateDataEnvelope.getGeometryColumnIndex(this.args[0])).getBounds(session);
            }
        }
        throw DbException.getInternalError("type=" + (Object)((Object)this.aggregateType));
    }

    @Override
    public Value getAggregatedValue(SessionLocal session, Object aggregateData) {
        AggregateData data = (AggregateData)aggregateData;
        if (data == null) {
            data = (AggregateData)this.createAggregateData();
        }
        switch (this.aggregateType) {
            case COUNT: {
                if (!this.distinct) break;
                return ValueBigint.get(((AggregateDataCollecting)data).getCount());
            }
            case SUM: 
            case BIT_XOR_AGG: 
            case BIT_XNOR_AGG: {
                if (!this.distinct) break;
                AggregateDataCollecting c = (AggregateDataCollecting)data;
                if (c.getCount() == 0) {
                    return ValueNull.INSTANCE;
                }
                return Aggregate.collect(session, c, new AggregateDataDefault(this.aggregateType, this.type));
            }
            case AVG: {
                if (!this.distinct) break;
                AggregateDataCollecting c = (AggregateDataCollecting)data;
                if (c.getCount() == 0) {
                    return ValueNull.INSTANCE;
                }
                return Aggregate.collect(session, c, new AggregateDataAvg(this.type));
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                if (!this.distinct) break;
                AggregateDataCollecting c = (AggregateDataCollecting)data;
                if (c.getCount() == 0) {
                    return ValueNull.INSTANCE;
                }
                return Aggregate.collect(session, c, new AggregateDataStdVar(this.aggregateType));
            }
            case HISTOGRAM: {
                return this.getHistogram(session, data);
            }
            case LISTAGG: {
                return this.getListagg(session, data);
            }
            case ARRAY_AGG: {
                Value[] array = ((AggregateDataCollecting)data).getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                if (this.orderByList != null || this.distinct) {
                    this.sortWithOrderBy(array);
                }
                if (this.orderByList != null) {
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = ((ValueRow)array[i]).getList()[0];
                    }
                }
                return ValueArray.get((TypeInfo)this.type.getExtTypeInfo(), array, session);
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                return this.getHypotheticalSet(session, data);
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                AggregateDataCollecting collectingData = (AggregateDataCollecting)data;
                Value[] array = collectingData.getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                Value v = collectingData.getSharedArgument();
                if (v == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                BigDecimal arg = v.getBigDecimal();
                if (arg.signum() >= 0 && arg.compareTo(BigDecimal.ONE) <= 0) {
                    return Percentile.getValue(session, array, this.type.getValueType(), this.orderByList, arg, this.aggregateType == AggregateType.PERCENTILE_CONT);
                }
                throw DbException.getInvalidValueException(this.aggregateType == AggregateType.PERCENTILE_CONT ? "PERCENTILE_CONT argument" : "PERCENTILE_DISC argument", arg);
            }
            case MEDIAN: {
                Value[] array = ((AggregateDataCollecting)data).getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                return Percentile.getValue(session, array, this.type.getValueType(), this.orderByList, Percentile.HALF, true);
            }
            case MODE: {
                return this.getMode(session, data);
            }
            case JSON_ARRAYAGG: {
                Value[] array = ((AggregateDataCollecting)data).getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                if (this.orderByList != null) {
                    this.sortWithOrderBy(array);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(91);
                for (Value v : array) {
                    if (this.orderByList != null) {
                        v = ((ValueRow)v).getList()[0];
                    }
                    JsonConstructorUtils.jsonArrayAppend(baos, v != ValueNull.INSTANCE ? v : ValueJson.NULL, this.flags);
                }
                baos.write(93);
                return ValueJson.getInternal(baos.toByteArray());
            }
            case JSON_OBJECTAGG: {
                Value[] array = ((AggregateDataCollecting)data).getArray();
                if (array == null) {
                    return ValueNull.INSTANCE;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(123);
                for (Value v : array) {
                    Value[] row = ((ValueRow)v).getList();
                    String key = row[0].getString();
                    if (key == null) {
                        throw DbException.getInvalidValueException("JSON_OBJECTAGG key", "NULL");
                    }
                    Value value = row[1];
                    if (value == ValueNull.INSTANCE) {
                        if ((this.flags & 1) != 0) continue;
                        value = ValueJson.NULL;
                    }
                    JsonConstructorUtils.jsonObjectAppend(baos, key, value);
                }
                return JsonConstructorUtils.jsonObjectFinish(baos, this.flags);
            }
        }
        return data.getValue(session);
    }

    private static Value collect(SessionLocal session, AggregateDataCollecting c, AggregateData d) {
        for (Value v : c) {
            d.add(session, v);
        }
        return d.getValue(session);
    }

    private Value getHypotheticalSet(SessionLocal session, AggregateData data) {
        AggregateDataCollecting collectingData = (AggregateDataCollecting)data;
        Value arg = collectingData.getSharedArgument();
        if (arg == null) {
            switch (this.aggregateType) {
                case RANK: 
                case DENSE_RANK: {
                    return ValueInteger.get(1);
                }
                case PERCENT_RANK: {
                    return ValueDouble.ZERO;
                }
                case CUME_DIST: {
                    return ValueDouble.ONE;
                }
            }
            throw DbException.getUnsupportedException("aggregateType=" + (Object)((Object)this.aggregateType));
        }
        collectingData.add(session, arg);
        Value[] array = collectingData.getArray();
        Comparator<Value> sort = this.orderBySort.getRowValueComparator();
        Arrays.sort(array, sort);
        return this.aggregateType == AggregateType.CUME_DIST ? Aggregate.getCumeDist(array, arg, sort) : this.getRank(array, arg, sort);
    }

    private Value getRank(Value[] ordered, Value arg, Comparator<Value> sort) {
        int size = ordered.length;
        int number = 0;
        for (int i = 0; i < size; ++i) {
            int nm;
            Value row = ordered[i];
            if (i == 0) {
                number = 1;
            } else if (sort.compare(ordered[i - 1], row) != 0) {
                number = this.aggregateType == AggregateType.DENSE_RANK ? ++number : i + 1;
            }
            Value v = this.aggregateType == AggregateType.PERCENT_RANK ? ((nm = number - 1) == 0 ? ValueDouble.ZERO : ValueDouble.get((double)nm / (double)(size - 1))) : ValueBigint.get(number);
            if (sort.compare(row, arg) != 0) continue;
            return v;
        }
        throw DbException.getInternalError();
    }

    private static Value getCumeDist(Value[] ordered, Value arg, Comparator<Value> sort) {
        int size = ordered.length;
        int start = 0;
        while (start < size) {
            int end;
            Value array = ordered[start];
            for (end = start + 1; end < size && sort.compare(array, ordered[end]) == 0; ++end) {
            }
            ValueDouble v = ValueDouble.get((double)end / (double)size);
            for (int i = start; i < end; ++i) {
                if (sort.compare(ordered[i], arg) != 0) continue;
                return v;
            }
            start = end;
        }
        throw DbException.getInternalError();
    }

    private Value getListagg(SessionLocal session, AggregateData data) {
        AggregateDataCollecting collectingData = (AggregateDataCollecting)data;
        Value[] array = collectingData.getArray();
        if (array == null) {
            return ValueNull.INSTANCE;
        }
        if (array.length == 1) {
            Value v = array[0];
            if (this.orderByList != null) {
                v = ((ValueRow)v).getList()[0];
            }
            return v.convertTo(2, (CastDataProvider)session);
        }
        if (this.orderByList != null || this.distinct) {
            this.sortWithOrderBy(array);
        }
        ListaggArguments arguments = (ListaggArguments)this.extraArguments;
        String separator = arguments.getEffectiveSeparator();
        return ValueVarchar.get((arguments.getOnOverflowTruncate() ? this.getListaggTruncate(array, separator, arguments.getEffectiveFilter(), arguments.isWithoutCount()) : this.getListaggError(array, separator)).toString(), session);
    }

    private StringBuilder getListaggError(Value[] array, String separator) {
        StringBuilder builder = new StringBuilder(this.getListaggItem(array[0]));
        int count = array.length;
        for (int i = 1; i < count; ++i) {
            builder.append(separator).append(this.getListaggItem(array[i]));
            if (builder.length() <= 1000000000) continue;
            throw DbException.getValueTooLongException("CHARACTER VARYING", builder.substring(0, 81), -1L);
        }
        return builder;
    }

    private StringBuilder getListaggTruncate(Value[] array, String separator, String filter, boolean withoutCount) {
        String s;
        int count = array.length;
        String[] strings = new String[count];
        strings[0] = s = this.getListaggItem(array[0]);
        int estimatedLength = (int)Math.min(Integer.MAX_VALUE, (long)s.length() * (long)count);
        StringBuilder builder = new StringBuilder(estimatedLength);
        builder.append(s);
        block0: for (int i = 1; i < count; ++i) {
            strings[i] = s = this.getListaggItem(array[i]);
            builder.append(separator).append(s);
            int length = builder.length();
            if (length <= 1000000000) continue;
            while (i > 0) {
                builder.setLength(length -= strings[i].length());
                builder.append(filter);
                if (!withoutCount) {
                    builder.append('(').append(count - i).append(')');
                }
                if (builder.length() <= 1000000000) break block0;
                length -= separator.length();
                --i;
            }
            builder.setLength(0);
            builder.append(filter).append('(').append(count).append(')');
            break;
        }
        return builder;
    }

    private String getListaggItem(Value v) {
        if (this.orderByList != null) {
            v = ((ValueRow)v).getList()[0];
        }
        return v.getString();
    }

    private Value getHistogram(SessionLocal session, AggregateData data) {
        TreeMap<Value, LongDataCounter> distinctValues = ((AggregateDataDistinctWithCounts)data).getValues();
        TypeInfo rowType = (TypeInfo)this.type.getExtTypeInfo();
        if (distinctValues == null) {
            return ValueArray.get(rowType, Value.EMPTY_VALUES, session);
        }
        Value[] values = new ValueRow[distinctValues.size()];
        int i = 0;
        for (Map.Entry<Value, LongDataCounter> entry : distinctValues.entrySet()) {
            LongDataCounter d = entry.getValue();
            values[i] = ValueRow.get(rowType, new Value[]{entry.getKey(), ValueBigint.get(d.count)});
            ++i;
        }
        Database db = session.getDatabase();
        CompareMode compareMode = db.getCompareMode();
        Arrays.sort(values, (v1, v2) -> v1.getList()[0].compareTo(v2.getList()[0], session, compareMode));
        return ValueArray.get(rowType, values, session);
    }

    private Value getMode(SessionLocal session, AggregateData data) {
        Value v = ValueNull.INSTANCE;
        TreeMap<Value, LongDataCounter> distinctValues = ((AggregateDataDistinctWithCounts)data).getValues();
        if (distinctValues == null) {
            return v;
        }
        long count = 0L;
        if (this.orderByList != null) {
            boolean desc = (this.orderByList.get((int)0).sortType & 1) != 0;
            for (Map.Entry<Value, LongDataCounter> entry : distinctValues.entrySet()) {
                long c = entry.getValue().count;
                if (c > count) {
                    v = entry.getKey();
                    count = c;
                    continue;
                }
                if (c != count) continue;
                Value v2 = entry.getKey();
                int cmp = session.compareTypeSafe(v, v2);
                if (desc ? cmp >= 0 : cmp <= 0) continue;
                v = v2;
            }
        } else {
            for (Map.Entry<Value, LongDataCounter> entry : distinctValues.entrySet()) {
                long c = entry.getValue().count;
                if (c <= count) continue;
                v = entry.getKey();
                count = c;
            }
        }
        return v;
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver resolver, int level, int innerState) {
        if (this.orderByList != null) {
            for (QueryOrderBy o : this.orderByList) {
                o.expression.mapColumns(resolver, level, innerState);
            }
        }
        super.mapColumnsAnalysis(resolver, level, innerState);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        super.optimize(session);
        if (this.args.length == 1) {
            this.type = this.args[0].getType();
        }
        if (this.orderByList != null) {
            int offset;
            switch (this.aggregateType) {
                case LISTAGG: 
                case ARRAY_AGG: 
                case JSON_ARRAYAGG: {
                    offset = 1;
                    break;
                }
                default: {
                    offset = 0;
                }
            }
            Iterator<QueryOrderBy> i = this.orderByList.iterator();
            while (i.hasNext()) {
                QueryOrderBy o = i.next();
                Expression e = o.expression.optimize(session);
                if (offset != 0 && e.isConstant()) {
                    i.remove();
                    continue;
                }
                o.expression = e;
            }
            if (this.orderByList.isEmpty()) {
                this.orderByList = null;
            } else {
                this.orderBySort = Aggregate.createOrder(session, this.orderByList, offset);
            }
        }
        switch (this.aggregateType) {
            case LISTAGG: {
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            case COUNT: {
                if (this.args[0].isConstant()) {
                    if (this.args[0].getValue(session) == ValueNull.INSTANCE) {
                        return ValueExpression.get(ValueBigint.get(0L));
                    }
                    if (!this.distinct) {
                        Aggregate aggregate = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.select, false);
                        aggregate.setFilterCondition(this.filterCondition);
                        aggregate.setOverCondition(this.over);
                        return aggregate.optimize(session);
                    }
                }
            }
            case REGR_COUNT: 
            case COUNT_ALL: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            case HISTOGRAM: {
                LinkedHashMap<String, TypeInfo> fields = new LinkedHashMap<String, TypeInfo>(4);
                fields.put("VALUE", this.type);
                fields.put("COUNT", TypeInfo.TYPE_BIGINT);
                this.type = TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.getTypeInfo(41, -1L, -1, new ExtTypeInfoRow(fields)));
                break;
            }
            case SUM: {
                this.type = Aggregate.getSumType(this.type);
                if (this.type != null) break;
                throw DbException.get(90015, this.getTraceSQL());
            }
            case AVG: {
                this.type = Aggregate.getAvgType(this.type);
                if (this.type != null) break;
                throw DbException.get(90015, this.getTraceSQL());
            }
            case MIN: 
            case MAX: {
                break;
            }
            case COVAR_POP: 
            case COVAR_SAMP: 
            case CORR: 
            case REGR_SLOPE: 
            case REGR_INTERCEPT: 
            case REGR_R2: 
            case REGR_SXY: 
            case REGR_SYY: 
            case REGR_SXX: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case REGR_AVGX: {
                this.type = Aggregate.getAvgType(this.args[1].getType());
                if (this.type != null) break;
                throw DbException.get(90015, this.getTraceSQL());
            }
            case REGR_AVGY: {
                this.type = Aggregate.getAvgType(this.args[0].getType());
                if (this.type != null) break;
                throw DbException.get(90015, this.getTraceSQL());
            }
            case RANK: 
            case DENSE_RANK: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            case PERCENT_RANK: 
            case CUME_DIST: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case PERCENTILE_CONT: {
                this.type = this.orderByList.get((int)0).expression.getType();
            }
            case MEDIAN: {
                switch (this.type.getValueType()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.type = TypeInfo.TYPE_NUMERIC_FLOATING_POINT;
                    }
                }
                break;
            }
            case PERCENTILE_DISC: 
            case MODE: {
                this.type = this.orderByList.get((int)0).expression.getType();
                break;
            }
            case ANY: 
            case EVERY: {
                this.type = TypeInfo.TYPE_BOOLEAN;
                break;
            }
            case BIT_XOR_AGG: 
            case BIT_XNOR_AGG: 
            case BIT_AND_AGG: 
            case BIT_OR_AGG: 
            case BIT_NAND_AGG: 
            case BIT_NOR_AGG: {
                BitFunction.checkArgType(this.args[0]);
                break;
            }
            case ARRAY_AGG: {
                this.type = TypeInfo.getTypeInfo(40, -1L, 0, this.args[0].getType());
                break;
            }
            case ENVELOPE: {
                this.type = TypeInfo.TYPE_GEOMETRY;
                break;
            }
            case JSON_ARRAYAGG: 
            case JSON_OBJECTAGG: {
                this.type = TypeInfo.TYPE_JSON;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return this;
    }

    private static TypeInfo getSumType(TypeInfo type) {
        int valueType = type.getValueType();
        switch (valueType) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TypeInfo.TYPE_BIGINT;
            }
            case 12: {
                return TypeInfo.getTypeInfo(13, 29L, -1, null);
            }
            case 13: {
                return TypeInfo.getTypeInfo(13, type.getPrecision() + 10L, type.getDeclaredScale(), null);
            }
            case 14: {
                return TypeInfo.TYPE_DOUBLE;
            }
            case 15: {
                return TypeInfo.getTypeInfo(16, 27L, -1, null);
            }
            case 16: {
                return TypeInfo.getTypeInfo(16, type.getPrecision() + 10L, -1, null);
            }
        }
        if (DataType.isIntervalType(valueType)) {
            return TypeInfo.getTypeInfo(valueType, 18L, type.getDeclaredScale(), null);
        }
        return null;
    }

    private static TypeInfo getAvgType(TypeInfo type) {
        switch (type.getValueType()) {
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                return TypeInfo.TYPE_DOUBLE;
            }
            case 12: {
                return TypeInfo.getTypeInfo(13, 29L, 10, null);
            }
            case 13: {
                int additionalScale = Math.min(100000 - type.getScale(), Math.min(100000 - (int)type.getPrecision(), 10));
                return TypeInfo.getTypeInfo(13, type.getPrecision() + (long)additionalScale, type.getScale() + additionalScale, null);
            }
            case 15: {
                return TypeInfo.getTypeInfo(16, 27L, -1, null);
            }
            case 16: {
                return TypeInfo.getTypeInfo(16, type.getPrecision() + 10L, -1, null);
            }
            case 22: 
            case 28: {
                return TypeInfo.getTypeInfo(28, type.getDeclaredPrecision(), 0, null);
            }
            case 23: {
                return TypeInfo.getTypeInfo(23, type.getDeclaredPrecision(), 0, null);
            }
            case 24: 
            case 29: 
            case 30: 
            case 31: {
                return TypeInfo.getTypeInfo(31, type.getDeclaredPrecision(), 9, null);
            }
            case 25: 
            case 32: 
            case 33: {
                return TypeInfo.getTypeInfo(33, type.getDeclaredPrecision(), 9, null);
            }
            case 26: 
            case 34: {
                return TypeInfo.getTypeInfo(34, type.getDeclaredPrecision(), 9, null);
            }
            case 27: {
                return TypeInfo.getTypeInfo(27, type.getDeclaredPrecision(), 9, null);
            }
        }
        return null;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.orderByList != null) {
            for (QueryOrderBy o : this.orderByList) {
                o.expression.setEvaluatable(tableFilter, b);
            }
        }
        super.setEvaluatable(tableFilter, b);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        switch (this.aggregateType) {
            case COUNT_ALL: {
                return this.appendTailConditions(builder.append("COUNT(*)"), sqlFlags, false);
            }
            case LISTAGG: {
                return this.getSQLListagg(builder, sqlFlags);
            }
            case ARRAY_AGG: {
                return this.getSQLArrayAggregate(builder, sqlFlags);
            }
            case JSON_OBJECTAGG: {
                return this.getSQLJsonObjectAggregate(builder, sqlFlags);
            }
            case JSON_ARRAYAGG: {
                return this.getSQLJsonArrayAggregate(builder, sqlFlags);
            }
        }
        builder.append(this.aggregateType.name());
        if (this.distinct) {
            builder.append("(DISTINCT ");
        } else {
            builder.append('(');
        }
        Aggregate.writeExpressions(builder, this.args, sqlFlags).append(')');
        if (this.orderByList != null) {
            builder.append(" WITHIN GROUP (");
            Window.appendOrderBy(builder, this.orderByList, sqlFlags, false);
            builder.append(')');
        }
        return this.appendTailConditions(builder, sqlFlags, false);
    }

    private StringBuilder getSQLArrayAggregate(StringBuilder builder, int sqlFlags) {
        builder.append("ARRAY_AGG(");
        if (this.distinct) {
            builder.append("DISTINCT ");
        }
        this.args[0].getUnenclosedSQL(builder, sqlFlags);
        Window.appendOrderBy(builder, this.orderByList, sqlFlags, false);
        builder.append(')');
        return this.appendTailConditions(builder, sqlFlags, false);
    }

    private StringBuilder getSQLListagg(StringBuilder builder, int sqlFlags) {
        builder.append("LISTAGG(");
        if (this.distinct) {
            builder.append("DISTINCT ");
        }
        this.args[0].getUnenclosedSQL(builder, sqlFlags);
        ListaggArguments arguments = (ListaggArguments)this.extraArguments;
        String s = arguments.getSeparator();
        if (s != null) {
            StringUtils.quoteStringSQL(builder.append(", "), s);
        }
        if (arguments.getOnOverflowTruncate()) {
            builder.append(" ON OVERFLOW TRUNCATE ");
            s = arguments.getFilter();
            if (s != null) {
                StringUtils.quoteStringSQL(builder, s).append(' ');
            }
            builder.append(arguments.isWithoutCount() ? "WITHOUT" : "WITH").append(" COUNT");
        }
        builder.append(')');
        builder.append(" WITHIN GROUP (");
        Window.appendOrderBy(builder, this.orderByList, sqlFlags, true);
        builder.append(')');
        return this.appendTailConditions(builder, sqlFlags, false);
    }

    private StringBuilder getSQLJsonObjectAggregate(StringBuilder builder, int sqlFlags) {
        builder.append("JSON_OBJECTAGG(");
        this.args[0].getUnenclosedSQL(builder, sqlFlags).append(": ");
        this.args[1].getUnenclosedSQL(builder, sqlFlags);
        JsonConstructorFunction.getJsonFunctionFlagsSQL(builder, this.flags, false).append(')');
        return this.appendTailConditions(builder, sqlFlags, false);
    }

    private StringBuilder getSQLJsonArrayAggregate(StringBuilder builder, int sqlFlags) {
        builder.append("JSON_ARRAYAGG(");
        if (this.distinct) {
            builder.append("DISTINCT ");
        }
        this.args[0].getUnenclosedSQL(builder, sqlFlags);
        JsonConstructorFunction.getJsonFunctionFlagsSQL(builder, this.flags, true);
        Window.appendOrderBy(builder, this.orderByList, sqlFlags, false);
        builder.append(')');
        return this.appendTailConditions(builder, sqlFlags, false);
    }

    private Index getMinMaxColumnIndex() {
        Expression arg = this.args[0];
        if (arg instanceof ExpressionColumn) {
            ExpressionColumn col = (ExpressionColumn)arg;
            Column column = col.getColumn();
            TableFilter filter = col.getTableFilter();
            if (filter != null) {
                Table table = filter.getTable();
                return table.getIndexForColumn(column, true, false);
            }
        }
        return null;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!super.isEverything(visitor)) {
            return false;
        }
        if (this.filterCondition != null && !this.filterCondition.isEverything(visitor)) {
            return false;
        }
        if (visitor.getType() == 1) {
            switch (this.aggregateType) {
                case COUNT: {
                    if (this.distinct || this.args[0].getNullable() != 0) {
                        return false;
                    }
                }
                case COUNT_ALL: {
                    return visitor.getTable().canGetRowCount(this.select.getSession());
                }
                case MIN: 
                case MAX: {
                    return this.getMinMaxColumnIndex() != null;
                }
                case PERCENTILE_CONT: 
                case PERCENTILE_DISC: {
                    return this.args[0].isConstant() && Percentile.getColumnIndex(this.select.getSession().getDatabase(), this.orderByList.get((int)0).expression) != null;
                }
                case MEDIAN: {
                    if (this.distinct) {
                        return false;
                    }
                    return Percentile.getColumnIndex(this.select.getSession().getDatabase(), this.args[0]) != null;
                }
                case ENVELOPE: {
                    return AggregateDataEnvelope.getGeometryColumnIndex(this.args[0]) != null;
                }
            }
            return false;
        }
        for (Expression arg : this.args) {
            if (arg.isEverything(visitor)) continue;
            return false;
        }
        if (this.orderByList != null) {
            for (QueryOrderBy o : this.orderByList) {
                if (o.expression.isEverything(visitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 1;
        for (Expression arg : this.args) {
            cost += arg.getCost();
        }
        if (this.orderByList != null) {
            for (QueryOrderBy o : this.orderByList) {
                cost += o.expression.getCost();
            }
        }
        if (this.filterCondition != null) {
            cost += this.filterCondition.getCost();
        }
        return cost;
    }

    public Select getSelect() {
        return this.select;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    static {
        Aggregate.addAggregate("COUNT", AggregateType.COUNT);
        Aggregate.addAggregate("SUM", AggregateType.SUM);
        Aggregate.addAggregate("MIN", AggregateType.MIN);
        Aggregate.addAggregate("MAX", AggregateType.MAX);
        Aggregate.addAggregate("AVG", AggregateType.AVG);
        Aggregate.addAggregate("LISTAGG", AggregateType.LISTAGG);
        Aggregate.addAggregate("GROUP_CONCAT", AggregateType.LISTAGG);
        Aggregate.addAggregate("STRING_AGG", AggregateType.LISTAGG);
        Aggregate.addAggregate("STDDEV_SAMP", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV_POP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("STDDEVP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("VAR_POP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VARP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VAR_SAMP", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VAR", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VARIANCE", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("ANY", AggregateType.ANY);
        Aggregate.addAggregate("SOME", AggregateType.ANY);
        Aggregate.addAggregate("BOOL_OR", AggregateType.ANY);
        Aggregate.addAggregate("EVERY", AggregateType.EVERY);
        Aggregate.addAggregate("BOOL_AND", AggregateType.EVERY);
        Aggregate.addAggregate("HISTOGRAM", AggregateType.HISTOGRAM);
        Aggregate.addAggregate("BIT_AND_AGG", AggregateType.BIT_AND_AGG);
        Aggregate.addAggregate("BIT_AND", AggregateType.BIT_AND_AGG);
        Aggregate.addAggregate("BIT_OR_AGG", AggregateType.BIT_OR_AGG);
        Aggregate.addAggregate("BIT_OR", AggregateType.BIT_OR_AGG);
        Aggregate.addAggregate("BIT_XOR_AGG", AggregateType.BIT_XOR_AGG);
        Aggregate.addAggregate("BIT_NAND_AGG", AggregateType.BIT_NAND_AGG);
        Aggregate.addAggregate("BIT_NOR_AGG", AggregateType.BIT_NOR_AGG);
        Aggregate.addAggregate("BIT_XNOR_AGG", AggregateType.BIT_XNOR_AGG);
        Aggregate.addAggregate("COVAR_POP", AggregateType.COVAR_POP);
        Aggregate.addAggregate("COVAR_SAMP", AggregateType.COVAR_SAMP);
        Aggregate.addAggregate("CORR", AggregateType.CORR);
        Aggregate.addAggregate("REGR_SLOPE", AggregateType.REGR_SLOPE);
        Aggregate.addAggregate("REGR_INTERCEPT", AggregateType.REGR_INTERCEPT);
        Aggregate.addAggregate("REGR_COUNT", AggregateType.REGR_COUNT);
        Aggregate.addAggregate("REGR_R2", AggregateType.REGR_R2);
        Aggregate.addAggregate("REGR_AVGX", AggregateType.REGR_AVGX);
        Aggregate.addAggregate("REGR_AVGY", AggregateType.REGR_AVGY);
        Aggregate.addAggregate("REGR_SXX", AggregateType.REGR_SXX);
        Aggregate.addAggregate("REGR_SYY", AggregateType.REGR_SYY);
        Aggregate.addAggregate("REGR_SXY", AggregateType.REGR_SXY);
        Aggregate.addAggregate("RANK", AggregateType.RANK);
        Aggregate.addAggregate("DENSE_RANK", AggregateType.DENSE_RANK);
        Aggregate.addAggregate("PERCENT_RANK", AggregateType.PERCENT_RANK);
        Aggregate.addAggregate("CUME_DIST", AggregateType.CUME_DIST);
        Aggregate.addAggregate("PERCENTILE_CONT", AggregateType.PERCENTILE_CONT);
        Aggregate.addAggregate("PERCENTILE_DISC", AggregateType.PERCENTILE_DISC);
        Aggregate.addAggregate("MEDIAN", AggregateType.MEDIAN);
        Aggregate.addAggregate("ARRAY_AGG", AggregateType.ARRAY_AGG);
        Aggregate.addAggregate("MODE", AggregateType.MODE);
        Aggregate.addAggregate("STATS_MODE", AggregateType.MODE);
        Aggregate.addAggregate("ENVELOPE", AggregateType.ENVELOPE);
        Aggregate.addAggregate("JSON_OBJECTAGG", AggregateType.JSON_OBJECTAGG);
        Aggregate.addAggregate("JSON_ARRAYAGG", AggregateType.JSON_ARRAYAGG);
    }
}

